/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.analyzer;

import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.matter_network.IMatterNetworkClient;
import matteroverdrive.api.network.MatterNetworkTaskState;
import matteroverdrive.data.matter_network.IMatterNetworkEvent;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.handler.SoundHandler;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.analyzer.TileEntityMachineMatterAnalyzer;
import matteroverdrive.matter_network.components.TaskQueueComponent;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskStorePattern;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;

public class ComponentTaskProcessingAnalyzer
extends TaskQueueComponent<MatterNetworkTaskStorePattern, TileEntityMachineMatterAnalyzer>
implements ITickable {
    public static final int PROGRESS_AMOUNT_PER_ITEM = 20;
    public static final int ANALYZE_SPEED = 800;
    public static final int ENERGY_DRAIN_PER_ITEM = 64000;
    public int analyzeTime;
    private boolean isAnalyzing;

    public ComponentTaskProcessingAnalyzer(String name, TileEntityMachineMatterAnalyzer machine, int taskQueueCapacity, int queueId) {
        super(name, machine, taskQueueCapacity, queueId);
    }

    public void func_73660_a() {
        if (!this.getWorld().field_72995_K) {
            this.manageAnalyze();
        }
    }

    private void manageAnalyze() {
        this.isAnalyzing = false;
        if (((TileEntityMachineMatterAnalyzer)this.machine).getRedstoneActive() && !((TileEntityMachineMatterAnalyzer)this.machine).func_70301_a(((TileEntityMachineMatterAnalyzer)this.machine).input_slot).func_190926_b() && ((TileEntityMachineMatterAnalyzer)this.machine).getEnergyStorage().getEnergyStored() > 0 && this.getTaskQueue().remaintingCapacity() > 0 && !this.networkHasPattern(((TileEntityMachineMatterAnalyzer)this.machine).func_70301_a(((TileEntityMachineMatterAnalyzer)this.machine).input_slot))) {
            this.isAnalyzing = true;
        }
        if (this.isAnalyzing() && this.hasEnoughPower()) {
            ((TileEntityMachineMatterAnalyzer)this.machine).getEnergyStorage().extractEnergy(this.getEnergyDrainPerTick(), false);
            ((TileEntityMachineMatterAnalyzer)this.machine).UpdateClientPower();
            if (this.analyzeTime < this.getSpeed()) {
                ++this.analyzeTime;
            } else {
                this.analyzeItem();
                this.analyzeTime = 0;
            }
        }
        if (!this.isAnalyzing()) {
            this.analyzeTime = 0;
        }
    }

    public void analyzeItem() {
        ItemStack itemStack = ((TileEntityMachineMatterAnalyzer)this.machine).func_70301_a(((TileEntityMachineMatterAnalyzer)this.machine).input_slot).func_77946_l();
        itemStack.func_190920_e(1);
        MatterNetworkTaskStorePattern storePattern = new MatterNetworkTaskStorePattern(itemStack, 20);
        storePattern.setState(MatterNetworkTaskState.WAITING);
        if (((TileEntityMachineMatterAnalyzer)this.machine).getNetwork() != null) {
            ((TileEntityMachineMatterAnalyzer)this.machine).getNetwork().post(new IMatterNetworkEvent.Task(storePattern));
        }
        if (storePattern.getState().belowOrEqual(MatterNetworkTaskState.WAITING)) {
            this.addStorePatternTask(storePattern);
        }
        SoundHandler.PlaySoundAt(this.getWorld(), MatterOverdriveSounds.scannerSuccess, SoundCategory.BLOCKS, this.getPos().func_177958_n(), (float)this.getPos().func_177956_o(), (float)this.getPos().func_177952_p());
        ((TileEntityMachineMatterAnalyzer)this.machine).func_70298_a(((TileEntityMachineMatterAnalyzer)this.machine).input_slot, 1);
        ((TileEntityMachineMatterAnalyzer)this.machine).func_70296_d();
    }

    public boolean networkHasPattern(ItemStack stack) {
        for (IMatterNetworkClient client : ((TileEntityMachineMatterAnalyzer)this.machine).getNetwork().getClients()) {
            ItemPattern hasPattern;
            if (!(client instanceof IMatterDatabase) || (hasPattern = ((IMatterDatabase)((Object)client)).getPattern(stack)) == null || hasPattern.getProgress() < 100) continue;
            return true;
        }
        return false;
    }

    public void addStorePatternTask(MatterNetworkTaskStorePattern task) {
        if (this.getTaskQueue().queue(task)) {
            this.sendTaskQueueAddedToWatchers(task.getId());
        }
    }

    public boolean isAnalyzing() {
        return this.isAnalyzing;
    }

    public boolean hasEnoughPower() {
        return ((TileEntityMachineMatterAnalyzer)this.machine).getEnergyStorage().getEnergyStored() >= this.getEnergyDrainPerTick();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readFromNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.analyzeTime = nbt.func_74765_d("AnalyzeTime");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeToNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74777_a("AnalyzeTime", (short)this.analyzeTime);
        }
    }

    public int getSpeed() {
        return (int)Math.round(800.0 * ((TileEntityMachineMatterAnalyzer)this.machine).getUpgradeMultiply(UpgradeTypes.Speed));
    }

    public int getEnergyDrainPerTick() {
        return this.getEnergyDrainMax() / this.getSpeed();
    }

    public int getEnergyDrainMax() {
        return (int)Math.round(64000.0 * ((TileEntityMachineMatterAnalyzer)this.machine).getUpgradeMultiply(UpgradeTypes.PowerUsage));
    }

    public float getProgress() {
        return (float)this.analyzeTime / (float)this.getSpeed();
    }
}

