/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.analyzer;

import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter_network.IMatterNetworkClient;
import matteroverdrive.api.matter_network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.MatterSlot;
import matteroverdrive.data.transport.MatterNetwork;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.analyzer.ComponentMatterNetworkAnalyzer;
import matteroverdrive.machines.analyzer.ComponentTaskProcessingAnalyzer;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityMachineMatterAnalyzer
extends MOTileEntityMachineEnergy
implements ISidedInventory,
IMatterNetworkClient,
IMatterNetworkConnection,
IMatterNetworkDispatcher {
    public static final int ENERGY_STORAGE = 512000;
    public static final int ENERGY_TRANSFER = 1024;
    private static final EnumSet<UpgradeTypes> upgradeTypes = EnumSet.of(UpgradeTypes.PowerUsage, UpgradeTypes.PowerStorage, UpgradeTypes.Speed, UpgradeTypes.PowerStorage);
    public int input_slot = 0;
    private ComponentMatterNetworkAnalyzer networkComponent;
    private ComponentMatterNetworkConfigs componentMatterNetworkConfigs;
    private ComponentTaskProcessingAnalyzer taskProcessingComponent;

    public TileEntityMachineMatterAnalyzer() {
        super(4);
        this.energyStorage.setCapacity(512000);
        this.energyStorage.setMaxExtract(1024);
        this.energyStorage.setMaxReceive(1024);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public void RegisterSlots(Inventory inventory) {
        this.input_slot = inventory.AddSlot(new MatterSlot(true));
        super.RegisterSlots(inventory);
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.componentMatterNetworkConfigs = new ComponentMatterNetworkConfigs(this);
        this.networkComponent = new ComponentMatterNetworkAnalyzer(this);
        this.taskProcessingComponent = new ComponentTaskProcessingAnalyzer("Tasks", this, 1, 0);
        this.addComponent(this.componentMatterNetworkConfigs);
        this.addComponent(this.networkComponent);
        this.addComponent(this.taskProcessingComponent);
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return upgradeTypes.contains((Object)type);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[]{this.input_slot};
        }
        return new int[]{this.input_slot};
    }

    @Override
    public boolean canConnectFromSide(IBlockState blockState, EnumFacing side) {
        EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION);
        return facing.func_176734_d() == side;
    }

    @Override
    public BlockPos getNodePos() {
        return this.func_174877_v();
    }

    @Override
    public boolean establishConnectionFromSide(IBlockState blockState, EnumFacing side) {
        return this.canConnectFromSide(blockState, side);
    }

    @Override
    public void breakConnection(IBlockState blockState, EnumFacing side) {
    }

    @Override
    public MatterNetwork getNetwork() {
        return this.networkComponent.getNetwork();
    }

    @Override
    public void setNetwork(MatterNetwork network) {
        this.networkComponent.setNetwork(network);
    }

    @Override
    public World getNodeWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean canConnectToNetworkNode(IBlockState blockState, IGridNode toNode, EnumFacing direction) {
        return this.networkComponent.canConnectToNetworkNode(blockState, toNode, direction);
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
        if (event instanceof MachineEvent.ActiveChange) {
            this.forceSync();
        }
    }

    @Override
    public boolean getServerActive() {
        return this.taskProcessingComponent.isAnalyzing();
    }

    @Override
    public SoundEvent getSound() {
        return MatterOverdriveSounds.analyzer;
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public float soundVolume() {
        return 0.3f;
    }

    @Override
    public float getProgress() {
        return this.taskProcessingComponent.getProgress();
    }

    public int getEnergyDrainPerTick() {
        return this.taskProcessingComponent.getEnergyDrainPerTick();
    }

    public int getEnergyDrainMax() {
        return this.taskProcessingComponent.getEnergyDrainMax();
    }

    @Override
    public MatterNetworkComponentClient getMatterNetworkComponent() {
        return this.networkComponent;
    }

    @Override
    public MatterNetworkTaskQueue getTaskQueue(int queueID) {
        return this.taskProcessingComponent.getTaskQueue();
    }

    @Override
    public int getTaskQueueCount() {
        return 1;
    }
}

