/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.dimensional_pylon;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter.IMatterHandler;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.data.Inventory;
import matteroverdrive.fx.Lightning;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.MachineComponentAbstract;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.dimensional_pylon.TileEntityMachineDimensionalPylon;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.network.packet.client.PacketSpawnParticle;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ComponentPowerGeneration
extends MachineComponentAbstract<TileEntityMachineDimensionalPylon>
implements ITickable {
    public static int CHARGE_DECREASE_ON_HIT = 16;
    public static int CHARGE_INCREASE_RATE = 64;
    public static int CHARGE_ENERGY_INCREASE = 128;
    public static int CHARGE_MATTER_INCREASE = 5;
    public static int MAX_POWER_GEN_PER_TICK = 256;
    private Random random = new Random();
    private int energyGenPerTick;
    private int matterDrainPerSec;

    public ComponentPowerGeneration(TileEntityMachineDimensionalPylon machine) {
        super(machine);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
    }

    @Override
    public void registerSlots(Inventory inventory) {
    }

    public void func_73660_a() {
        if (!this.getWorld().field_72995_K) {
            this.manageServerLightning();
            this.manageCharge();
            this.managePowerGeneration();
        }
    }

    public void managePowerGeneration() {
        float dimValue = ((TileEntityMachineDimensionalPylon)this.machine).getDimensionalValue();
        float chargePercent = (float)((TileEntityMachineDimensionalPylon)this.machine).charge / (float)TileEntityMachineDimensionalPylon.MAX_CHARGE;
        this.energyGenPerTick = (int)(dimValue * (float)MAX_POWER_GEN_PER_TICK) + (int)((float)CHARGE_ENERGY_INCREASE * chargePercent);
        this.matterDrainPerSec = MathHelper.func_76123_f((float)(dimValue * 20.0f)) + (int)((float)CHARGE_MATTER_INCREASE * chargePercent);
        IMatterHandler storage = ((TileEntityMachineDimensionalPylon)this.machine).getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null);
        if (storage.getMatterStored() >= this.matterDrainPerSec && ((TileEntityMachineDimensionalPylon)this.machine).getEnergyStorage().getEnergyStored() < ((TileEntityMachineDimensionalPylon)this.machine).getEnergyStorage().getMaxEnergyStored()) {
            ((TileEntityMachineDimensionalPylon)this.machine).getEnergyStorage().modifyEnergyStored(this.energyGenPerTick);
            storage.modifyMatterStored(this.matterDrainPerSec);
            ((TileEntityMachineDimensionalPylon)this.machine).UpdateClientPower();
        }
    }

    public void manageServerLightning() {
        if (((TileEntityMachineDimensionalPylon)this.machine).isMainStructureBlock() && ((TileEntityMachineDimensionalPylon)this.machine).isActive()) {
            double dirZ;
            double dirX;
            double y;
            Color color = Reference.COLOR_MATTER.multiplyWithoutAlpha(0.5f);
            float dimValue = ((TileEntityMachineDimensionalPylon)this.machine).getDimensionalValue();
            if (this.getWorld().func_72820_D() % 10L == 0L && this.random.nextFloat() < 0.2f * dimValue) {
                List entities = this.getWorld().func_72872_a(EntityLivingBase.class, new AxisAlignedBB(this.getPos(), this.getPos()).func_72321_a(4.0, 4.0, 4.0));
                for (Entity entity : entities) {
                    boolean hasFullIron = false;
                    if (entity instanceof EntityPlayer) {
                        EntityPlayer entityPlayer = (EntityPlayer)entity;
                        if (entityPlayer.field_71075_bZ.field_75102_a) continue;
                    }
                    if (entity instanceof EntityLivingBase) {
                        hasFullIron = true;
                        for (ItemStack armor : entity.func_184193_aE()) {
                            if (this.isIronMaterial(armor)) continue;
                            hasFullIron = false;
                        }
                    }
                    y = (double)this.getPos().func_177956_o() + this.random.nextDouble() * 2.0;
                    dirX = this.random.nextGaussian() * 0.2;
                    dirZ = this.random.nextGaussian() * 0.2;
                    Vec3d start = new Vec3d((double)this.getPos().func_177958_n() + dirX, y, (double)this.getPos().func_177952_p() + dirZ);
                    Vec3d destination = entity.func_174824_e(1.0f);
                    this.spawnSpark(color, start, destination);
                    if (!hasFullIron) {
                        DamageSource damageSource = new DamageSource("pylon_lightning");
                        entity.func_70097_a(damageSource, dimValue * 2.0f);
                    }
                    if (entity instanceof EntityCreeper) {
                        ((EntityCreeper)entity).func_70829_a(1);
                        continue;
                    }
                    if (!(entity instanceof EntityPig)) continue;
                    entity.func_70077_a(null);
                }
            }
            BlockPos destPos = ((TileEntityMachineDimensionalPylon)this.machine).mainBlock.func_177982_a((int)(this.random.nextGaussian() * 7.0), (int)(this.random.nextGaussian() * 6.0), (int)(this.random.nextGaussian() * 7.0));
            IBlockState state = this.getWorld().func_180495_p(destPos);
            if (state.func_177230_c() == MatterOverdrive.BLOCKS.pylon) {
                TileEntity tileEntity = this.getWorld().func_175625_s(destPos);
                if (tileEntity instanceof TileEntityMachineDimensionalPylon) {
                    TileEntityMachineDimensionalPylon dimensionalPylon = (TileEntityMachineDimensionalPylon)tileEntity;
                    if (dimensionalPylon.mainBlock != null && !dimensionalPylon.mainBlock.equals((Object)((TileEntityMachineDimensionalPylon)this.machine).mainBlock)) {
                        float otherDimValue = dimensionalPylon.getDimensionalValue();
                        if (this.random.nextFloat() < dimValue + otherDimValue) {
                            y = (double)this.getPos().func_177956_o() + this.random.nextDouble() * 2.0;
                            dirX = this.random.nextGaussian() * 0.2;
                            dirZ = this.random.nextGaussian() * 0.2;
                            Vec3d start = new Vec3d((double)this.getPos().func_177958_n() + dirX, y, (double)this.getPos().func_177952_p() + dirZ);
                            Vec3d destination = new Vec3d((Vec3i)((TileEntityMachineDimensionalPylon)tileEntity).mainBlock).func_72441_c(0.0, 1.0, 0.0);
                            this.spawnSpark(color, start, destination);
                            ((TileEntityMachineDimensionalPylon)this.machine).removeCharge(MathHelper.func_76123_f((float)((float)CHARGE_DECREASE_ON_HIT * dimValue)));
                            dimensionalPylon.addCharge(MathHelper.func_76123_f((float)((float)CHARGE_INCREASE_RATE * dimValue)));
                        }
                    }
                }
            } else if (state.func_185904_a().equals(Material.field_151573_f) || state.func_185904_a().equals(Material.field_151573_f)) {
                y = (double)this.getPos().func_177956_o() + this.random.nextDouble() * 2.0;
                dirX = this.random.nextGaussian() * 0.2;
                dirZ = this.random.nextGaussian() * 0.2;
                Vec3d start = new Vec3d((double)this.getPos().func_177958_n() + dirX, y, (double)this.getPos().func_177952_p() + dirZ);
                Vec3d destination = new Vec3d((Vec3i)destPos).func_72441_c(0.5, 0.5, 0.5);
                this.spawnSpark(color, start, destination);
            }
        }
    }

    private void spawnSpark(Color color, Vec3d from, Vec3d to) {
        Lightning lightning = new Lightning(this.getWorld(), from, to, 1.0f, 1.0f);
        lightning.setColorRGBA(color);
        MatterOverdrive.NETWORK.sendToAllAround((IMessage)new PacketSpawnParticle("lightning", new double[]{from.field_72450_a, from.field_72448_b, from.field_72449_c, to.field_72450_a, to.field_72448_b, to.field_72449_c}, 1, RenderParticlesHandler.Blending.LinesAdditive, 0.0f), this.machine, 64.0);
        this.getWorld().func_184148_a(null, to.field_72450_a, to.field_72448_b, to.field_72449_c, MatterOverdriveSounds.fxElectricArc, SoundCategory.BLOCKS, 0.8f + this.random.nextFloat() * 0.2f, 0.8f + this.random.nextFloat() * 0.4f);
    }

    private boolean isIronMaterial(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() instanceof ItemArmor) {
            String materialName = ((ItemArmor)itemStack.func_77973_b()).func_82812_d().func_179242_c();
            return materialName.matches("(?i)(iron|chainmail|tritanium)");
        }
        return false;
    }

    public void manageCharge() {
        if (((TileEntityMachineDimensionalPylon)this.machine).charge > 0 && this.getWorld().func_72820_D() % 40L == 0L) {
            ((TileEntityMachineDimensionalPylon)this.machine).charge -= 1 + Math.round((float)((TileEntityMachineDimensionalPylon)this.machine).charge * 0.005f);
            ((TileEntityMachineDimensionalPylon)this.machine).forceSync();
        }
    }

    public int getEnergyGenPerTick() {
        return this.energyGenPerTick;
    }

    public int getMatterDrainPerSec() {
        return this.matterDrainPerSec;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void onMachineEvent(MachineEvent event) {
    }
}

