/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.pattern_monitor;

import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.container.matter_network.IMatterDatabaseMonitor;
import matteroverdrive.container.matter_network.IMatterDatabaseWatcher;
import matteroverdrive.data.matter_network.IMatterNetworkEvent;
import matteroverdrive.data.matter_network.MatterDatabaseEvent;
import matteroverdrive.machines.pattern_monitor.TileEntityMachinePatternMonitor;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;

public class ComponentMatterNetworkPatternMonitor
extends MatterNetworkComponentClient<TileEntityMachinePatternMonitor> {
    public ComponentMatterNetworkPatternMonitor(TileEntityMachinePatternMonitor patternMonitor) {
        super(patternMonitor);
    }

    @Override
    public void onNetworkEvent(IMatterNetworkEvent event) {
        if (event instanceof IMatterNetworkEvent.ClientAdded) {
            this.onClientAdded((IMatterNetworkEvent.ClientAdded)event);
        } else if (event instanceof IMatterNetworkEvent.AddedToNetwork) {
            this.onAddedToNetwork((IMatterNetworkEvent.AddedToNetwork)event);
        } else if (event instanceof IMatterNetworkEvent.RemovedFromNetwork) {
            this.onRemovedFromNetwork((IMatterNetworkEvent.RemovedFromNetwork)event);
        } else if (event instanceof IMatterNetworkEvent.ClientRemoved) {
            this.onClientRemoved((IMatterNetworkEvent.ClientRemoved)event);
        } else if (event instanceof MatterDatabaseEvent) {
            this.onPatternChange((MatterDatabaseEvent)((Object)event));
        }
    }

    private void onRemovedFromNetwork(IMatterNetworkEvent.RemovedFromNetwork event) {
        ((TileEntityMachinePatternMonitor)this.rootClient).getWatchers().stream().filter(watcher -> watcher instanceof IMatterDatabaseWatcher).forEach(watcher -> ((IMatterDatabaseWatcher)watcher).onDisconnectFromNetwork((IMatterDatabaseMonitor)((Object)this.rootClient)));
    }

    private void onAddedToNetwork(IMatterNetworkEvent.AddedToNetwork event) {
        ((TileEntityMachinePatternMonitor)this.rootClient).getWatchers().stream().filter(watcher -> watcher instanceof IMatterDatabaseWatcher).forEach(watcher -> ((IMatterDatabaseWatcher)watcher).onConnectToNetwork((IMatterDatabaseMonitor)((Object)this.rootClient)));
    }

    private void onClientAdded(IMatterNetworkEvent.ClientAdded event) {
        if (event.client instanceof IMatterDatabase) {
            MatterDatabaseEvent.Added databaseEvent = new MatterDatabaseEvent.Added((IMatterDatabase)((Object)event.client));
            ((TileEntityMachinePatternMonitor)this.rootClient).getWatchers().stream().filter(watcher -> watcher instanceof IMatterDatabaseWatcher).forEach(watcher -> ((IMatterDatabaseWatcher)watcher).onDatabaseEvent(databaseEvent));
        }
    }

    private void onClientRemoved(IMatterNetworkEvent.ClientRemoved event) {
        if (event.client instanceof IMatterDatabase) {
            MatterDatabaseEvent.Removed databaseEvent = new MatterDatabaseEvent.Removed((IMatterDatabase)((Object)event.client));
            ((TileEntityMachinePatternMonitor)this.rootClient).getWatchers().stream().filter(watcher -> watcher instanceof IMatterDatabaseWatcher).forEach(watcher -> ((IMatterDatabaseWatcher)watcher).onDatabaseEvent(databaseEvent));
        }
    }

    private void onPatternChange(MatterDatabaseEvent event) {
        ((TileEntityMachinePatternMonitor)this.rootClient).getWatchers().stream().filter(watcher -> watcher instanceof IMatterDatabaseWatcher).forEach(watcher -> ((IMatterDatabaseWatcher)watcher).onDatabaseEvent(event));
    }
}

