/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.replicator;

import java.util.EnumSet;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter_network.IMatterNetworkClient;
import matteroverdrive.api.matter_network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkDispatcher;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.blocks.BlockReplicator;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.DatabaseSlot;
import matteroverdrive.data.inventory.RemoveOnlySlot;
import matteroverdrive.data.inventory.ShieldingSlot;
import matteroverdrive.data.transport.MatterNetwork;
import matteroverdrive.fx.ReplicatorParticle;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.components.ComponentMatterNetworkConfigs;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.machines.replicator.ComponentMatterNetworkReplicator;
import matteroverdrive.machines.replicator.ComponentTaskProcessingReplicator;
import matteroverdrive.matter_network.MatterNetworkTaskQueue;
import matteroverdrive.matter_network.components.MatterNetworkComponentClient;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.util.MOBlockHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityMachineReplicator
extends MOTileEntityMachineMatter
implements IMatterNetworkClient,
IMatterNetworkConnection,
IMatterNetworkDispatcher {
    public static final int MATTER_TRANSFER = 128;
    public static final int REPLICATION_ANIMATION_TIME = 60;
    public static final int RADIATION_DAMAGE_DELAY = 5;
    public static final int RADIATION_RANGE = 8;
    private static final EnumSet<UpgradeTypes> upgradeTypes = EnumSet.of(UpgradeTypes.PowerStorage, UpgradeTypes.Speed, UpgradeTypes.Fail, UpgradeTypes.PowerUsage, UpgradeTypes.MatterStorage);
    public static int MATTER_STORAGE = 1024;
    public static int ENERGY_STORAGE = 512000;
    public int OUTPUT_SLOT_ID = 0;
    public int SECOND_OUTPUT_SLOT_ID = 1;
    public int DATABASE_SLOT_ID = 2;
    public int SHIELDING_SLOT_ID = 3;
    @SideOnly(value=Side.CLIENT)
    private boolean isPlayingReplicateAnimation;
    @SideOnly(value=Side.CLIENT)
    private int replicateAnimationCounter;
    private ComponentMatterNetworkReplicator networkComponent;
    private ComponentTaskProcessingReplicator taskProcessingComponent;
    private ComponentMatterNetworkConfigs matterNetworkConfigs;

    public TileEntityMachineReplicator() {
        super(4);
        this.energyStorage.setCapacity(ENERGY_STORAGE);
        this.energyStorage.setMaxExtract(ENERGY_STORAGE);
        this.energyStorage.setMaxReceive(ENERGY_STORAGE);
        this.matterStorage.setCapacity(MATTER_STORAGE);
        this.matterStorage.setMaxExtract(128);
        this.matterStorage.setMaxExtract(0);
        this.playerSlotsMain = true;
        this.playerSlotsHotbar = true;
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.OUTPUT_SLOT_ID = inventory.AddSlot(new RemoveOnlySlot(false).setSendToClient(true));
        this.SECOND_OUTPUT_SLOT_ID = inventory.AddSlot(new RemoveOnlySlot(false));
        this.DATABASE_SLOT_ID = inventory.AddSlot(new DatabaseSlot(true));
        this.SHIELDING_SLOT_ID = inventory.AddSlot(new ShieldingSlot(true));
        super.RegisterSlots(inventory);
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.networkComponent = new ComponentMatterNetworkReplicator(this);
        this.matterNetworkConfigs = new ComponentMatterNetworkConfigs(this);
        this.taskProcessingComponent = new ComponentTaskProcessingReplicator("Replication Tasks", this, 1);
        this.addComponent(this.networkComponent);
        this.addComponent(this.matterNetworkConfigs);
        this.addComponent(this.taskProcessingComponent);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.manageSpawnParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void beginSpawnParticles() {
        this.replicateAnimationCounter = 60;
    }

    @SideOnly(value=Side.CLIENT)
    public void manageSpawnParticles() {
        if (this.replicateAnimationCounter > 0) {
            this.isPlayingReplicateAnimation = true;
            this.SpawnReplicateParticles(60 - this.replicateAnimationCounter);
            --this.replicateAnimationCounter;
        } else if (this.isPlayingReplicateAnimation) {
            this.isPlayingReplicateAnimation = false;
            this.forceSync();
        }
        if (this.isActive() && this.getBlockType(BlockReplicator.class).hasVentParticles) {
            this.SpawnVentParticles(0.05f, MOBlockHelper.getLeftSide((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION)), 1);
            this.SpawnVentParticles(0.05f, MOBlockHelper.getLeftSide((EnumFacing)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION)), 1);
        }
    }

    boolean putInOutput(ItemStack item) {
        int newStackSize;
        if (this.func_70301_a(this.OUTPUT_SLOT_ID).func_190926_b()) {
            this.func_70299_a(this.OUTPUT_SLOT_ID, item);
            return true;
        }
        if (this.func_70301_a(this.OUTPUT_SLOT_ID).func_77985_e() && this.func_70301_a(this.OUTPUT_SLOT_ID).func_77952_i() == item.func_77952_i() && this.func_70301_a(this.OUTPUT_SLOT_ID).func_77973_b() == item.func_77973_b() && (newStackSize = this.func_70301_a(this.OUTPUT_SLOT_ID).func_190916_E() + 1) <= this.func_70301_a(this.OUTPUT_SLOT_ID).func_77976_d()) {
            this.func_70301_a(this.OUTPUT_SLOT_ID).func_190920_e(newStackSize);
            return true;
        }
        return false;
    }

    boolean failReplicate(int amount) {
        ItemStack stack = this.func_70301_a(this.SECOND_OUTPUT_SLOT_ID);
        if (stack.func_190926_b()) {
            stack = new ItemStack((Item)MatterOverdrive.ITEMS.matter_dust);
            MatterOverdrive.ITEMS.matter_dust.setMatter(stack, amount);
            this.func_70299_a(this.SECOND_OUTPUT_SLOT_ID, stack);
            return true;
        }
        if (this.canReplicateIntoSecoundOutput(amount)) {
            stack.func_190917_f(1);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void SpawnReplicateParticles(int startTime) {
        double time = (double)startTime / 60.0;
        double gravity = MOMathHelper.easeIn(time, 0.02, 0.2, 1.0);
        int age = (int)Math.round(MOMathHelper.easeIn(time, 2.0, 10.0, 1.0));
        int count = (int)Math.round(MOMathHelper.easeIn(time, 1.0, 20.0, 1.0));
        for (int i = 0; i < count; ++i) {
            float speed = 0.05f;
            Vector3f pos = MOMathHelper.randomSpherePoint((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, new Vec3d(0.5, 0.5, 0.5), this.field_145850_b.field_73012_v);
            Vector3f dir = new Vector3f(random.nextFloat() * 2.0f - 1.0f, (random.nextFloat() * 2.0f - 1.0f) * 0.05f, random.nextFloat() * 2.0f - 1.0f);
            dir.scale(speed);
            ReplicatorParticle replicatorParticle = new ReplicatorParticle(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), dir.getX(), dir.getY(), dir.getZ());
            replicatorParticle.setCenter((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
            replicatorParticle.setParticleAge(age);
            replicatorParticle.setPointGravityScale(gravity);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)replicatorParticle);
        }
    }

    @Override
    public boolean getServerActive() {
        return this.taskProcessingComponent.isReplicating();
    }

    public void manageRadiation() {
        int shielding = this.getShielding();
        if (shielding >= 5) {
            return;
        }
        AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v().func_177982_a(-8, -8, -8), this.func_174877_v().func_177982_a(8, 8, 8));
        List entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, bb);
        for (Object e : entities) {
            if (!(e instanceof EntityLivingBase)) continue;
            EntityLivingBase l = (EntityLivingBase)e;
            double distance = Math.sqrt(this.func_174877_v().func_177951_i((Vec3i)l.func_180425_c())) / 8.0;
            distance = MathHelper.func_151237_a((double)distance, (double)0.0, (double)1.0);
            distance = 1.0 - distance;
            PotionEffect[] effects = new PotionEffect[3];
            effects[0] = new PotionEffect(MobEffects.field_76431_k, (int)Math.round(Math.pow(5.0, distance *= (double)(5 - shielding))), 0);
            effects[0] = new PotionEffect(MobEffects.field_76437_t, (int)Math.round(Math.pow(10.0, distance)), 0);
            effects[1] = new PotionEffect(MobEffects.field_76438_s, (int)Math.round(Math.pow(12.0, distance)), 0);
            effects[2] = new PotionEffect(MobEffects.field_76436_u, (int)Math.round(Math.pow(5.0, distance)), 0);
            for (PotionEffect effect : effects) {
                if (effect.func_76459_b() <= 0) continue;
                l.func_70690_d(effect);
            }
        }
    }

    boolean canReplicateIntoOutput(ItemStack itemStack) {
        return !itemStack.func_190926_b() && (this.func_70301_a(this.OUTPUT_SLOT_ID).func_190926_b() || itemStack.func_77969_a(this.func_70301_a(this.OUTPUT_SLOT_ID)) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)this.func_70301_a(this.OUTPUT_SLOT_ID)) && this.func_70301_a(this.OUTPUT_SLOT_ID).func_190916_E() < this.func_70301_a(this.OUTPUT_SLOT_ID).func_77976_d());
    }

    boolean canReplicateIntoSecoundOutput(int matter) {
        ItemStack stack = this.func_70301_a(this.SECOND_OUTPUT_SLOT_ID);
        if (stack.func_190926_b()) {
            return true;
        }
        return stack.func_77973_b() == MatterOverdrive.ITEMS.matter_dust && stack.func_77952_i() == matter && stack.func_190916_E() < stack.func_77976_d();
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return upgradeTypes.contains((Object)type);
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{this.OUTPUT_SLOT_ID, this.SECOND_OUTPUT_SLOT_ID};
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack item, EnumFacing side) {
        return true;
    }

    @Override
    public ItemStack func_70298_a(int slot, int size) {
        ItemStack s = super.func_70298_a(slot, size);
        this.forceSync();
        return s;
    }

    @Override
    public boolean canConnectFromSide(IBlockState blockState, EnumFacing side) {
        return ((EnumFacing)blockState.func_177229_b((IProperty)MOBlock.PROPERTY_DIRECTION)).func_176734_d().equals((Object)side);
    }

    @Override
    public BlockPos getNodePos() {
        return this.func_174877_v();
    }

    @Override
    public boolean establishConnectionFromSide(IBlockState blockState, EnumFacing side) {
        return this.networkComponent.establishConnectionFromSide(blockState, side);
    }

    @Override
    public void breakConnection(IBlockState blockState, EnumFacing side) {
        this.networkComponent.breakConnection(blockState, side);
    }

    @Override
    public MatterNetwork getNetwork() {
        return this.networkComponent.getNetwork();
    }

    @Override
    public void setNetwork(MatterNetwork network) {
        this.networkComponent.setNetwork(network);
    }

    @Override
    public World getNodeWorld() {
        return this.func_145831_w();
    }

    @Override
    public boolean canConnectToNetworkNode(IBlockState blockState, IGridNode toNode, EnumFacing direction) {
        return this.networkComponent.canConnectToNetworkNode(blockState, toNode, direction);
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    private int getShielding() {
        if (this.func_70301_a(this.SHIELDING_SLOT_ID) != null && this.func_70301_a(this.SHIELDING_SLOT_ID).func_77973_b() == MatterOverdrive.ITEMS.tritanium_plate) {
            return this.func_70301_a(this.SHIELDING_SLOT_ID).func_190916_E();
        }
        return 0;
    }

    @Override
    public SoundEvent getSound() {
        return MatterOverdriveSounds.machine;
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public float soundVolume() {
        return 1.0f;
    }

    @Override
    public float getProgress() {
        return this.taskProcessingComponent.getReplicateProgress();
    }

    public int getTaskReplicateCount() {
        if (this.taskProcessingComponent.getTaskQueue().peek() != null) {
            return ((MatterNetworkTaskReplicatePattern)this.taskProcessingComponent.getTaskQueue().peek()).getAmount();
        }
        return 0;
    }

    @Override
    public MatterNetworkComponentClient getMatterNetworkComponent() {
        return this.networkComponent;
    }

    @Override
    public MatterNetworkTaskQueue getTaskQueue(int queueID) {
        return this.taskProcessingComponent.getTaskQueue();
    }

    @Override
    public int getTaskQueueCount() {
        return 1;
    }

    public int getEnergyDrainPerTick() {
        return this.taskProcessingComponent.getEnergyDrainPerTick();
    }

    public int getEnergyDrainMax() {
        return this.taskProcessingComponent.getEnergyDrainMax();
    }
}

