/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines.transporter;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.events.MOEventTransport;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.transport.ITransportList;
import matteroverdrive.api.transport.TransportLocation;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.TeleportFlashDriveSlot;
import matteroverdrive.fx.ReplicatorParticle;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.machines.transporter.components.ComponentComputers;
import matteroverdrive.network.packet.client.PacketSyncTransportProgress;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class TileEntityMachineTransporter
extends MOTileEntityMachineMatter
implements ITransportList {
    public static final int MAX_ENTETIES_PRE_TRANSPORT = 3;
    public static final int TRANSPORT_TIME = 70;
    public static final int TRANSPORT_DELAY = 80;
    public static final int ENERGY_STORAGE = 1024000;
    public static final int MAX_ENERGY_EXTRACT = 32000;
    public static final int ENERGY_PER_UNIT = 16;
    private static final EnumSet<UpgradeTypes> upgradeTypes = EnumSet.of(UpgradeTypes.PowerUsage, UpgradeTypes.Speed, UpgradeTypes.Range, UpgradeTypes.PowerStorage);
    private static final int TRANSPORT_RANGE = 32;
    public final List<TransportLocation> locations;
    public int selectedLocation;
    public int usbSlotID;
    int transportTimer;
    long transportTracker;
    private ComponentComputers computerComponent;

    public TileEntityMachineTransporter() {
        super(5);
        this.energyStorage.setCapacity(1024000);
        this.energyStorage.setMaxExtract(32000);
        this.matterStorage.setCapacity(512);
        this.locations = new ArrayList<TransportLocation>();
        this.selectedLocation = 0;
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        super.RegisterSlots(inventory);
        this.usbSlotID = inventory.AddSlot(new TeleportFlashDriveSlot(true));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
        if (categories.contains((Object)MachineNBTCategory.CONFIGS)) {
            this.writeLocations(nbt);
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
        if (categories.contains((Object)MachineNBTCategory.CONFIGS)) {
            this.readLocations(nbt);
        }
    }

    public void readLocations(NBTTagCompound nbt) {
        this.locations.clear();
        NBTTagList locationsList = nbt.func_150295_c("transportLocations", 10);
        for (int i = 0; i < locationsList.func_74745_c(); ++i) {
            this.locations.add(new TransportLocation(locationsList.func_150305_b(i)));
        }
        this.selectedLocation = nbt.func_74762_e("selectedTransport");
    }

    public void writeLocations(NBTTagCompound nbt) {
        NBTTagList locationsList = new NBTTagList();
        for (TransportLocation location : this.locations) {
            NBTTagCompound positionTag = new NBTTagCompound();
            location.writeToNBT(positionTag);
            locationsList.func_74742_a((NBTBase)positionTag);
        }
        nbt.func_74782_a("transportLocations", (NBTBase)locationsList);
        nbt.func_74768_a("selectedTransport", this.selectedLocation);
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        super.writeToDropItem(itemStack);
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        this.writeLocations(itemStack.func_77978_p());
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        super.readFromPlaceItem(itemStack);
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        this.readLocations(itemStack.func_77978_p());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.manageTeleportation();
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.computerComponent = new ComponentComputers(this);
        this.addComponent(this.computerComponent);
    }

    void manageTeleportation() {
        block9: {
            TransportLocation position;
            List entities;
            block7: {
                block8: {
                    entities = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v(), this.func_174877_v().func_177982_a(1, 2, 1)));
                    position = this.getSelectedLocation();
                    if (this.field_145850_b.field_72995_K) break block7;
                    if (this.getEnergyStorage().getEnergyStored() <= this.getEnergyDrain() || entities.size() <= 0 || !this.isLocationValid(this.getSelectedLocation())) break block8;
                    if (this.transportTracker < this.field_145850_b.func_82737_E()) {
                        ++this.transportTimer;
                        if (this.transportTimer >= this.getSpeed()) {
                            for (int i = 0; i < Math.min(entities.size(), 3); ++i) {
                                this.Teleport((Entity)entities.get(i), position);
                                this.transportTracker = this.field_145850_b.func_82737_E() + (long)this.getTransportDelay();
                            }
                            this.energyStorage.modifyEnergyStored(-this.getEnergyDrain());
                            this.transportTimer = 0;
                            MatterOverdrive.NETWORK.sendToDimention((IMessage)new PacketSyncTransportProgress(this), this.field_145850_b);
                        } else {
                            MatterOverdrive.NETWORK.sendToAllAround((IMessage)new PacketSyncTransportProgress(this), this, 32.0);
                        }
                    }
                    break block9;
                }
                if (this.transportTimer == 0) break block9;
                this.transportTimer = 0;
                MatterOverdrive.NETWORK.sendToDimention((IMessage)new PacketSyncTransportProgress(this), this.field_145850_b);
                break block9;
            }
            if (this.transportTimer > 0) {
                for (Entity entity : entities) {
                    this.SpawnReplicateParticles(entity, new Vector3f((float)entity.field_70165_t, (float)this.func_174877_v().func_177956_o(), (float)entity.field_70161_v));
                }
                for (Entity entity : entities) {
                    this.SpawnReplicateParticles(entity, new Vector3f((float)position.pos.func_177958_n(), (float)position.pos.func_177956_o(), (float)position.pos.func_177952_p()));
                }
            }
        }
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    public void Teleport(Entity entity, TransportLocation position) {
        if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventTransport(this.func_174877_v(), position, entity))) {
            if (entity instanceof EntityLivingBase) {
                entity.func_70634_a((double)position.pos.func_177958_n(), (double)(position.pos.func_177956_o() + 1), (double)position.pos.func_177952_p());
            } else {
                entity.func_70107_b((double)position.pos.func_177958_n(), (double)(position.pos.func_177956_o() + 1), (double)position.pos.func_177952_p());
            }
        }
    }

    public TransportLocation getSelectedLocation() {
        if (this.selectedLocation < this.locations.size() && this.selectedLocation >= 0) {
            TransportLocation location = this.locations.get(this.selectedLocation);
            int range = this.getTransportRange();
            return location;
        }
        return new TransportLocation(this.func_174877_v(), "Unknown");
    }

    public boolean isLocationValid(TransportLocation location) {
        return (location.pos.func_177958_n() != this.func_174877_v().func_177958_n() || location.pos.func_177956_o() >= this.func_174877_v().func_177956_o() + 4 || location.pos.func_177956_o() <= this.func_174877_v().func_177956_o() - 4 || location.pos.func_177952_p() != this.func_174877_v().func_177952_p()) && location.getDistance(this.func_174877_v()) < this.getTransportRange();
    }

    public void setSelectedLocation(BlockPos pos, String name) {
        if (this.selectedLocation < this.locations.size() && this.selectedLocation >= 0) {
            TransportLocation location = this.locations.get(this.selectedLocation);
            if (location != null) {
                location.setPosition(pos);
                location.setName(name);
            } else {
                this.locations.set(this.selectedLocation, new TransportLocation(pos, name));
            }
        } else {
            this.selectedLocation = 0;
            this.locations.add(new TransportLocation(pos, name));
        }
    }

    public void addNewLocation(BlockPos pos, String name) {
        this.locations.add(new TransportLocation(pos, name));
    }

    public void removeLocation(int at) {
        if (at < this.locations.size() && at >= 0) {
            this.locations.remove(at);
            this.selectedLocation = MathHelper.func_76125_a((int)this.selectedLocation, (int)0, (int)(this.locations.size() - 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void SpawnReplicateParticles(Entity entity, Vector3f p) {
        double entityRadius = entity.field_70130_N;
        double entityArea = Math.max(entityRadius * (double)entity.field_70131_O, 0.3);
        double radiusX = entityRadius + random.nextDouble() * (double)0.2f;
        double radiusZ = entityRadius + random.nextDouble() * (double)0.2f;
        double time = Math.min((double)this.transportTimer / (double)this.getTransportDelay(), 1.0);
        double gravity = 0.015f;
        int age = (int)Math.round(MOMathHelper.easeIn(time, 5.0, 15.0, 1.0));
        int count = (int)Math.round(MOMathHelper.easeIn(time, 2.0, entityArea * 15.0, 1.0));
        for (int i = 0; i < count; ++i) {
            float speed = random.nextFloat() * 0.05f + 0.15f;
            float height = p.y + 1.0f + random.nextFloat() * entity.field_70131_O;
            Vector3f origin = new Vector3f(p.x, height, p.z);
            Vector3f pos = MOMathHelper.randomSpherePoint(origin.x, origin.y, origin.z, new Vec3d(radiusX, 0.0, radiusZ), random);
            Vector3f dir = Vector3f.cross((Vector3f)Vector3f.sub((Vector3f)origin, (Vector3f)pos, null), (Vector3f)new Vector3f(0.0f, 1.0f, 0.0f), null);
            dir.scale(speed);
            ReplicatorParticle replicatorParticle = new ReplicatorParticle(this.field_145850_b, pos.x, pos.y, pos.z, dir.x, dir.y, dir.z);
            replicatorParticle.setCenter(origin.x, origin.y, origin.z);
            replicatorParticle.setParticleAge(age);
            replicatorParticle.setPointGravityScale(gravity);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)replicatorParticle);
        }
    }

    public int getEnergyDrain() {
        TransportLocation location = this.getSelectedLocation();
        return (int)Math.round(this.getUpgradeMultiply(UpgradeTypes.PowerUsage) * (double)(location.getDistance(this.func_174877_v()) * 16));
    }

    private int getSpeed() {
        return (int)Math.round(this.getUpgradeMultiply(UpgradeTypes.Speed) * 70.0);
    }

    private int getTransportDelay() {
        return (int)Math.round(this.getUpgradeMultiply(UpgradeTypes.Speed) * 80.0);
    }

    public int getTransportRange() {
        return (int)Math.round(this.getUpgradeMultiply(UpgradeTypes.Range) * 32.0);
    }

    @Override
    public SoundEvent getSound() {
        return MatterOverdriveSounds.transporter;
    }

    @Override
    public boolean hasSound() {
        return true;
    }

    @Override
    public boolean getServerActive() {
        return this.transportTimer > 0;
    }

    @Override
    public float soundVolume() {
        return 0.5f;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return upgradeTypes.contains((Object)type);
    }

    public int getTransportTime() {
        return this.transportTimer;
    }

    public void setTransportTime(int time) {
        this.transportTimer = time;
    }

    @Override
    public List<TransportLocation> getPositions() {
        return this.locations;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (facing != EnumFacing.UP && (capability == MatterOverdriveCapabilities.MATTER_HANDLER || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != EnumFacing.UP && (capability == MatterOverdriveCapabilities.MATTER_HANDLER || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return (T)this.matterStorage;
        }
        return super.getCapability(capability, facing);
    }
}

