/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.tasks;

import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MatterNetworkTaskReplicatePattern
extends MatterNetworkTask {
    ItemPattern pattern;
    int amount;

    public MatterNetworkTaskReplicatePattern() {
        this.pattern = new ItemPattern();
    }

    public MatterNetworkTaskReplicatePattern(short itemID, short itemMetadata, byte amount) {
        this.pattern = new ItemPattern(itemID, (int)itemMetadata);
        this.amount = amount;
    }

    public MatterNetworkTaskReplicatePattern(ItemPattern pattern, int amount) {
        this.pattern = pattern;
        this.amount = amount;
    }

    @Override
    protected void init() {
        this.setUnlocalizedName("replicate_pattern");
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        if (compound != null) {
            this.pattern.readFromNBT(compound.func_74775_l("Pattern"));
            this.amount = compound.func_74765_d("amount");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        super.writeToNBT(compound);
        compound.func_74777_a("amount", (short)this.amount);
        if (compound != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.pattern.writeToNBT(tagCompound);
            compound.func_74782_a("Pattern", (NBTBase)tagCompound);
        }
    }

    @Override
    public String getName() {
        return String.format("[%s] %s", this.amount, MOStringHelper.translateToLocal(this.pattern.getItem().func_77658_a() + ".name", new Object[0]));
    }

    public ItemPattern getPattern() {
        return this.pattern;
    }

    @Override
    public boolean isValid(World world) {
        if (!super.isValid(world)) {
            return false;
        }
        return MatterHelper.getMatterAmountFromItem(this.pattern.toItemStack(false)) > 0;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }
}

