/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.multiblock;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.multiblock.IMultiBlockTile;
import matteroverdrive.multiblock.MultiBlockTileStructureAbstract;

public class MultiBlockTileStructureMachine
extends MultiBlockTileStructureAbstract {
    private final HashSet<IMultiBlockTile> tiles = new HashSet();
    private MOTileEntityMachine machine;

    public MultiBlockTileStructureMachine(MOTileEntityMachine machine) {
        this.machine = machine;
    }

    @Override
    public boolean addMultiBlockTile(IMultiBlockTile tile) {
        if (tile != null && !this.containsMultiBlockTile(tile) && tile.canJoinMultiBlockStructure(this)) {
            tile.setMultiBlockTileStructure(this);
            return this.tiles.add(tile);
        }
        return false;
    }

    public void update() {
        Iterator<IMultiBlockTile> iterator = this.tiles.iterator();
        while (iterator.hasNext()) {
            IMultiBlockTile tile = iterator.next();
            if (tile == null || !tile.isTileInvalid()) continue;
            tile.setMultiBlockTileStructure(null);
            iterator.remove();
        }
    }

    public void invalidate() {
        Iterator<IMultiBlockTile> iterator = this.tiles.iterator();
        while (iterator.hasNext()) {
            iterator.next().setMultiBlockTileStructure(null);
            iterator.remove();
        }
        this.machine = null;
    }

    @Override
    public void removeMultiBlockTile(IMultiBlockTile tile) {
        this.tiles.remove(tile);
        tile.setMultiBlockTileStructure(null);
    }

    @Override
    public boolean containsMultiBlockTile(IMultiBlockTile tile) {
        return this.tiles.contains(tile);
    }

    public MOTileEntityMachine getMachine() {
        return this.machine;
    }

    public Collection<IMultiBlockTile> getTiles() {
        return this.tiles;
    }

    public boolean isInvalid() {
        return this.machine == null || this.machine.func_145837_r();
    }
}

