/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client;

import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketUpdatePlasmaBolt
extends PacketAbstract {
    int boltID;
    double posX;
    float posY;
    double posZ;

    public PacketUpdatePlasmaBolt() {
    }

    public PacketUpdatePlasmaBolt(int boltID, double posX, double posY, double posZ) {
        this.boltID = boltID;
        this.posX = posX;
        this.posY = (float)posY;
        this.posZ = posZ;
    }

    public void fromBytes(ByteBuf buf) {
        this.boltID = buf.readInt();
        this.posX = buf.readDouble();
        this.posY = buf.readFloat();
        this.posZ = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.boltID);
        buf.writeDouble(this.posX);
        buf.writeFloat(this.posY);
        buf.writeDouble(this.posZ);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketUpdatePlasmaBolt> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketUpdatePlasmaBolt message, MessageContext ctx) {
            PlasmaBolt bolt = ((ClientWeaponHandler)MatterOverdrive.PROXY.getWeaponHandler()).getPlasmaBolt(message.boltID);
            if (bolt instanceof PlasmaBolt) {
                bolt.func_70107_b(message.posX, message.posY, message.posZ);
            }
        }
    }
}

