/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client.quest;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.gui.GuiDataPad;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import matteroverdrive.util.MOEnumHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSyncQuests
extends PacketAbstract {
    int questTypes;
    NBTTagCompound data = new NBTTagCompound();

    public PacketSyncQuests() {
    }

    public PacketSyncQuests(PlayerQuestData questData, EnumSet<PlayerQuestData.DataType> dataTypes) {
        this();
        questData.writeToNBT(this.data, dataTypes);
        this.questTypes = MOEnumHelper.encode(dataTypes);
    }

    public void fromBytes(ByteBuf buf) {
        this.questTypes = buf.readInt();
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.questTypes);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketSyncQuests> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketSyncQuests message, MessageContext ctx) {
            OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)player);
            if (extendedProperties != null && extendedProperties.getQuestData() != null) {
                extendedProperties.getQuestData().readFromNBT(message.data, MOEnumHelper.decode(message.questTypes, PlayerQuestData.DataType.class));
            }
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiDataPad) {
                ((GuiDataPad)Minecraft.func_71410_x().field_71462_r).refreshQuests(extendedProperties);
            }
        }
    }
}

