/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketMatterScannerUpdate
extends PacketAbstract {
    private ItemPattern selected;
    private short page;
    private short slot;

    public PacketMatterScannerUpdate() {
    }

    public PacketMatterScannerUpdate(ItemStack scanner, short slot) {
        this.selected = MatterScanner.getSelectedAsPattern(scanner);
        if (scanner.func_77942_o()) {
            this.page = scanner.func_77978_p().func_74771_c("page");
        }
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        this.selected = ItemPattern.fromBuffer(buf);
        this.page = buf.readShort();
        this.slot = buf.readShort();
    }

    public void toBytes(ByteBuf buf) {
        ItemPattern.writeToBuffer(buf, this.selected);
        buf.writeShort((int)this.page);
        buf.writeShort((int)this.slot);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketMatterScannerUpdate> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketMatterScannerUpdate message, MessageContext ctx) {
            ItemStack scanner;
            if (message.slot < player.field_71071_by.func_70302_i_() && MatterHelper.isMatterScanner(scanner = player.field_71071_by.func_70301_a((int)message.slot))) {
                MatterScanner.setSelected(scanner, message.selected);
                if (scanner.func_77942_o()) {
                    scanner.func_77978_p().func_74777_a("page", message.page);
                }
            }
        }
    }
}

