/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.raytrace;

import matteroverdrive.raytrace.Cuboid;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="matteroverdrive")
public class DistanceRayTraceResult
extends RayTraceResult
implements Comparable<DistanceRayTraceResult> {
    public double dist;

    public DistanceRayTraceResult(Vec3d hitVecIn, BlockPos blockPosIn, EnumFacing sideHitIn, Cuboid box, double dist) {
        super(hitVecIn, sideHitIn, blockPosIn);
        this.hitInfo = box;
        this.dist = dist;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    @SideOnly(value=Side.CLIENT)
    public static void onBlockHighlight(DrawBlockHighlightEvent event) {
        BlockPos pos = event.getTarget().func_178782_a();
        RayTraceResult hit = event.getTarget();
        if (hit.field_72313_a == RayTraceResult.Type.BLOCK && hit instanceof DistanceRayTraceResult) {
            event.setCanceled(true);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179132_a((boolean)false);
            EntityPlayer player = event.getPlayer();
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
            RenderGlobal.func_189697_a((AxisAlignedBB)((Cuboid)((DistanceRayTraceResult)event.getTarget()).hitInfo).aabb().func_72317_d(-x, -y, -z).func_186670_a(pos).func_186662_g(0.002), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
    }

    @Override
    public int compareTo(DistanceRayTraceResult o) {
        return Double.compare(this.dist, o.dist);
    }
}

