/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.network.packet.client.starmap.PacketUpdateGalaxy;
import matteroverdrive.network.packet.client.starmap.PacketUpdatePlanet;
import matteroverdrive.starmap.GalaxyCommon;
import matteroverdrive.starmap.GalaxyGenerator;
import matteroverdrive.starmap.data.Galaxy;
import matteroverdrive.starmap.data.Planet;
import matteroverdrive.starmap.data.Quadrant;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GalaxyServer
extends GalaxyCommon
implements IConfigSubscriber {
    public static final int GALAXY_VERSION = 1;
    private static GalaxyServer instance;
    private final GalaxyGenerator galaxyGenerator = new GalaxyGenerator();

    public static GalaxyServer getInstance() {
        if (instance == null) {
            instance = new GalaxyServer();
        }
        return instance;
    }

    public void createGalaxy(File file, World world) {
        this.theGalaxy = this.galaxyGenerator.generateGalaxy("Galaxy", world.field_73011_w.getDimension(), world.func_72912_H().func_76063_b(), world);
        this.saveGalaxy(file);
    }

    public boolean saveGalaxy(File file) {
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.theGalaxy.writeToNBT(tagCompound);
            CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            return true;
        }
        catch (IOException e) {
            MOLog.error("Galaxy could not be saved", e, new Object[0]);
            return false;
        }
    }

    public boolean loadGalaxy(File file, World world) {
        if (file.exists() && file.isFile()) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
                inputStream.close();
                Galaxy theGalaxy = new Galaxy(world);
                theGalaxy.readFromNBT(tagCompound, this.galaxyGenerator);
                if (theGalaxy.getVersion() < 1) {
                    MOLog.info("Galaxy Version is too old. Galaxy Needs regeneration", new Object[0]);
                    this.galaxyGenerator.regenerateQuadrants(theGalaxy);
                    theGalaxy.setVersion(1);
                    theGalaxy.markDirty();
                }
                this.setTheGalaxy(theGalaxy);
                return true;
            }
            catch (IOException e) {
                MOLog.error("Could not load galaxy from file", e, new Object[0]);
                return false;
            }
        }
        MOLog.info("Galaxy File could not be found at: '%s'", file);
        return false;
    }

    private Planet claimPlanet(EntityPlayer player) {
        UUID playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
        int quadrantID = this.random.nextInt(this.theGalaxy.getQuadrants().size());
        for (Quadrant quadrant : this.theGalaxy.getQuadrants()) {
            if (quadrant.getId() != quadrantID) continue;
            for (Star star : quadrant.getStars()) {
                Planet planet2;
                if (star.getPlanets().size() <= 0) continue;
                boolean isClaimed = false;
                for (Planet planet2 : star.getPlanets()) {
                    if (!planet2.hasOwner() || planet2.getOwnerUUID().equals(playerUUID)) continue;
                    isClaimed = true;
                    break;
                }
                if (isClaimed) continue;
                int planetID = this.random.nextInt(star.getPlanets().size());
                planet2 = (Planet)star.getPlanets().toArray()[planetID];
                this.buildHomeworld(planet2, player);
                return planet2;
            }
        }
        return null;
    }

    private void buildHomeworld(Planet planet, EntityPlayer player) {
        planet.setOwner(player);
        planet.setHomeworld(true);
        planet.func_70296_d();
    }

    private boolean tryAndClaimPlanet(EntityPlayer player) {
        UUID playerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
        if (!this.homePlanets.containsKey(playerUUID)) {
            Planet claimedPlanet = this.claimPlanet(player);
            if (claimedPlanet != null) {
                this.homePlanets.put(playerUUID, claimedPlanet);
                return true;
            }
            MOLog.warn("%s could not claim planet.", player.func_145748_c_().func_150254_d());
        }
        return false;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            if (this.theGalaxy != null) {
                MatterOverdrive.NETWORK.sendTo(new PacketUpdateGalaxy(this.theGalaxy), (EntityPlayerMP)event.player);
                if (this.tryAndClaimPlanet(event.player)) {
                    Planet planet = this.getHomeworld(event.player);
                    MatterOverdrive.NETWORK.sendToDimention((IMessage)new PacketUpdatePlanet(planet), event.player.field_70170_p);
                }
            } else {
                MOLog.warn("Galaxy is missing.", new Object[0]);
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load load) {
        if (!load.getWorld().field_72995_K && load.getWorld().field_73011_w.getDimension() == 0) {
            this.world = load.getWorld();
            File galaxyFile = this.getGalaxyFile(load.getWorld());
            long start = System.nanoTime();
            if (!this.loadGalaxy(galaxyFile, load.getWorld())) {
                this.createGalaxy(galaxyFile, load.getWorld());
                MOLog.info("Galaxy Generated and saved to '%1$s'. Took %2$s milliseconds", galaxyFile.getPath(), (System.nanoTime() - start) / 1000000L);
            } else {
                MOLog.info("Galaxy Loaded from '%1$s'. Took %2$s milliseconds", galaxyFile.getPath(), (System.nanoTime() - start) / 1000000L);
            }
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save save) {
        if (save.getWorld() == null || this.theGalaxy == null) {
            return;
        }
        if (!save.getWorld().field_72995_K && save.getWorld().field_73011_w.getDimension() == 0 && this.theGalaxy.isDirty()) {
            long start = System.nanoTime();
            File galaxyFile = this.getGalaxyFile(save.getWorld());
            if (this.saveGalaxy(galaxyFile)) {
                this.theGalaxy.onSave(galaxyFile, save.getWorld());
                MOLog.info("Galaxy saved to '%s'. Took %s milliseconds", galaxyFile.getPath(), (System.nanoTime() - start) / 1000000L);
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload unload) {
        if (unload.getWorld() == null || this.theGalaxy == null) {
            return;
        }
        if (unload.getWorld().field_72995_K && unload.getWorld().field_73011_w.getDimension() == 0) {
            this.world = null;
            this.theGalaxy = null;
            this.homePlanets.clear();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world == null || this.theGalaxy == null) {
            return;
        }
        if (!event.world.field_72995_K && event.world.field_73011_w.getDimension() == 0) {
            this.theGalaxy.update(event.world);
        }
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        Galaxy.GALAXY_BUILD_TIME_MULTIPLY = config.config.getFloat("galaxy build time multiply", "starmap", 1.0f, 0.0f, 10.0f, "The multiplier for the building and ship building times");
        Galaxy.GALAXY_TRAVEL_TIME_MULTIPLY = config.config.getFloat("galaxy travel time multiply", "starmap", 1.0f, 0.0f, 10.0f, "The multiplier for the ship travel times");
    }

    private File getGalaxyFile(World world) {
        File worldDirectory = world.func_72860_G().func_75765_b();
        return new File(worldDirectory.getPath() + "/galaxy.dat");
    }

    public GalaxyGenerator getGalaxyGenerator() {
        return this.galaxyGenerator;
    }
}

