/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.weapon.IWeaponColor;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.inventory.ModuleSlot;
import matteroverdrive.data.inventory.TeleportFlashDriveSlot;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.entity.monster.EntityRougeAndroidMob;
import matteroverdrive.items.TransportFlashDrive;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.configs.ConfigPropertyInteger;
import matteroverdrive.machines.configs.ConfigPropertyString;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.util.WeaponHelper;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityAndroidSpawner
extends MOTileEntityMachine {
    public static final int FLASH_DRIVE_COUNT = 6;
    private final Set<EntityRougeAndroidMob> spawnedAndroids = new HashSet<EntityRougeAndroidMob>();
    public int FLASH_DRIVE_SLOT_START;
    public int COLOR_MODULE_SLOT;

    public TileEntityAndroidSpawner() {
        super(0);
        this.playerSlotsMain = true;
        this.playerSlotsHotbar = true;
    }

    @Override
    protected void RegisterSlots(Inventory inventory) {
        this.COLOR_MODULE_SLOT = inventory.AddSlot(new ModuleSlot(true, 1, null));
        TeleportFlashDriveSlot slot = new TeleportFlashDriveSlot(false);
        slot.setKeepOnDismante(true);
        this.FLASH_DRIVE_SLOT_START = inventory.AddSlot(slot);
        for (int i = 0; i < 5; ++i) {
            slot = new TeleportFlashDriveSlot(false);
            slot.setKeepOnDismante(true);
            inventory.AddSlot(slot);
        }
        super.RegisterSlots(inventory);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.isActive() && (this.getSpawnDelay() == 0 || this.field_145850_b.func_82737_E() % (long)this.getSpawnDelay() == 0L)) {
            for (int i = this.spawnedAndroids.size(); i < this.getMaxSpawnCount(); ++i) {
                EntityRougeAndroidMob entity = random.nextInt(10) < 3 ? new EntityMeleeRougeAndroidMob(this.field_145850_b) : new EntityRangedRogueAndroidMob(this.field_145850_b);
                double spawnRange = this.getSpawnRange();
                double x = (double)this.func_174877_v().func_177958_n() + MathHelper.func_151237_a((double)this.field_145850_b.field_73012_v.nextGaussian(), (double)0.0, (double)1.0) * spawnRange;
                double y = this.func_174877_v().func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3) - 1;
                double z = (double)this.func_174877_v().func_177952_p() + MathHelper.func_151237_a((double)this.field_145850_b.field_73012_v.nextGaussian(), (double)0.0, (double)1.0) * spawnRange;
                int topY = this.field_145850_b.func_175645_m(new BlockPos(x, y, z)).func_177956_o();
                topY = Math.min(topY, this.func_174877_v().func_177956_o() + 3);
                entity.func_70012_b(x, topY, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (!entity.getCanSpawnHere(true, true, true)) continue;
                entity.func_180482_a(this.field_145850_b.func_175649_E(this.func_174877_v()), null);
                entity.setSpawnerPosition(this.func_174877_v());
                entity.func_110163_bv();
                this.addSpawnedAndroid(entity);
                this.field_145850_b.func_175669_a(2004, this.func_174877_v(), 0);
                ScorePlayerTeam team = this.getTeam();
                if (team != null) {
                    entity.setTeam(team);
                    if (this.inventory.func_70301_a(this.COLOR_MODULE_SLOT) != null && this.inventory.func_70301_a(this.COLOR_MODULE_SLOT).func_77973_b() instanceof IWeaponColor) {
                        entity.setVisorColor(((IWeaponColor)this.inventory.func_70301_a(this.COLOR_MODULE_SLOT).func_77973_b()).getColor(this.inventory.func_70301_a(this.COLOR_MODULE_SLOT), null));
                        if (entity.func_184586_b(EnumHand.MAIN_HAND) != null) {
                            WeaponHelper.setModuleAtSlot(1, entity.func_184586_b(EnumHand.MAIN_HAND), this.inventory.func_70301_a(this.COLOR_MODULE_SLOT));
                        }
                    }
                }
                this.spawnEntity(entity);
                entity.func_70656_aK();
                this.forceSync();
            }
        }
    }

    public ScorePlayerTeam getTeam() {
        String teamName = this.getTeamName();
        if (teamName != null && !teamName.isEmpty()) {
            return this.field_145850_b.func_96441_U().func_96508_e(teamName);
        }
        return null;
    }

    public boolean isTeamValid() {
        String teamName = this.getTeamName();
        if (teamName != null && !teamName.isEmpty()) {
            return this.field_145850_b.func_96441_U().func_96508_e(teamName) != null;
        }
        return true;
    }

    public void assignPath(EntityRougeAndroidMob androidMob) {
        ArrayList<Vec3d> paths = new ArrayList<Vec3d>();
        for (int i = this.FLASH_DRIVE_SLOT_START; i < 6; ++i) {
            BlockPos position;
            ItemStack flashDrive = this.inventory.getSlot(i).getItem();
            if (flashDrive == null || !(flashDrive.func_77973_b() instanceof TransportFlashDrive) || (position = ((TransportFlashDrive)flashDrive.func_77973_b()).getTarget(flashDrive)) == null) continue;
            paths.add(new Vec3d((Vec3i)position));
        }
        if (paths.size() <= 0) {
            androidMob.setPath(new Vec3d[]{new Vec3d((Vec3i)this.func_174877_v())}, this.getSpawnRange());
        } else {
            androidMob.setPath(paths.toArray(new Vec3d[paths.size()]), this.getSpawnRange());
        }
    }

    public int getMaxSpawnCount() {
        return this.configs.getInteger("max_spawn_amount", 6);
    }

    public int getSpawnRange() {
        return this.configs.getInteger("spawn_range", 4);
    }

    public String getTeamName() {
        return this.configs.getString("team", null);
    }

    public int getSpawnDelay() {
        return this.configs.getInteger("spawn_delay", 300);
    }

    public int getSpawnedCount() {
        return this.spawnedAndroids.size();
    }

    @Override
    protected void registerComponents() {
        super.registerComponents();
        this.configs.addProperty(new ConfigPropertyInteger("max_spawn_amount", "gui.config.spawn_amount", 0, 32, 6));
        this.configs.addProperty(new ConfigPropertyInteger("spawn_range", "gui.config.spawn_range", 0, 32, 4));
        this.configs.addProperty(new ConfigPropertyInteger("spawn_delay", "gui.config.spawn_delay", 0, 100000, 300));
        this.configs.addProperty(new ConfigPropertyString("team", "gui.config.team", ""));
    }

    public EntityRougeAndroidMob spawnEntity(EntityRougeAndroidMob entity) {
        this.field_145850_b.func_72838_d((Entity)entity);
        return entity;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        super.readCustomNBT(nbt, categories);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        super.writeCustomNBT(nbt, categories, toDisk);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return this.getRedstoneActive() && this.isTeamValid() && this.spawnedAndroids.size() <= this.getMaxSpawnCount();
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    protected void onAwake(Side side) {
        if (side == Side.SERVER) {
            for (Entity entity : this.field_145850_b.field_72996_f) {
                if (!(entity instanceof EntityRougeAndroidMob) || !((EntityRougeAndroidMob)entity).wasSpawnedFrom(this)) continue;
                this.addSpawnedAndroid((EntityRougeAndroidMob)entity);
                this.assignPath((EntityRougeAndroidMob)entity);
            }
        }
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public void removeAllAndroids() {
        for (EntityRougeAndroidMob androidMob : this.spawnedAndroids) {
            androidMob.field_70128_L = true;
        }
        this.spawnedAndroids.clear();
    }

    public void addSpawnedAndroid(EntityRougeAndroidMob androidMob) {
        if (!this.spawnedAndroids.contains(androidMob)) {
            this.spawnedAndroids.add(androidMob);
            this.assignPath(androidMob);
        }
    }

    public void removeAndroid(EntityRougeAndroidMob androidMob) {
        if (this.spawnedAndroids.remove(androidMob)) {
            // empty if block
        }
    }
}

