/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.tile.MOTileEntityMachineEnergy;
import matteroverdrive.util.MOEnergyHelper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEntityMachineSolarPanel
extends MOTileEntityMachineEnergy {
    public static final int CHARGE_AMOUNT = 8;
    public static final int ENERGY_STORAGE = 64000;
    public static final int MAX_ENERGY_EXTRACT = 512;
    private byte chargeAmount;

    public TileEntityMachineSolarPanel() {
        super(2);
        this.energyStorage.setCapacity(64000);
        this.energyStorage.setMaxExtract(512);
        this.energyStorage.setMaxReceive(0);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.manageExtract();
            this.manageChagrgeAmount();
        }
        super.func_73660_a();
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    @Override
    protected void manageCharging() {
        if (!this.field_145850_b.field_72995_K && this.isActive() && this.energyStorage.getEnergyStored() < this.getEnergyStorage().getMaxEnergyStored()) {
            int energy = this.energyStorage.getEnergyStored();
            if ((energy = MathHelper.func_76125_a((int)(energy + this.getChargeAmount()), (int)0, (int)this.energyStorage.getMaxEnergyStored())) != this.energyStorage.getEnergyStored()) {
                this.UpdateClientPower();
            }
            this.getEnergyStorage().setEnergy(energy);
        }
    }

    @Override
    public boolean getServerActive() {
        if (this.field_145850_b.field_73011_w.func_191066_m()) {
            boolean i1 = this.field_145850_b.func_175678_i(this.func_174877_v().func_177984_a());
            float time = this.getTime();
            if (i1 && (double)time > 0.5) {
                return true;
            }
        }
        return false;
    }

    public void manageExtract() {
        int energy = this.energyStorage.getEnergyStored();
        if (energy > 0) {
            for (int i = 0; i < 6; ++i) {
                int energyToTransfer = Math.min(energy, 512);
                if (energyToTransfer <= 0) continue;
                energy -= MOEnergyHelper.insertEnergyIntoAdjacentEnergyReceiver(this, EnumFacing.field_82609_l[i], energyToTransfer, false);
            }
            this.getEnergyStorage().setEnergy(energy);
        }
    }

    public void manageChagrgeAmount() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.field_73011_w.func_191066_m()) {
                float f = 0.0f;
                int i1 = this.field_145850_b.func_175642_b(EnumSkyBlock.SKY, this.func_174877_v().func_177984_a()) - this.field_145850_b.func_175657_ab();
                if (i1 >= 15) {
                    f = this.getTime();
                }
                this.chargeAmount = (byte)Math.round(8.0f * f);
            } else {
                this.chargeAmount = 0;
            }
        }
    }

    public float getTime() {
        float f = this.field_145850_b.func_72929_e(1.0f);
        f = f < (float)Math.PI ? (f += (0.0f - f) * 0.2f) : (f += ((float)Math.PI * 2 - f) * 0.2f);
        return (float)Math.cos(f);
    }

    public byte getChargeAmount() {
        return this.chargeAmount;
    }

    public void setChargeAmount(byte chargeAmount) {
        this.chargeAmount = chargeAmount;
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return type == UpgradeTypes.PowerStorage;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        return super.getCapability(capability, facing);
    }
}

