/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.tile;

import java.util.EnumSet;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.machines.IUpgradeHandler;
import matteroverdrive.blocks.BlockSpacetimeAccelerator;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.render.RenderParticlesHandler;
import matteroverdrive.fx.ShockwaveParticle;
import matteroverdrive.machines.UpgradeHandlerGeneric;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.MOTileEntityMachineMatter;
import matteroverdrive.util.TimeTracker;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineSpacetimeAccelerator
extends MOTileEntityMachineMatter {
    private static final IUpgradeHandler upgradeHandler = new UpgradeHandlerGeneric(0.05, Double.MAX_VALUE).addUpgradeMinimum(UpgradeTypes.Speed, 0.2).addUpgradeMaximum(UpgradeTypes.Range, 6.0);
    private static EnumSet<UpgradeTypes> upgradeTypes = EnumSet.of(UpgradeTypes.PowerStorage, new UpgradeTypes[]{UpgradeTypes.PowerUsage, UpgradeTypes.Range, UpgradeTypes.MatterStorage, UpgradeTypes.MatterTransfer, UpgradeTypes.Speed, UpgradeTypes.MatterUsage});
    private TimeTracker timeTracker = new TimeTracker();
    private double matterUseCache;

    public TileEntityMachineSpacetimeAccelerator() {
        super(4);
        this.matterStorage.setCapacity(1024);
        this.matterStorage.setMaxReceive(16);
        this.matterStorage.setMaxExtract(0);
        this.energyStorage.setCapacity(512000);
        this.energyStorage.setMaxExtract(0);
        this.energyStorage.setMaxReceive(512);
        this.playerSlotsHotbar = true;
        this.playerSlotsMain = true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.isActive()) {
            if (!this.field_145850_b.field_72995_K) {
                this.energyStorage.modifyEnergyStored(-this.getEnergyUsage());
                this.UpdateClientPower();
                if (this.timeTracker.hasDelayPassed(this.field_145850_b, this.getSpeed())) {
                    this.manageAccelerations();
                }
            } else if (this.timeTracker.hasDelayPassed(this.field_145850_b, Math.max(this.getSpeed(), 20))) {
                boolean showWaveParticle = true;
                if (this.func_145838_q() instanceof BlockSpacetimeAccelerator) {
                    showWaveParticle = ((BlockSpacetimeAccelerator)this.func_145838_q()).showWave;
                }
                if (showWaveParticle) {
                    this.spawnShockwave();
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnShockwave() {
        float range = this.getRadius();
        ShockwaveParticle particle = new ShockwaveParticle(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.2, (double)this.field_174879_c.func_177952_p() + 0.5, range);
        particle.setColorRGBA(new Color(51, 78, 120));
        ClientProxy.renderHandler.getRenderParticlesHandler().addEffect(particle, RenderParticlesHandler.Blending.Additive2Sided);
    }

    public void manageAccelerations() {
        int radius = this.getRadius();
        this.matterUseCache += this.getMatterUsage();
        if (this.matterUseCache > 1.0) {
            this.matterStorage.modifyMatterStored(-((int)this.matterUseCache));
            this.matterUseCache -= (double)((int)this.matterUseCache);
        }
        for (int x = -radius; x < radius; ++x) {
            for (int z = -radius; z < radius; ++z) {
                BlockPos pos = this.func_174877_v().func_177982_a(x, 0, z);
                IBlockState blockState = this.field_145850_b.func_180495_p(pos);
                blockState.func_177230_c().func_180645_a(this.field_145850_b, pos, blockState, random);
                TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
                if (tileEntity == null || !(tileEntity instanceof ITickable) || tileEntity instanceof TileEntityMachineSpacetimeAccelerator) continue;
                ((ITickable)tileEntity).func_73660_a();
            }
        }
    }

    public int getEnergyUsage() {
        return (int)(64.0 * this.getUpgradeMultiply(UpgradeTypes.PowerUsage));
    }

    public double getMatterUsage() {
        return 0.2 * this.getUpgradeMultiply(UpgradeTypes.MatterUsage);
    }

    public int getSpeed() {
        return (int)(40.0 * this.getUpgradeMultiply(UpgradeTypes.Speed));
    }

    public int getRadius() {
        return (int)(2.0 * this.getUpgradeMultiply(UpgradeTypes.Range));
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }

    @Override
    public boolean hasSound() {
        return false;
    }

    @Override
    public boolean getServerActive() {
        return this.getRedstoneActive() && (double)this.matterStorage.getMatterStored() >= Math.max(1.0, this.getMatterUsage()) && this.energyStorage.getEnergyStored() >= this.getEnergyUsage();
    }

    @Override
    public float soundVolume() {
        return 0.0f;
    }

    @Override
    protected void onMachineEvent(MachineEvent event) {
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return upgradeTypes.contains((Object)type);
    }

    @Override
    public IUpgradeHandler getUpgradeHandler() {
        return upgradeHandler;
    }
}

