/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.WeightedRandomItemStack;
import matteroverdrive.entity.android_player.AndroidAttributes;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.text.TextFormatting;

public class AndroidPartsFactory {
    private static final Random random = new Random();
    private final List<WeightedRandomItemStack> parts = new ArrayList<WeightedRandomItemStack>();

    public void initParts() {
        this.parts.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.androidParts, 1, 0), 100));
        this.parts.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.androidParts, 1, 1), 100));
        this.parts.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.androidParts, 1, 2), 100));
        this.parts.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.androidParts, 1, 3), 100));
        this.parts.add(new WeightedRandomItemStack(new ItemStack((Item)MatterOverdrive.ITEMS.tritaniumSpine), 20));
    }

    public ItemStack generateRandomDecoratedPart(AndroidPartFactoryContext context) {
        WeightedRandomItemStack randomPart = (WeightedRandomItemStack)WeightedRandom.func_76271_a((Random)random, this.parts);
        ItemStack stack = randomPart.getStack();
        this.addLegendaryAttributesToPart(stack, context);
        return stack;
    }

    public void addLegendaryAttributesToPart(ItemStack part, AndroidPartFactoryContext context) {
        if (context.legendary) {
            int batteryUse;
            int glitchLevel;
            int speedLevel;
            int knockbackLevel;
            int attackPowerLevel;
            int healthLevel = random.nextInt(context.level + 10);
            if (healthLevel > 0) {
                this.addAttributeToPart(part, new AttributeModifier(SharedMonsterAttributes.field_111267_a.func_111108_a(), (double)healthLevel, 0));
            }
            if ((attackPowerLevel = random.nextInt(context.level + 1)) > 0) {
                this.addAttributeToPart(part, new AttributeModifier(SharedMonsterAttributes.field_111264_e.func_111108_a(), (double)attackPowerLevel, 0));
            }
            if ((knockbackLevel = random.nextInt(context.level + 1)) > 0) {
                this.addAttributeToPart(part, new AttributeModifier(SharedMonsterAttributes.field_111266_c.func_111108_a(), (double)knockbackLevel * 0.1, 0));
            }
            if ((speedLevel = random.nextInt(context.level + 1)) > 0) {
                this.addAttributeToPart(part, new AttributeModifier(SharedMonsterAttributes.field_111263_d.func_111108_a(), (double)speedLevel * 0.1, 1));
            }
            if ((glitchLevel = random.nextInt(context.level + 1)) > 0) {
                this.addAttributeToPart(part, new AttributeModifier(AndroidAttributes.attributeGlitchTime.func_111108_a(), (double)(-glitchLevel) * 0.2, 1));
            }
            if ((batteryUse = random.nextInt(context.level + 1)) > 0) {
                this.addAttributeToPart(part, new AttributeModifier(AndroidAttributes.attributeBatteryUse.func_111108_a(), (double)(-batteryUse) * 0.03, 1));
            }
            part.func_151001_c("\u272a " + TextFormatting.GOLD + MOStringHelper.translateToLocal("rarity.legendary", new Object[0]) + " " + part.func_82833_r());
        }
    }

    public ItemStack addAttributeToPart(ItemStack part, AttributeModifier attribute) {
        if (part.func_77978_p() == null) {
            part.func_77982_d(new NBTTagCompound());
        }
        NBTTagList attributeList = part.func_77978_p().func_150295_c("CustomAttributes", 10);
        NBTTagCompound attributeTag = new NBTTagCompound();
        attributeTag.func_74778_a("Name", attribute.func_111166_b());
        attributeTag.func_74780_a("Amount", attribute.func_111164_d());
        attributeTag.func_74778_a("UUID", attribute.func_111167_a().toString());
        attributeTag.func_74774_a("Operation", (byte)attribute.func_111169_c());
        attributeList.func_74742_a((NBTBase)attributeTag);
        part.func_77983_a("CustomAttributes", (NBTBase)attributeList);
        return part;
    }

    public static class AndroidPartFactoryContext {
        public final int level;
        public Entity entity;
        public boolean legendary;

        public AndroidPartFactoryContext(int level) {
            this.level = level;
        }

        public AndroidPartFactoryContext(int level, Entity entity) {
            this(level);
            this.entity = entity;
        }

        public AndroidPartFactoryContext(int level, Entity entity, boolean legendary) {
            this(level, entity);
            this.legendary = legendary;
        }
    }
}

