/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import matteroverdrive.util.MOStringHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class MOEnergyHelper {
    public static String ENERGY_UNIT = "FE";

    public static String formatEnergy(long energy, long capacity) {
        return MOStringHelper.formatNumber(energy) + " / " + MOStringHelper.formatNumber(capacity) + ENERGY_UNIT;
    }

    public static String formatEnergy(long energy) {
        return MOEnergyHelper.formatEnergy("Charge: ", energy);
    }

    public static String formatEnergy(String prefix, long energy) {
        return (prefix != null ? prefix : "") + MOStringHelper.formatNumber(energy) + ENERGY_UNIT;
    }

    public static boolean extractExactAmount(IEnergyStorage provider, int amount, boolean simulate) {
        int hasEnergy = provider.getEnergyStored();
        if (hasEnergy >= amount) {
            while (amount > 0) {
                if (provider.extractEnergy(amount, true) >= 0) {
                    amount -= provider.extractEnergy(amount, simulate);
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    public static ItemStack setDefaultEnergyTag(ItemStack itemStack, int energy) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74768_a("Energy", energy);
        return itemStack;
    }

    public static int extractEnergyFromContainer(ItemStack itemStack, int amount, boolean simulate) {
        return MOEnergyHelper.isEnergyContainerItem(itemStack) ? ((IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(amount, simulate) : 0;
    }

    public static int insertEnergyIntoContainer(ItemStack itemStack, int amount, boolean simulate) {
        return MOEnergyHelper.isEnergyContainerItem(itemStack) ? ((IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null)).receiveEnergy(amount, simulate) : 0;
    }

    public static boolean isEnergyContainerItem(ItemStack itemStack) {
        return !itemStack.func_190926_b() && itemStack.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    public static int insertEnergyIntoAdjacentEnergyReceiver(TileEntity tileEntity, EnumFacing side, int amount, boolean simulate) {
        TileEntity tile2 = tileEntity.func_145831_w().func_175625_s(tileEntity.func_174877_v().func_177972_a(side));
        if (tile2 == null) {
            return 0;
        }
        return tile2.hasCapability(CapabilityEnergy.ENERGY, side.func_176734_d()) ? ((IEnergyStorage)tile2.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d())).receiveEnergy(amount, simulate) : 0;
    }
}

