/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;

public class MachineHelper {
    public static boolean canOpenMachine(World world, BlockPos pos, EntityPlayer player, boolean hasGui, String errorMessage) {
        TileEntity tileEntity;
        if (world.field_72995_K) {
            return true;
        }
        if (hasGui && (tileEntity = world.func_175625_s(pos)) instanceof MOTileEntityMachine) {
            if (((MOTileEntityMachine)tileEntity).func_70300_a(player)) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MatterOverdrive.INSTANCE, (int)-1, (World)world, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
                return true;
            }
            TextComponentString message = new TextComponentString(TextFormatting.GOLD + "[Matter Overdrive] " + TextFormatting.RED + MOStringHelper.translateToLocal(errorMessage, new Object[0]).replace("$0", ((MOTileEntityMachine)tileEntity).func_145748_c_().toString()));
            message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            player.func_145747_a((ITextComponent)message);
        }
        return false;
    }

    public static boolean canRemoveMachine(World world, EntityPlayer player, BlockPos pos, boolean willHarvest) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof MOTileEntityMachine && !player.field_71075_bZ.field_75098_d && ((MOTileEntityMachine)tileEntity).hasOwner() && !((MOTileEntityMachine)tileEntity).getOwner().equals(player.func_146103_bH().getId())) {
            TextComponentString message = new TextComponentString(TextFormatting.GOLD + "[Matter Overdrive] " + TextFormatting.RED + MOStringHelper.translateToLocal("alert.no_rights.break", new Object[0]).replace("$0", ((MOTileEntityMachine)tileEntity).func_145748_c_().toString()));
            message.func_150255_a(new Style().func_150238_a(TextFormatting.RED));
            player.func_145747_a((ITextComponent)message);
            return false;
        }
        return true;
    }
}

