/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import matteroverdrive.api.matter.IMatterDatabase;
import matteroverdrive.api.matter.IMatterPatternStorage;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class MatterDatabaseHelper {
    public static final int MAX_ITEM_PROGRESS = 100;
    public static final String PROGRESS_TAG_NAME = "scan_progress";
    public static final String ITEMS_TAG_NAME = "items";
    public static final String CAPACITY_TAG_NAME = "Capacity";

    public static void initTagCompound(ItemStack scanner) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        scanner.func_77982_d(tagCompound);
        MatterDatabaseHelper.initItemListTagCompound(scanner);
    }

    public static void initItemListTagCompound(ItemStack scanner) {
        NBTTagList items = new NBTTagList();
        scanner.func_77983_a(ITEMS_TAG_NAME, (NBTBase)items);
    }

    public static int getPatternCapacity(ItemStack storage) {
        if (storage.func_77978_p() != null) {
            return storage.func_77978_p().func_74765_d(CAPACITY_TAG_NAME);
        }
        return 0;
    }

    public static boolean hasFreeSpace(ItemStack storage) {
        if (storage != null && MatterHelper.isMatterPatternStorage(storage)) {
            IMatterPatternStorage patternStorage = (IMatterPatternStorage)storage.func_77973_b();
            for (int i = 0; i < patternStorage.getCapacity(storage); ++i) {
                ItemPattern itemPattern = patternStorage.getPatternAt(storage, i);
                if (itemPattern != null) continue;
                return true;
            }
        }
        return false;
    }

    public static ItemStack getFirstFreePatternStorage(IMatterDatabase database) {
        ItemStack[] patternStorages;
        for (ItemStack patternStorage : patternStorages = database.getPatternStorageList()) {
            if (patternStorage == null || !MatterDatabaseHelper.hasFreeSpace(patternStorage)) continue;
            return patternStorage;
        }
        return null;
    }

    public static void addProgressToPatternStorage(ItemStack patternStorage, ItemStack item, int progress, boolean existingOnly) {
        if (!patternStorage.func_77942_o()) {
            MatterDatabaseHelper.initItemListTagCompound(patternStorage);
        }
        NBTTagList patternsTagList = patternStorage.func_77978_p().func_150295_c(ITEMS_TAG_NAME, 10);
        for (int i = 0; i < patternsTagList.func_74745_c(); ++i) {
            ItemPattern pattern = new ItemPattern(patternsTagList.func_150305_b(i));
            if (!MatterDatabaseHelper.areEqual(pattern.toItemStack(false), item)) continue;
            byte oldProgress = patternsTagList.func_150305_b(i).func_74771_c(PROGRESS_TAG_NAME);
            patternsTagList.func_150305_b(i).func_74774_a(PROGRESS_TAG_NAME, (byte)MathHelper.func_76125_a((int)(oldProgress + progress), (int)0, (int)100));
            return;
        }
        if (!existingOnly) {
            ItemPattern pattern = new ItemPattern(item, progress);
            NBTTagCompound patternTag = new NBTTagCompound();
            pattern.writeToNBT(patternTag);
            patternsTagList.func_74742_a((NBTBase)patternTag);
        }
    }

    public static int getItemStackProgress(ItemStack storage, ItemStack item) {
        ItemPattern itemPattern = MatterDatabaseHelper.getPatternFromStorage(storage, item);
        if (itemPattern != null) {
            return itemPattern.getProgress();
        }
        return -1;
    }

    public static ItemPattern getPatternFromStorage(ItemStack patternStorage, ItemStack item) {
        IMatterPatternStorage storage = (IMatterPatternStorage)patternStorage.func_77973_b();
        for (int i = 0; i < storage.getCapacity(patternStorage); ++i) {
            ItemPattern pattern = storage.getPatternAt(patternStorage, i);
            if (pattern == null || !pattern.equals(item)) continue;
            return pattern;
        }
        return null;
    }

    public static boolean areEqual(ItemStack one, ItemStack two) {
        if (one != null && two != null && one.func_77973_b() == two.func_77973_b()) {
            if (one.func_77981_g() && two.func_77981_g()) {
                if (one.func_77952_i() == two.func_77952_i()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public static boolean areEqual(NBTTagCompound one, NBTTagCompound two) {
        if (one == null || two == null) {
            return false;
        }
        return MatterDatabaseHelper.areEqual(new ItemStack(one), new ItemStack(two));
    }

    public static ItemStack GetItemStackFromWorld(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Item item = Item.func_150898_a((Block)blockState.func_177230_c());
        if (item != null) {
            return new ItemStack(item, 1, blockState.func_177230_c().func_176201_c(blockState));
        }
        return ItemStack.field_190927_a;
    }

    public static TextFormatting getPatternInfoColor(int progress) {
        TextFormatting color = progress > 0 && progress <= 20 ? TextFormatting.RED : (progress > 20 && progress <= 40 ? TextFormatting.GOLD : (progress > 40 && progress <= 60 ? TextFormatting.YELLOW : (progress > 40 && progress <= 80 ? TextFormatting.AQUA : (progress > 80 && progress <= 100 ? TextFormatting.GREEN : TextFormatting.GREEN))));
        return color;
    }
}

