/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world.buildings;

import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.blocks.BlockTritaniumCrate;
import matteroverdrive.blocks.BlockWeaponStation;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.tile.TileEntityHoloSign;
import matteroverdrive.tile.TileEntityWeaponStation;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.WeaponFactory;
import matteroverdrive.world.MOImageGen;
import matteroverdrive.world.buildings.MOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class MOWorldGenCrashedSpaceShip
extends MOWorldGenBuilding {
    private static final int MIN_DISTANCE_APART = 256;
    private final String[] holoTexts = new String[]{"Critical\nError", "Contacting\nSection 9", "System\nFailure", "Emergency\nPower\nOffline", "System\nReboot\nFailure", "Help Me", "I Need\nWater"};

    public MOWorldGenCrashedSpaceShip(String name) {
        super(name, new ResourceLocation("matteroverdrive:textures/world/crashed_ship.png"), 11, 35);
        this.setyOffset(-1);
        this.addMapping(3721439, MatterOverdrive.BLOCKS.decorative_clean);
        this.addMapping(1604491, MatterOverdrive.BLOCKS.decorative_vent_bright);
        this.addMapping(65400, new Block[]{Blocks.field_150349_c});
        this.addMapping(14221056, MatterOverdrive.BLOCKS.holoSign);
        this.addMapping(11324160, MatterOverdrive.BLOCKS.holoSign);
        this.addMapping(3708639, MatterOverdrive.BLOCKS.decorative_tritanium_plate);
        this.addMapping(14670136, MatterOverdrive.BLOCKS.decorative_tritanium_plate_stripe);
        this.addMapping(6130091, MatterOverdrive.BLOCKS.decorative_holo_matrix);
        this.addMapping(7804029, MatterOverdrive.BLOCKS.weapon_station);
        this.addMapping(11553424, MatterOverdrive.BLOCKS.tritaniumCrate);
        this.addMapping(9756394, MatterOverdrive.BLOCKS.decorative_separator);
        this.addMapping(16751616, MatterOverdrive.BLOCKS.decorative_coils);
        this.addMapping(11315271, MatterOverdrive.BLOCKS.decorative_matter_tube);
        this.addMapping(801632, MatterOverdrive.BLOCKS.decorative_carbon_fiber_plate);
        this.addMapping(12963536, Blocks.field_150350_a);
    }

    @Override
    public void onBlockPlace(World world, IBlockState state, BlockPos pos, Random random, int color, MOImageGen.ImageGenWorker worker) {
        TileEntity tileEntity;
        if (state.func_177230_c() == MatterOverdrive.BLOCKS.holoSign) {
            if (this.colorsMatch(color, 14221056)) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)MOBlock.PROPERTY_DIRECTION, (Comparable)EnumFacing.EAST), 3);
            } else if (this.colorsMatch(color, 11324160)) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)MOBlock.PROPERTY_DIRECTION, (Comparable)EnumFacing.WEST), 3);
            }
            TileEntity tileEntity2 = world.func_175625_s(pos);
            if (tileEntity2 instanceof TileEntityHoloSign && random.nextInt(100) < 30) {
                ((TileEntityHoloSign)tileEntity2).setText(this.holoTexts[random.nextInt(this.holoTexts.length)]);
            }
        } else if (state.func_177230_c() instanceof BlockTritaniumCrate) {
            TileEntity tileEntity3 = world.func_175625_s(pos);
            if (tileEntity3 instanceof IInventory) {
                LootTableList.func_186375_a((ResourceLocation)new ResourceLocation("matteroverdrive", "crashed_ship"));
                QuestStack questStack = MatterOverdrive.QUEST_FACTORY.generateQuestStack(random, MatterOverdrive.QUESTS.getQuestByName("crash_landing"));
                questStack.getTagCompound().func_74772_a("pos", pos.func_177986_g());
                MOInventoryHelper.insertItemStackIntoInventory((IInventory)tileEntity3, questStack.getContract(), EnumFacing.DOWN);
            }
        } else if (state.func_177230_c() instanceof BlockWeaponStation && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityWeaponStation && random.nextInt(200) < 10) {
            ((TileEntityWeaponStation)tileEntity).func_70299_a(((TileEntityWeaponStation)tileEntity).INPUT_SLOT, MatterOverdrive.WEAPON_FACTORY.getRandomDecoratedEnergyWeapon(new WeaponFactory.WeaponGenerationContext(3, null, true)));
        }
    }

    @Override
    public MOWorldGenBuilding.WorldGenBuildingWorker getNewWorkerInstance() {
        return new MOWorldGenBuilding.WorldGenBuildingWorker();
    }

    protected void onGeneration(Random random, World world, BlockPos pos, MOWorldGenBuilding.WorldGenBuildingWorker worker) {
    }

    @Override
    public boolean shouldGenerate(Random random, World world, BlockPos pos) {
        return world.field_73011_w.getDimension() == 0 && this.isFarEnoughFromOthers(world, pos.func_177958_n(), pos.func_177952_p(), 256);
    }
}

