/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergySink;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.sytem.InfoTile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class SinkEnergy
implements IEnergySink {
    private final TileEntity parent;
    private final IEnergyStorage energy;
    private double perenergy;
    private double pastEnergy;
    private double tick;
    private long id;
    int hashCodeSource;
    List<Integer> energyTicks = new LinkedList<Integer>();
    private int hashCode;
    boolean hasHashCode = false;
    Map<EnumFacing, IEnergyTile> energyConductorMap = new HashMap<EnumFacing, IEnergyTile>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();

    public SinkEnergy(TileEntity tileentity, IEnergyStorage energy) {
        this.parent = tileentity;
        this.energy = energy;
    }

    public Map<EnumFacing, IEnergyTile> getConductors() {
        return this.energyConductorMap;
    }

    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing dir) {
        return true;
    }

    public double getDemandedEnergy() {
        return (double)this.energy.receiveEnergy(Integer.MAX_VALUE, true) / 4.0;
    }

    public int getSinkTier() {
        return 14;
    }

    public void receiveEnergy(double amount) {
        this.energy.receiveEnergy((int)amount * 4, false);
    }

    public List<Integer> getEnergyTickList() {
        return this.energyTicks;
    }

    public double getPerEnergy() {
        return this.perenergy;
    }

    public double getPastEnergy() {
        return this.pastEnergy;
    }

    public void setPastEnergy(double pastEnergy) {
        this.pastEnergy = pastEnergy;
    }

    public void addPerEnergy(double setEnergy) {
        this.perenergy += setEnergy;
    }

    public void addTick(double tick) {
        this.tick = tick;
    }

    public double getTick() {
        return this.tick;
    }

    public boolean isSink() {
        return true;
    }

    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = this.parent.hashCode();
            return this.hashCode;
        }
        return this.hashCode;
    }

    @NotNull
    public BlockPos getBlockPos() {
        return this.parent.func_174877_v();
    }

    public int getSourceTier() {
        return 14;
    }

    public long getIdNetwork() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public TileEntity getTileEntity() {
        return this.parent;
    }

    public void RemoveTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.parent.func_145831_w().field_72995_K) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    public Map<EnumFacing, IEnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    public void AddTile(IEnergyTile tile, EnumFacing facing1) {
        if (!this.parent.func_145831_w().field_72995_K) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add((InfoTile<IEnergyTile>)new InfoTile((Object)tile, facing1.func_176734_d()));
        }
    }
}

