/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.Config;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.NodeStats;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Energy;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.powerutils.BlockPowerConverter;
import com.powerutils.ContainerFEConverter;
import com.powerutils.GuiFEConverter;
import com.powerutils.PowerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileFEConverter
extends TileEntityInventory
implements IUpdatableTileEvent,
IEnergyStorage,
IUpgradableBlock {
    public final Energy energy;
    public final InvSlotUpgrade upgradeSlot;
    public final int defaultEnergyRFStorage;
    public final int defaultEnergyStorage;
    public double capacity;
    public double maxStorage2 = 400000.0;
    public double energy2 = 0.0;
    public boolean rf = true;
    public double differenceenergy = 0.0;
    public double perenergy = 0.0;
    public double differenceenergy1 = 0.0;
    public int tier = 5;
    public List<EntityPlayer> list = new ArrayList<EntityPlayer>();
    private long tick;

    public TileFEConverter() {
        this.energy = (Energy)this.addComponent((AbstractComponent)new Energy((TileEntityInventory)this, 40000.0, ModUtils.allFacings, ModUtils.allFacings, 5, 5, false));
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, 4);
        this.defaultEnergyStorage = 40000;
        this.defaultEnergyRFStorage = 400000;
        this.capacity = this.energy.capacity;
    }

    public IMultiTileBlock getTeBlock() {
        return BlockPowerConverter.power_utilities_fe;
    }

    public BlockTileEntity getBlock() {
        return PowerUtils.itemPowerConverter;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (this.hasComp(Energy.class)) {
            Energy energy = (Energy)this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"iu.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSourceTier()}));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"iu.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSinkTier()}));
            }
        }
    }

    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.energy2 = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.capacity = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.maxStorage2 = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.perenergy = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.rf = (Boolean)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.tier = (Integer)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.differenceenergy1 = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.differenceenergy = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.energy2);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.capacity);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.maxStorage2);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.perenergy);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.rf);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.tier);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.differenceenergy1);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.differenceenergy);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, @Nullable EnumFacing side) {
        return cap == CapabilityEnergy.ENERGY || super.hasCapability(cap, side);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> cap, @Nullable EnumFacing side) {
        return (T)(cap == CapabilityEnergy.ENERGY ? CapabilityEnergy.ENERGY.cast((Object)this) : super.getCapability(cap, side));
    }

    public void setOverclockRates() {
        int tier = this.upgradeSlot.getTier(5);
        this.energy.setSinkTier(tier);
        this.energy.setSourceTier(tier);
        this.energy.setCapacity(this.upgradeSlot.extraEnergyStorage + (double)this.defaultEnergyStorage);
        this.maxStorage2 = (double)this.defaultEnergyRFStorage + this.upgradeSlot.extraEnergyStorage * (double)Config.coefficientrf;
        this.tier = tier;
        this.capacity = this.energy.capacity;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public int receiveEnergy(int paramInt, boolean paramBoolean) {
        if (this.rf) {
            return 0;
        }
        int i = (int)Math.min(this.maxStorage2 - this.energy2, (double)paramInt);
        if (!paramBoolean) {
            this.energy2 += (double)i;
            this.differenceenergy1 = i;
            if (this.tick != this.func_145831_w().func_72820_D()) {
                this.tick = this.func_145831_w().func_72820_D();
                this.perenergy = i;
            } else {
                this.perenergy += (double)i;
            }
        }
        return i;
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        this.energy.setReceivingEnabled(!this.shouldEmitEnergy());
        this.energy.setSendingEnabled(this.shouldEmitEnergy());
        this.differenceenergy = 0.0;
        this.differenceenergy1 = 0.0;
        if (this.tick != this.func_145831_w().func_72820_D()) {
            this.perenergy = 0.0;
        }
        if (this.rf) {
            if (this.energy.getEnergy() > 0.0 && this.energy2 < this.maxStorage2) {
                double add = Math.min(this.maxStorage2 - this.energy2, this.energy.getEnergy() * (double)Config.coefficientrf);
                add = Math.max(add, 0.0);
                this.energy2 += add;
                this.energy.useEnergy(add / (double)Config.coefficientrf);
            }
        } else if (this.energy2 > 0.0 && this.energy.getEnergy() < this.energy.getCapacity()) {
            double k = this.energy.addEnergy(this.energy2 / (double)Config.coefficientrf) * (double)Config.coefficientrf;
            this.energy2 -= k;
        }
        if (!this.list.isEmpty()) {
            NodeStats stats = EnergyNetGlobal.instance.getNodeStats(this.energy.getDelegate());
            if (this.rf) {
                if (stats != null) {
                    this.differenceenergy1 = stats.getEnergyIn();
                }
            } else if (stats != null) {
                this.differenceenergy = stats.getEnergyOut();
            }
        }
        int transfer = (int)Math.min(this.energy2, EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier()));
        this.energy2 -= (double)transfer;
        this.energy2 += (double)this.transmitEnergy(transfer);
        boolean needsInvUpdate = this.upgradeSlot.tickNoMark();
        if (needsInvUpdate) {
            this.setOverclockRates();
        }
        this.energy2 = Math.min(this.energy2, this.maxStorage2);
    }

    private int transmitEnergy(int energy) {
        EnumFacing[] var2;
        for (EnumFacing e : var2 = EnumFacing.values()) {
            TileEntity te;
            BlockPos neighbor = this.getBlockPos().func_177972_a(e);
            if (!this.field_145850_b.func_175667_e(neighbor) || (te = this.field_145850_b.func_175625_s(neighbor)) == null) continue;
            IEnergyStorage storage = null;
            if (te.hasCapability(CapabilityEnergy.ENERGY, e.func_176734_d())) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, e.func_176734_d());
            } else if (te.hasCapability(CapabilityEnergy.ENERGY, null)) {
                storage = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, null);
            }
            if (storage == null || (energy -= storage.receiveEnergy(energy, false)) > 0) continue;
            return 0;
        }
        return energy;
    }

    protected boolean shouldEmitEnergy() {
        return !this.rf;
    }

    public int extractEnergy(int paramInt, boolean paramBoolean) {
        if (!this.rf) {
            return 0;
        }
        int i = (int)Math.min(Math.min(this.energy2, EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier())), (double)paramInt);
        if (!paramBoolean) {
            this.energy2 -= (double)i;
            this.differenceenergy += (double)i;
        }
        return i;
    }

    public int getEnergyStored() {
        return (int)this.energy2;
    }

    public int getMaxEnergyStored() {
        return (int)this.maxStorage2;
    }

    public boolean canExtract() {
        return this.rf;
    }

    public boolean canReceive() {
        return !this.rf;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
        this.tier = nbttagcompound.func_74762_e("tier");
        this.energy2 = ModUtils.limit((double)nbttagcompound.func_74769_h("energy2"), (double)0.0, (double)this.maxStorage2);
        this.rf = nbttagcompound.func_74767_n("rf");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        if (this.energy2 > 0.0) {
            nbttagcompound.func_74780_a("energy2", this.energy2);
        }
        nbttagcompound.func_74768_a("tier", this.tier);
        nbttagcompound.func_74757_a("rf", this.rf);
        return nbttagcompound;
    }

    public int getCapacity() {
        return (int)this.energy.getCapacity();
    }

    public int getOutput() {
        return (int)EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier());
    }

    public int addEnergy(int amount) {
        this.energy.addEnergy((double)amount);
        return amount;
    }

    public ContainerFEConverter getGuiContainer(EntityPlayer player) {
        this.list.add(player);
        return new ContainerFEConverter(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiFEConverter(this.getGuiContainer(entityPlayer));
    }

    public void updateTileServer(EntityPlayer player, double event) {
        this.rf = !this.rf;
    }

    public int gaugeICEnergyScaled(int i) {
        return (int)Math.min(this.energy.getEnergy() * (double)i / this.energy.getCapacity(), (double)i);
    }

    public int gaugeTEEnergyScaled(int i) {
        this.maxStorage2 = (double)this.defaultEnergyRFStorage + this.upgradeSlot.extraEnergyStorage * (double)Config.coefficientrf;
        return (int)Math.min(this.energy2 * (double)i / this.maxStorage2, (double)i);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage);
    }
}

