/*
 * Decompiled with CFR 0.152.
 */
package com.powerutils;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.NodeStats;
import com.denfop.api.sytem.EnergyBase;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Energy;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import com.powerutils.BlockPowerConverter;
import com.powerutils.ContainerQEConverter;
import com.powerutils.GuiQEConverter;
import com.powerutils.PowerUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileQEConverter
extends TileEntityInventory
implements IUpdatableTileEvent,
IUpgradableBlock {
    public final Energy energy;
    public final InvSlotUpgrade upgradeSlot;
    public final int defaultEnergyRFStorage;
    public final int defaultEnergyStorage;
    public double capacity;
    public double capacity2;
    public double maxStorage2;
    public ComponentBaseEnergy energy2;
    public boolean rf = true;
    public double differenceenergy = 0.0;
    public double perenergy1 = 0.0;
    public double differenceenergy1 = 0.0;
    public int tier = 5;
    public List<EntityPlayer> list = new ArrayList<EntityPlayer>();

    public TileQEConverter() {
        this.energy = (Energy)this.addComponent((AbstractComponent)new Energy((TileEntityInventory)this, 40000.0, ModUtils.allFacings, ModUtils.allFacings, 5, 5, false));
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
        this.energy2 = (ComponentBaseEnergy)this.addComponent((AbstractComponent)new ComponentBaseEnergy(EnergyType.QUANTUM, (TileEntityInventory)this, 2500.0, ModUtils.allFacings, ModUtils.allFacings, 5, 5, false));
        this.energy2.setDirections(ModUtils.allFacings, ModUtils.allFacings);
        this.upgradeSlot = new InvSlotUpgrade((TileEntityInventory)this, 4);
        this.defaultEnergyStorage = 40000;
        this.defaultEnergyRFStorage = 2500;
        this.capacity = this.energy.getCapacity();
        this.capacity2 = this.energy2.getCapacity();
    }

    public IMultiTileBlock getTeBlock() {
        return BlockPowerConverter.power_utilities_qe;
    }

    public BlockTileEntity getBlock() {
        return PowerUtils.itemPowerConverter;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (this.hasComp(Energy.class)) {
            Energy energy = (Energy)this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"iu.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSourceTier()}));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate((String)"iu.item.tooltip.PowerTier", (Object[])new Object[]{energy.getSinkTier()}));
            }
        }
    }

    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.rf = (Boolean)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.tier = (Integer)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.differenceenergy1 = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
            this.differenceenergy = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.rf);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.tier);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.differenceenergy1);
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.differenceenergy);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public void onLoaded() {
        super.onLoaded();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
            this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
            this.energy2.setDirections(ModUtils.allFacings, ModUtils.allFacings);
        }
    }

    public void setOverclockRates() {
        int tier = this.upgradeSlot.getTier(5);
        this.energy.setSinkTier(tier);
        this.energy.setSourceTier(tier);
        this.energy.setCapacity(this.upgradeSlot.extraEnergyStorage + (double)this.defaultEnergyStorage);
        this.energy2.setSinkTier(tier);
        this.energy2.setSourceTier(tier);
        this.energy2.setCapacity((this.upgradeSlot.extraEnergyStorage + (double)this.defaultEnergyStorage) / 16.0);
        this.tier = tier;
        this.capacity = this.energy.capacity;
        this.capacity2 = this.energy2.capacity;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (IUCore.proxy.isSimulating()) {
            this.setOverclockRates();
        }
    }

    public void updateEntityServer() {
        boolean needsInvUpdate;
        double add;
        super.updateEntityServer();
        this.differenceenergy = 0.0;
        this.differenceenergy1 = 0.0;
        this.energy.setReceivingEnabled(!this.shouldEmitEnergy());
        this.energy.setSendingEnabled(this.shouldEmitEnergy());
        this.energy2.setReceivingEnabled(this.shouldEmitEnergy());
        this.energy2.setSendingEnabled(!this.shouldEmitEnergy());
        if (this.rf) {
            if (this.energy.getEnergy() > 0.0 && this.energy2.getEnergy() < this.energy2.getCapacity()) {
                add = Math.min(this.energy2.getFreeEnergy(), this.energy.getEnergy() / 16.0);
                add = Math.max(add, 0.0);
                this.energy2.addEnergy(add);
                this.energy.useEnergy(add * 16.0);
            }
        } else if (this.energy2.getEnergy() > 0.0 && this.energy.getEnergy() < this.energy.getCapacity()) {
            add = Math.min(this.energy.getFreeEnergy(), this.energy2.getEnergy() * 10.0);
            this.energy.addEnergy(add);
            this.energy2.useEnergy(add / 10.0);
        }
        if (this.energy2.getEnergy() > 0.0 && !this.list.isEmpty()) {
            if (this.rf) {
                NodeStats stats = EnergyNetGlobal.instance.getNodeStats(this.energy.getDelegate());
                NodeStats stats1 = EnergyBase.QE.getNodeStats(this.energy2.getDelegate(), this.field_145850_b);
                if (stats != null) {
                    this.differenceenergy1 = stats.getEnergyIn();
                }
                if (stats1 != null) {
                    this.differenceenergy = stats1.getEnergyOut();
                }
            } else {
                this.perenergy1 = this.energy.getEnergy();
                NodeStats stats = EnergyNetGlobal.instance.getNodeStats(this.energy.getDelegate());
                NodeStats stats1 = EnergyBase.QE.getNodeStats(this.energy2.getDelegate(), this.field_145850_b);
                if (stats != null) {
                    this.differenceenergy = stats.getEnergyOut();
                }
                if (stats1 != null) {
                    this.differenceenergy1 = stats1.getEnergyIn();
                }
            }
        }
        if (needsInvUpdate = this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    protected boolean shouldEmitEnergy() {
        return !this.rf;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tier = nbttagcompound.func_74762_e("tier");
        this.rf = nbttagcompound.func_74767_n("rf");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74768_a("tier", this.tier);
        nbttagcompound.func_74757_a("rf", this.rf);
        return nbttagcompound;
    }

    public int getCapacity() {
        return (int)this.energy.getCapacity();
    }

    public int getOutput() {
        return (int)EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier());
    }

    public double getOutputEnergyUnitsPerTick() {
        return EnergyNetGlobal.instance.getPowerFromTier(this.energy.getSourceTier());
    }

    public void setStored(int energy1) {
    }

    public int addEnergy(int amount) {
        this.energy.addEnergy((double)amount);
        return amount;
    }

    public boolean isTeleporterCompatible(EnumFacing side) {
        return true;
    }

    public ContainerQEConverter getGuiContainer(EntityPlayer player) {
        this.list.add(player);
        return new ContainerQEConverter(player, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiQEConverter(this.getGuiContainer(entityPlayer));
    }

    public void updateTileServer(EntityPlayer player, double event) {
        this.rf = !this.rf;
    }

    public int gaugeICEnergyScaled(int i) {
        return (int)Math.min(this.energy.getEnergy() * (double)i / this.energy.getCapacity(), (double)i);
    }

    public int gaugeTEEnergyScaled(int i) {
        return (int)Math.min(this.energy2.getEnergy() * (double)i / this.energy2.getCapacity(), (double)i);
    }

    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage);
    }
}

