/*
 * Decompiled with CFR 0.152.
 */
package com.quantumgenerators;

import com.denfop.ElectricItem;
import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.sytem.EnergyType;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.items.ItemCore;
import com.denfop.items.energy.ItemPurifier;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import com.quantumgenerators.ContainerQG;
import com.quantumgenerators.GuiQG;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class TileQuantumGenerator
extends TileEntityInventory
implements IUpdatableTileEvent {
    public final String texture;
    public final ComponentBaseEnergy energy;
    private final int meta;
    private final int tier;
    public double gen;
    public double genmax;
    private int upgrade;

    public TileQuantumGenerator(int tier, String texture, int meta) {
        this.gen = 5.0 * Math.pow(4.0, tier - 1) / 16.0;
        this.genmax = 5.0 * Math.pow(4.0, tier - 1) / 16.0;
        this.energy = (ComponentBaseEnergy)this.addComponent((AbstractComponent)ComponentBaseEnergy.asBasicSource((EnergyType)EnergyType.QUANTUM, (TileEntityInventory)this, (double)(this.gen * 32.0), (int)tier));
        this.tier = tier;
        this.texture = texture;
        this.meta = meta;
        this.upgrade = 0;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.gen = nbttagcompound.func_74769_h("gen");
        this.genmax = nbttagcompound.func_74769_h("genmax");
        this.upgrade = nbttagcompound.func_74762_e("upgrade");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74780_a("genmax", this.genmax);
        nbttagcompound.func_74780_a("gen", this.gen);
        nbttagcompound.func_74768_a("upgrade", this.upgrade);
        return nbttagcompound;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (!Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate((String)"press.lshift"));
        }
        if (Keyboard.isKeyDown((int)42)) {
            tooltip.add(Localization.translate((String)"iu.quantumgenerator.info"));
            tooltip.add(Localization.translate((String)"iu.quantumgenerator.info1"));
            tooltip.add(Localization.translate((String)"gui.SuperSolarPanel.generating") + ": " + this.genmax + Localization.translate((String)"iu.machines_work_energy_type_qe"));
        }
    }

    public boolean wrenchCanRemove(EntityPlayer player) {
        return super.wrenchCanRemove(player) && this.genmax >= 5.0 * Math.pow(4.0, this.tier - 1) / 16.0;
    }

    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.gen = (Double)DecoderHandler.decode((CustomPacketBuffer)customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode((CustomPacketBuffer)packet, (Object)this.gen);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public void onPlaced(ItemStack stack, EntityLivingBase placer, EnumFacing facing) {
        super.onPlaced(stack, placer, facing);
        this.energy.setSendingEnabled(true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(EnumFacing side, BlockPos otherPos) {
        return false;
    }

    public boolean isNormalCube() {
        return false;
    }

    public boolean doesSideBlockRendering(EnumFacing side) {
        return false;
    }

    public boolean isSideSolid(EnumFacing side) {
        return false;
    }

    public boolean clientNeedsExtraModelInfo() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return true;
    }

    public void updateEntityServer() {
        super.updateEntityServer();
        this.energy.addEnergy(this.gen);
    }

    public void onLoaded() {
        super.onLoaded();
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemCore && stack.func_77952_i() == this.meta) {
                if (this.upgrade < 8) {
                    ++this.upgrade;
                    this.gen = 5.0 * (1.0 + 0.25 * (double)this.upgrade) * Math.pow(4.0, this.tier - 1) / 16.0;
                    this.genmax = 5.0 * (1.0 + 0.25 * (double)this.upgrade) * Math.pow(4.0, this.tier - 1) / 16.0;
                    this.energy.setCapacity(this.genmax * 32.0);
                    this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.gen));
                    stack.func_190920_e(stack.func_190916_E() - 1);
                    return true;
                }
            } else if (stack.func_77973_b() instanceof ItemPurifier) {
                if (!ElectricItem.manager.canUse(stack, 500.0)) {
                    return super.onActivated(player, hand, side, hitX, hitY, hitZ);
                }
                if (this.upgrade <= -4) {
                    return super.onActivated(player, hand, side, hitX, hitY, hitZ);
                }
                ElectricItem.manager.use(stack, 500.0, null);
                --this.upgrade;
                this.gen = 5.0 * (1.0 + 0.25 * (double)this.upgrade) * Math.pow(4.0, this.tier - 1) / 16.0;
                this.genmax = 5.0 * (1.0 + 0.25 * (double)this.upgrade) * Math.pow(4.0, this.tier - 1) / 16.0;
                this.energy.setCapacity(this.genmax * 32.0);
                this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.gen));
                player.field_71071_by.func_70441_a(new ItemStack(IUItem.core, 1, this.meta));
                return true;
            }
        }
        return super.onActivated(player, hand, side, hitX, hitY, hitZ);
    }

    public void updateTileServer(EntityPlayer entityPlayer, double i) {
        this.gen = i;
        if (this.gen >= this.genmax) {
            this.gen = this.genmax;
        }
        this.energy.setCapacity(this.genmax * 32.0);
        this.energy.setSourceTier(EnergyNetGlobal.instance.getTierFromPower(this.gen));
    }

    public ContainerQG getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerQG(entityPlayer, this);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean b) {
        return new GuiQG(this.getGuiContainer(entityPlayer));
    }
}

