/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.block;

import com.google.common.base.Preconditions;
import com.the9grounds.aeadditions.api.IWrenchHandler;
import com.the9grounds.aeadditions.block.BlockAE;
import com.the9grounds.aeadditions.block.properties.PropertyFluid;
import com.the9grounds.aeadditions.models.IStateMapperRegister;
import com.the9grounds.aeadditions.registries.BlockEnum;
import com.the9grounds.aeadditions.tileentity.TileEntityCertusTank;
import com.the9grounds.aeadditions.util.TileUtil;
import com.the9grounds.aeadditions.util.WrenchUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCertusTank
extends BlockAE
implements IStateMapperRegister {
    public static final PropertyFluid FLUID = new PropertyFluid("fluid");
    public static final PropertyBool EMPTY = PropertyBool.func_177716_a((String)"empty");
    public static final PropertyBool TANK_ABOVE = PropertyBool.func_177716_a((String)"above");
    public static final PropertyBool TANK_BELOW = PropertyBool.func_177716_a((String)"below");
    public static final PropertyFluid FLUID_ABOVE = new PropertyFluid("fluid_above");
    public static final PropertyFluid FLUID_BELOW = new PropertyFluid("fluid_below");
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockCertusTank() {
        super(Material.field_151592_s, 2.0f, 10.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT || layer == BlockRenderLayer.CUTOUT;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityCertusTank();
    }

    public String func_149732_F() {
        return I18n.func_74838_a((String)(this.func_149739_a() + ".name"));
    }

    public String func_149739_a() {
        return super.func_149739_a().replace("tile.", "");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        RayTraceResult rayTraceResult;
        IWrenchHandler wrenchHandler;
        ItemStack current = player.field_71071_by.func_70448_g();
        if (player.func_70093_af() && (wrenchHandler = WrenchUtil.getHandler(current, player, rayTraceResult = new RayTraceResult(new Vec3d((double)hitX, (double)hitY, (double)hitZ), side, pos), hand)) != null) {
            BlockCertusTank.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getDropWithNBT(world, pos));
            world.func_175698_g(pos);
            wrenchHandler.wrenchUsed(current, player, rayTraceResult, hand);
            return true;
        }
        return !player.func_70093_af() && BlockCertusTank.interactWithFluidHandler(hand, world, pos, side, player);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack dropStack = new ItemStack(BlockEnum.CERTUSTANK.getBlock());
        TileEntityCertusTank tileEntityCertusTank = TileUtil.getTile((IBlockAccess)world, pos, TileEntityCertusTank.class);
        if (tileEntityCertusTank == null) {
            return dropStack;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)dropStack);
        FluidStack fluidStack = tileEntityCertusTank.tank.getFluid();
        if (fluidStack != null) {
            fluidHandler.fill(fluidStack, true);
        }
        return dropStack;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        FluidStack fluidStack;
        TileEntityCertusTank certusTank;
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityCertusTank) {
            certusTank = (TileEntityCertusTank)tileEntity;
            fluidStack = certusTank.tank.getFluid();
            if (fluidStack != null) {
                extendedBlockState = extendedBlockState.withProperty((IUnlistedProperty)FLUID, (Object)fluidStack);
            }
        }
        if (((Boolean)extendedBlockState.func_177229_b((IProperty)TANK_ABOVE)).booleanValue() && (tileEntity = world.func_175625_s(pos.func_177984_a())) != null && tileEntity instanceof TileEntityCertusTank) {
            certusTank = (TileEntityCertusTank)tileEntity;
            fluidStack = certusTank.tank.getFluid();
            if (fluidStack != null) {
                extendedBlockState = extendedBlockState.withProperty((IUnlistedProperty)FLUID_ABOVE, (Object)fluidStack);
            }
        }
        if (((Boolean)extendedBlockState.func_177229_b((IProperty)TANK_BELOW)).booleanValue() && (tileEntity = world.func_175625_s(pos.func_177977_b())) != null && tileEntity instanceof TileEntityCertusTank) {
            certusTank = (TileEntityCertusTank)tileEntity;
            fluidStack = certusTank.tank.getFluid();
            if (fluidStack != null) {
                extendedBlockState = extendedBlockState.withProperty((IUnlistedProperty)FLUID_BELOW, (Object)fluidStack);
            }
        }
        return extendedBlockState;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityCertusTank) {
            FluidStack fluidStack = ((TileEntityCertusTank)tileEntity).tank.getFluid();
            state = state.func_177226_a((IProperty)EMPTY, (Comparable)Boolean.valueOf(fluidStack == null));
        }
        TileEntity tileAbove = world.func_175625_s(pos.func_177984_a());
        TileEntity tileBelow = world.func_175625_s(pos.func_177977_b());
        return state.func_177226_a((IProperty)TANK_ABOVE, (Comparable)Boolean.valueOf(tileAbove instanceof TileEntityCertusTank)).func_177226_a((IProperty)TANK_BELOW, (Comparable)Boolean.valueOf(tileBelow instanceof TileEntityCertusTank));
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, new IProperty[]{EMPTY, TANK_ABOVE, TANK_BELOW}, new IUnlistedProperty[]{FLUID, FLUID_ABOVE, FLUID_BELOW});
    }

    public ItemStack getDropWithNBT(World world, BlockPos pos) {
        TileEntity worldTE = world.func_175625_s(pos);
        if (worldTE != null && worldTE instanceof TileEntityCertusTank) {
            ItemStack dropStack = new ItemStack(BlockEnum.CERTUSTANK.getBlock());
            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)dropStack);
            FluidStack fluidStack = ((TileEntityCertusTank)worldTE).tank.getFluid();
            if (fluidStack != null) {
                fluidHandler.fill(fluidStack, true);
            }
            return dropStack;
        }
        return null;
    }

    private static boolean interactWithFluidHandler(EnumHand hand, World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)pos);
        IFluidHandler blockFluidHandler = FluidUtil.getFluidHandler((World)world, (BlockPos)pos, (EnumFacing)side);
        return blockFluidHandler != null && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)blockFluidHandler);
    }

    public void onNeighborChange(IBlockAccess blockAccess, BlockPos pos, BlockPos neighbor) {
        World world = (World)blockAccess;
        if (!world.field_72995_K) {
            world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 0);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
    }
}

