/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.config;

import com.the9grounds.aeadditions.config.CellConfig;
import com.the9grounds.aeadditions.item.storage.StorageRegistry;
import com.the9grounds.aeadditions.registries.CellDefinition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0016\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J\u0006\u0010\u0016\u001a\u00020\u000eR)\u0010\u0005\u001a\u001a\u0012\u0004\u0012\u00020\u0007\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/the9grounds/aeadditions/config/AEAConfiguration;", "", "configuration", "Lnet/minecraftforge/common/config/Configuration;", "(Lnet/minecraftforge/common/config/Configuration;)V", "cellEntries", "", "Lcom/the9grounds/aeadditions/registries/CellDefinition;", "", "", "Lcom/the9grounds/aeadditions/config/CellConfig;", "getCellEntries", "()Ljava/util/Map;", "createCellsAndComponentEntries", "", "onChangeConfig", "event", "Lnet/minecraftforge/fml/client/event/ConfigChangedEvent$OnConfigChangedEvent;", "registerSpecificCellEntries", "componentBuilder", "Lcom/the9grounds/aeadditions/item/storage/StorageRegistry$Builder;", "cellDefinition", "reload", "Companion", "AEAdditions-1.12.2"})
public final class AEAConfiguration {
    @NotNull
    private final Map<CellDefinition, Map<Integer, CellConfig>> cellEntries;
    private final Configuration configuration;
    @JvmField
    @Nullable
    public static StorageRegistry components;
    public static final Companion Companion;

    @NotNull
    public final Map<CellDefinition, Map<Integer, CellConfig>> getCellEntries() {
        return this.cellEntries;
    }

    public final void createCellsAndComponentEntries() {
        StorageRegistry.Builder componentBuilder = new StorageRegistry.Builder("components");
        for (CellDefinition cellDef : CellDefinition.values()) {
            this.registerSpecificCellEntries(componentBuilder, cellDef);
        }
        components = componentBuilder.build();
    }

    public final void registerSpecificCellEntries(@NotNull StorageRegistry.Builder componentBuilder, @NotNull CellDefinition cellDefinition) {
        Intrinsics.checkParameterIsNotNull((Object)componentBuilder, (String)"componentBuilder");
        Intrinsics.checkParameterIsNotNull((Object)((Object)cellDefinition), (String)"cellDefinition");
        Map<Integer, CellConfig> entries = this.cellEntries.get((Object)cellDefinition);
        StorageRegistry.Builder cellBuilder = new StorageRegistry.Builder("cells");
        cellDefinition.componentMetaStart = componentBuilder.size();
        Map<Integer, CellConfig> map = entries;
        if (map == null) {
            Intrinsics.throwNpe();
        }
        Map<Integer, CellConfig> $this$forEach$iv = map;
        boolean $i$f$forEach = false;
        Map<Integer, CellConfig> map2 = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<Integer, CellConfig>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, CellConfig> element$iv;
            Map.Entry<Integer, CellConfig> $dstr$k$v = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<Integer, CellConfig> entry = $dstr$k$v;
            boolean bl3 = false;
            int k = ((Number)entry.getKey()).intValue();
            entry = $dstr$k$v;
            bl3 = false;
            CellConfig v = entry.getValue();
            componentBuilder.add(cellDefinition, String.valueOf(k), v);
            cellBuilder.add(cellDefinition, String.valueOf(k), v);
        }
        cellDefinition.cells = cellBuilder.build();
    }

    public final void reload() {
        for (CellDefinition cellDefinition : CellDefinition.values()) {
            boolean bl = false;
            Map entries = new LinkedHashMap();
            Iterator<Integer> iterator = cellDefinition.getSizes().iterator();
            while (iterator.hasNext()) {
                String category;
                int cell = ((Number)iterator.next()).intValue();
                String string = "%s.%d";
                Object[] objectArray = new Object[]{cellDefinition.getConfigCategory(), cell};
                boolean bl2 = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
                this.configuration.addCustomCategoryComment(cellDefinition.getConfigCategory(), "Do not edit the keys as the keys point to model & texture definitions");
                int size = this.configuration.get(category, "size", cell, "Size in K").getInt();
                boolean enabled = this.configuration.get(category, "enabled", true).getBoolean();
                int numberOfTypes = this.configuration.get(category, "numberOfTypes", cellDefinition.getDefaultNumberOfTypes(), "Be careful to not go too crazy with this on the higher cells, the size of nbt can get crazy and cause issues. I may add an upper limit in the future.").getInt();
                entries.put(cell, new CellConfig(size, enabled, String.valueOf(cell), numberOfTypes, cellDefinition));
            }
            this.cellEntries.put(cellDefinition, MapsKt.toMap((Map)entries));
        }
        if (this.configuration.hasChanged()) {
            this.configuration.save();
        }
    }

    @SubscribeEvent
    public final void onChangeConfig(@NotNull ConfigChangedEvent.OnConfigChangedEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (event.getModID().equals("aeadditions")) {
            return;
        }
        this.reload();
    }

    public AEAConfiguration(@NotNull Configuration configuration) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        AEAConfiguration aEAConfiguration = this;
        boolean bl = false;
        aEAConfiguration.cellEntries = map = (Map)new LinkedHashMap();
    }

    static {
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/the9grounds/aeadditions/config/AEAConfiguration$Companion;", "", "()V", "components", "Lcom/the9grounds/aeadditions/item/storage/StorageRegistry;", "AEAdditions-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

