/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.container.gas;

import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import com.the9grounds.aeadditions.api.IPortableGasStorageCell;
import com.the9grounds.aeadditions.api.IWirelessGasTermHandler;
import com.the9grounds.aeadditions.container.ContainerStorage;
import com.the9grounds.aeadditions.container.StorageType;
import com.the9grounds.aeadditions.util.AEUtils;
import com.the9grounds.aeadditions.util.GasUtil;
import com.the9grounds.aeadditions.util.PlayerSource;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import org.apache.commons.lang3.tuple.MutablePair;

public class ContainerGasStorage
extends ContainerStorage {
    private boolean doNextFill = false;

    public ContainerGasStorage(EntityPlayer player, EnumHand hand) {
        super(StorageType.GAS, player, hand);
    }

    public ContainerGasStorage(IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, IPortableGasStorageCell storageCell, EnumHand hand) {
        super(StorageType.GAS, monitor, player, storageCell, hand);
    }

    public ContainerGasStorage(IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, IWirelessGasTermHandler handler, EnumHand hand) {
        super(StorageType.GAS, monitor, player, handler, hand);
    }

    public ContainerGasStorage(IMEMonitor<IAEFluidStack> monitor, EntityPlayer player, EnumHand hand) {
        super(StorageType.GAS, monitor, player, hand);
    }

    @Override
    public void doWork() {
        this.doWorkMekanism();
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public void doWorkMekanism() {
        ItemStack secondSlot = this.inventory.func_70301_a(1);
        if (secondSlot != null && !secondSlot.func_190926_b() && secondSlot.func_190916_E() >= secondSlot.func_77976_d()) {
            return;
        }
        ItemStack container = this.inventory.func_70301_a(0);
        if (container == null || container.func_190926_b()) {
            this.doNextFill = false;
        }
        if (!GasUtil.isGasContainer(container)) {
            return;
        }
        if (this.monitor == null) {
            return;
        }
        GasStack gasStack = GasUtil.getGasFromContainer(container);
        container = container.func_77946_l();
        container.func_190920_e(1);
        if (GasUtil.isEmpty(container) || gasStack.amount < GasUtil.getCapacity(container) && GasUtil.getFluidStack(gasStack).getFluid() == this.selectedFluid && this.doNextFill) {
            if (this.selectedFluid == null) {
                return;
            }
            int capacity = GasUtil.getCapacity(container);
            IAEFluidStack result2 = (IAEFluidStack)this.monitor.extractItems((IAEStack)AEUtils.createFluidStack(this.selectedFluid, (long)capacity), Actionable.SIMULATE, (IActionSource)new PlayerSource(this.player, null));
            int proposedAmount = result2 == null ? 0 : (gasStack == null ? (int)Math.min((long)capacity, result2.getStackSize()) : (int)Math.min((long)(capacity - gasStack.amount), result2.getStackSize()));
            MutablePair<Integer, ItemStack> filledContainer = GasUtil.fillStack(container, GasUtil.getGasStack(new FluidStack(this.selectedFluid, proposedAmount)));
            GasStack gasStack2 = GasUtil.getGasFromContainer((ItemStack)filledContainer.getRight());
            if (container.func_190916_E() == 1 && gasStack2.amount < GasUtil.getCapacity((ItemStack)filledContainer.getRight())) {
                this.inventory.func_70299_a(0, (ItemStack)filledContainer.getRight());
                this.monitor.extractItems((IAEStack)AEUtils.createFluidStack(this.selectedFluid, (long)((Integer)filledContainer.getLeft()).intValue()), Actionable.MODULATE, (IActionSource)new PlayerSource(this.player, null));
                this.doNextFill = true;
            } else if (this.fillSecondSlot((ItemStack)filledContainer.getRight())) {
                this.monitor.extractItems((IAEStack)AEUtils.createFluidStack(this.selectedFluid, (long)((Integer)filledContainer.getLeft()).intValue()), Actionable.MODULATE, (IActionSource)new PlayerSource(this.player, null));
                this.decreaseFirstSlot();
                this.doNextFill = false;
            }
        } else if (GasUtil.isFilled(container)) {
            GasStack containerGas = GasUtil.getGasFromContainer(container);
            MutablePair<Integer, ItemStack> drainedContainer = GasUtil.drainStack(container.func_77946_l(), containerGas);
            GasStack gasStack1 = containerGas.copy();
            gasStack1.amount = (Integer)drainedContainer.getLeft();
            IAEFluidStack notInjected = (IAEFluidStack)this.monitor.injectItems((IAEStack)GasUtil.createAEFluidStack(gasStack1), Actionable.SIMULATE, (IActionSource)new PlayerSource(this.player, null));
            if (notInjected != null) {
                return;
            }
            ItemStack handItem = this.player.func_184586_b(this.hand);
            if (this.handler != null) {
                if (!this.handler.hasPower(this.player, 20.0, handItem)) {
                    return;
                }
                this.handler.usePower(this.player, 20.0, handItem);
            } else if (this.storageCell != null) {
                if (!this.storageCell.hasPower(this.player, 20.0, handItem)) {
                    return;
                }
                this.storageCell.usePower(this.player, 20.0, handItem);
            }
            ItemStack emptyContainer = (ItemStack)drainedContainer.getRight();
            if (emptyContainer != null && !emptyContainer.func_190926_b() && GasUtil.getGasFromContainer(emptyContainer) != null && emptyContainer.func_190916_E() == 1) {
                this.monitor.injectItems((IAEStack)GasUtil.createAEFluidStack(gasStack1), Actionable.MODULATE, (IActionSource)new PlayerSource(this.player, null));
                this.inventory.func_70299_a(0, emptyContainer);
            } else if (emptyContainer == null || emptyContainer.func_190926_b() || this.fillSecondSlot((ItemStack)drainedContainer.getRight())) {
                this.monitor.injectItems((IAEStack)GasUtil.createAEFluidStack(containerGas), Actionable.MODULATE, (IActionSource)new PlayerSource(this.player, null));
                this.decreaseFirstSlot();
            }
        }
    }
}

