/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.integration.mekanism.gas;

import appeng.api.config.FuzzyMode;
import appeng.api.storage.IStorageChannel;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.api.gas.IGasStorageChannel;
import com.the9grounds.aeadditions.item.ItemGas;
import com.the9grounds.aeadditions.registries.ItemEnum;
import com.the9grounds.aeadditions.util.StorageChannels;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B\u0011\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0001H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u0001H\u0016J\u0013\u0010\u001e\u001a\u00020\u00112\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0096\u0002J\u001c\u0010!\u001a\u00020\u00112\b\u0010\u0004\u001a\u0004\u0018\u00010\u00012\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00010%H\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\n\u0010'\u001a\u0004\u0018\u00010 H\u0016J\b\u0010(\u001a\u00020\u0005H\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010.\u001a\u00020\u0011H\u0016J\b\u0010/\u001a\u00020\u0011H\u0016J\b\u00100\u001a\u00020\u0011H\u0016J\b\u00101\u001a\u00020\u0011H\u0016J\b\u00102\u001a\u00020\u0001H\u0016J\u0010\u00103\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u000eH\u0016J\u0010\u00104\u001a\u00020\u00012\u0006\u0010.\u001a\u00020\u0011H\u0016J\u0010\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u00020\u000eH\u0016J\u0012\u00107\u001a\u00020\u00152\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u00108\u001a\u00020\u00152\b\u00109\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/the9grounds/aeadditions/integration/mekanism/gas/AEGasStack;", "Lcom/the9grounds/aeadditions/api/gas/IAEGasStack;", "oldStack", "(Lcom/the9grounds/aeadditions/integration/mekanism/gas/AEGasStack;)V", "gasStack", "Lmekanism/api/gas/GasStack;", "(Lmekanism/api/gas/GasStack;)V", "nbt", "Lnet/minecraft/nbt/NBTTagCompound;", "(Lnet/minecraft/nbt/NBTTagCompound;)V", "data", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;)V", "_countRequestable", "", "_stackSize", "canCraft", "", "gas", "Lmekanism/api/gas/Gas;", "add", "", "stack", "asItemStackRepresentation", "Lnet/minecraft/item/ItemStack;", "copy", "decCountRequestable", "amount", "decStackSize", "empty", "equals", "other", "", "fuzzyComparison", "fuzzyMode", "Lappeng/api/config/FuzzyMode;", "getChannel", "Lappeng/api/storage/IStorageChannel;", "getCountRequestable", "getGas", "getGasStack", "getStackSize", "hashCode", "", "incCountRequestable", "incStackSize", "isCraftable", "isFluid", "isItem", "isMeaningful", "reset", "setCountRequestable", "setCraftable", "setStackSize", "stackSize", "writeToNBT", "writeToPacket", "byteBuffer", "AEAdditions-1.12.2"})
public final class AEGasStack
implements IAEGasStack {
    private boolean canCraft;
    private long _stackSize;
    private long _countRequestable;
    private Gas gas;

    @Override
    public void add(@Nullable IAEGasStack stack) {
        if (stack == null) {
            return;
        }
        this.incStackSize(stack.getStackSize());
        this.setCountRequestable(this.getCountRequestable() + stack.getCountRequestable());
        this.setCraftable(this.isCraftable() || stack.isCraftable());
    }

    public long getStackSize() {
        return this._stackSize;
    }

    @NotNull
    public IAEGasStack setStackSize(long stackSize) {
        this._stackSize = stackSize;
        return this;
    }

    public long getCountRequestable() {
        return this._countRequestable;
    }

    @NotNull
    public IAEGasStack setCountRequestable(long amount) {
        this._countRequestable = amount;
        return this;
    }

    public boolean isCraftable() {
        return this.canCraft;
    }

    @NotNull
    public IAEGasStack setCraftable(boolean isCraftable) {
        this.canCraft = isCraftable;
        return this;
    }

    @NotNull
    public IAEGasStack reset() {
        this.setStackSize(0L);
        this._countRequestable = 0L;
        this.canCraft = false;
        return this;
    }

    public boolean isMeaningful() {
        return (int)this.getStackSize() != 0 || this.getCountRequestable() > 0L || this.isCraftable();
    }

    public void incStackSize(long amount) {
        this._stackSize += amount;
    }

    public void decStackSize(long amount) {
        this._stackSize -= amount;
    }

    public void incCountRequestable(long amount) {
        this._countRequestable += amount;
    }

    public void decCountRequestable(long amount) {
        this._countRequestable -= amount;
    }

    public void writeToNBT(@Nullable NBTTagCompound nbt) {
        if (this.gas == null || nbt == null) {
            return;
        }
        Gas gas = this.gas;
        if (gas == null) {
            Intrinsics.throwNpe();
        }
        gas.write(nbt);
        nbt.func_74772_a("amount", this.getStackSize());
        nbt.func_74757_a("isCraftable", this.isCraftable());
        nbt.func_74772_a("countRequestable", this.getCountRequestable());
    }

    public boolean fuzzyComparison(@Nullable IAEGasStack gasStack, @Nullable FuzzyMode fuzzyMode) {
        IAEGasStack iAEGasStack = gasStack;
        return iAEGasStack instanceof Gas ? Intrinsics.areEqual((Object)gasStack, (Object)this.gas) : (iAEGasStack instanceof IAEGasStack ? Intrinsics.areEqual((Object)gasStack.getGas(), (Object)this.gas) : (iAEGasStack instanceof AEGasStack ? Intrinsics.areEqual((Object)((AEGasStack)gasStack).gas, (Object)this.gas) : false));
    }

    public void writeToPacket(@Nullable ByteBuf byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(byteOutputStream);
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)outputStream);
        byte[] bytes = byteOutputStream.toByteArray();
        int length = bytes.length;
        byteBuffer.writeInt(length);
        byteBuffer.writeBytes(bytes);
    }

    @Override
    @NotNull
    public IAEGasStack copy() {
        return new AEGasStack(this);
    }

    @NotNull
    public IAEGasStack empty() {
        IAEGasStack newStack = this.copy();
        newStack.reset();
        return newStack;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isFluid() {
        return false;
    }

    @NotNull
    public IStorageChannel<IAEGasStack> getChannel() {
        IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
        if (iGasStorageChannel == null) {
            Intrinsics.throwNpe();
        }
        return iGasStorageChannel;
    }

    @NotNull
    public ItemStack asItemStackRepresentation() {
        ItemStack stack = ItemEnum.GASITEM.getSizedStack(1);
        Gas gas = this.gas;
        if (gas == null) {
            Intrinsics.throwNpe();
        }
        String string = gas.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gas!!.name");
        ItemGas.setGasName(stack, string);
        ItemStack itemStack = stack;
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
        return itemStack;
    }

    @NotNull
    public GasStack getGasStack() {
        int n;
        int n2 = Integer.MAX_VALUE;
        int n3 = (int)this.getStackSize();
        Gas gas = this.gas;
        boolean bl = false;
        int n4 = n = Math.min(n2, n3);
        Gas gas2 = gas;
        return new GasStack(gas2, n4);
    }

    @Override
    @Nullable
    public Object getGas() {
        return this.gas;
    }

    public int hashCode() {
        Gas gas = this.gas;
        boolean bl = false;
        Gas gas2 = gas;
        return gas2 != null ? gas2.hashCode() : 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.the9grounds.aeadditions.integration.mekanism.gas.AEGasStack");
        }
        AEGasStack cfr_ignored_0 = (AEGasStack)object2;
        if (this.canCraft != ((AEGasStack)other).canCraft) {
            return false;
        }
        if (this._countRequestable != ((AEGasStack)other)._countRequestable) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.gas, (Object)((AEGasStack)other).gas) ^ true);
    }

    public AEGasStack(@NotNull AEGasStack oldStack) {
        Intrinsics.checkParameterIsNotNull((Object)oldStack, (String)"oldStack");
        this.gas = oldStack.gas;
        this.setStackSize(oldStack.getStackSize());
        this.setCraftable(oldStack.isCraftable());
        this.setCountRequestable(oldStack.getCountRequestable());
    }

    public AEGasStack(@Nullable GasStack gasStack) {
        if (gasStack == null || gasStack.getGas() == null) {
            throw (Throwable)new IllegalArgumentException("Gas is null");
        }
        this.gas = gasStack.getGas();
        this.setStackSize(gasStack.amount);
        this.setCraftable(false);
        this.setCountRequestable(0L);
    }

    public AEGasStack(@NotNull NBTTagCompound nbt) {
        Intrinsics.checkParameterIsNotNull((Object)nbt, (String)"nbt");
        this.gas = Gas.readFromNBT((NBTTagCompound)nbt);
        this.setStackSize(nbt.func_74763_f("amount"));
        this.setCraftable(nbt.func_74767_n("isCraftable"));
        this.setCountRequestable(nbt.func_74763_f("countRequestable"));
    }

    public AEGasStack(@NotNull ByteBuf data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        int length = data.readInt();
        byte[] bytes = new byte[length];
        data.readBytes(bytes);
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(bytes));
        NBTTagCompound nbt = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        this.gas = Gas.readFromNBT((NBTTagCompound)nbt);
        this.setStackSize(nbt.func_74763_f("amount"));
        this.setCraftable(nbt.func_74767_n("isCraftable"));
        this.setCountRequestable(nbt.func_74763_f("countRequestable"));
    }
}

