/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.integration.opencomputers;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import li.cil.oc.api.API;
import li.cil.oc.api.detail.ItemInfo;
import li.cil.oc.common.item.data.DroneData;
import li.cil.oc.common.item.data.RobotData;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007JO\u0010\r\u001a\u0004\u0018\u0001H\u000e\"\b\b\u0000\u0010\u000e*\u00020\u000f\"\b\b\u0001\u0010\u0010*\u0002H\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0018H\u0007\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0004H\u0007\u00a8\u0006\u001e"}, d2={"Lcom/the9grounds/aeadditions/integration/opencomputers/OCUtils;", "", "()V", "getComponent", "Lnet/minecraft/item/ItemStack;", "drone", "Lli/cil/oc/common/item/data/DroneData;", "item", "Lnet/minecraft/item/Item;", "meta", "", "robot", "Lli/cil/oc/common/item/data/RobotData;", "getPart", "P", "Lappeng/api/parts/IPart;", "C", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "location", "Lappeng/api/util/AEPartLocation;", "clazz", "Ljava/lang/Class;", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lappeng/api/util/AEPartLocation;Ljava/lang/Class;)Lappeng/api/parts/IPart;", "isDrone", "", "itemStack", "isRobot", "AEAdditions-1.12.2"})
public final class OCUtils {
    public static final OCUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final <P extends IPart, C extends P> P getPart(@Nullable World world, @Nullable BlockPos pos, @Nullable AEPartLocation location, @NotNull Class<C> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        if (world == null || pos == null) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !(tile instanceof IPartHost)) {
            return null;
        }
        if (location == null || location == AEPartLocation.INTERNAL) {
            for (AEPartLocation side : AEPartLocation.SIDE_LOCATIONS) {
                IPart part = ((IPartHost)tile).getPart(side);
                if (part == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(clazz.getClass()), (Object)Reflection.getOrCreateKotlinClass(part.getClass()))) continue;
                return (P)part;
            }
            return null;
        }
        IPart part = ((IPartHost)tile).getPart(location);
        if (part == null || Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(clazz.getClass()), (Object)Reflection.getOrCreateKotlinClass(part.getClass())) ^ true) {
            return null;
        }
        return (P)part;
    }

    @JvmStatic
    public static final boolean isRobot(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
        ItemInfo itemInfo = API.items.get(itemStack);
        if (itemInfo == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)itemInfo, (String)"API.items.get(itemStack) ?: return false");
        ItemInfo item = itemInfo;
        return Intrinsics.areEqual((Object)item.name(), (Object)"robot");
    }

    @JvmStatic
    public static final boolean isDrone(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
        ItemInfo itemInfo = API.items.get(itemStack);
        if (itemInfo == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)itemInfo, (String)"API.items.get(itemStack) ?: return false");
        ItemInfo item = itemInfo;
        return Intrinsics.areEqual((Object)item.name(), (Object)"drone");
    }

    @JvmStatic
    @Nullable
    public static final ItemStack getComponent(@NotNull RobotData robot, @NotNull Item item, int meta) {
        Intrinsics.checkParameterIsNotNull((Object)robot, (String)"robot");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        for (ItemStack component : robot.components()) {
            if (component == null || !Intrinsics.areEqual((Object)component.func_77973_b(), (Object)item)) continue;
            return component;
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final ItemStack getComponent(@NotNull RobotData robot, @NotNull Item item) {
        Intrinsics.checkParameterIsNotNull((Object)robot, (String)"robot");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return OCUtils.getComponent(robot, item, 0);
    }

    @JvmStatic
    @Nullable
    public static final ItemStack getComponent(@NotNull DroneData drone, @NotNull Item item, int meta) {
        Intrinsics.checkParameterIsNotNull((Object)drone, (String)"drone");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        for (ItemStack component : drone.components()) {
            if (component == null || !Intrinsics.areEqual((Object)component.func_77973_b(), (Object)item)) continue;
            return component;
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final ItemStack getComponent(@NotNull DroneData drone, @NotNull Item item) {
        Intrinsics.checkParameterIsNotNull((Object)drone, (String)"drone");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return OCUtils.getComponent(drone, item, 0);
    }

    private OCUtils() {
    }

    static {
        OCUtils oCUtils;
        INSTANCE = oCUtils = new OCUtils();
    }
}

