/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import cofh.redstoneflux.api.IEnergyContainerItem;
import com.the9grounds.aeadditions.item.ItemECBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux", striprefs=true)
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b'\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\r\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0012\u0010\u0017\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\fH\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0017J\u0012\u0010\u001b\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0017J$\u0010\u001c\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\"\u0010\u001d\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0017R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lcom/the9grounds/aeadditions/item/PowerItem;", "Lcom/the9grounds/aeadditions/item/ItemECBase;", "Lappeng/api/implementations/items/IAEItemPowerStorage;", "Lcofh/redstoneflux/api/IEnergyContainerItem;", "()V", "MAX_POWER", "", "getMAX_POWER", "()D", "ensureTagCompound", "Lnet/minecraft/nbt/NBTTagCompound;", "itemStack", "Lnet/minecraft/item/ItemStack;", "extractAEPower", "amt", "actionable", "Lappeng/api/config/Actionable;", "extractEnergy", "", "container", "maxExtract", "simulate", "", "getAECurrentPower", "getAEMaxPower", "p0", "getEnergyStored", "getMaxEnergyStored", "injectAEPower", "receiveEnergy", "maxReceive", "AEAdditions-1.12.2"})
public abstract class PowerItem
extends ItemECBase
implements IAEItemPowerStorage,
IEnergyContainerItem {
    public abstract double getMAX_POWER();

    public double injectAEPower(@Nullable ItemStack itemStack, double amt, @Nullable Actionable actionable) {
        if (itemStack == null) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double d = this.getMAX_POWER() - currentPower;
        boolean bl = false;
        double toInject = Math.min(amt, d);
        if (actionable == Actionable.MODULATE) {
            tagCompound.func_74780_a("power", currentPower + toInject);
        }
        return toInject;
    }

    public double extractAEPower(@Nullable ItemStack itemStack, double amt, @Nullable Actionable actionable) {
        if (itemStack == null) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        boolean bl = false;
        double toExtract = Math.min(amt, currentPower);
        if (actionable == Actionable.MODULATE) {
            tagCompound.func_74780_a("power", currentPower - toExtract);
        }
        return toExtract;
    }

    public double getAEMaxPower(@Nullable ItemStack p0) {
        return this.getMAX_POWER();
    }

    public double getAECurrentPower(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        return tagCompound.func_74769_h("power");
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(@Nullable ItemStack container, int maxReceive, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            double current = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(container));
            double max = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(container));
            if (max - current >= (double)maxReceive) {
                return maxReceive;
            }
            return (int)(max - current);
        }
        double currentAEPower = this.getAECurrentPower(container);
        if (currentAEPower < this.getAEMaxPower(container)) {
            return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.injectAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxReceive), Actionable.MODULATE));
        }
        return 0;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(@Nullable ItemStack container, int maxExtract, boolean simulate) {
        if (container == null) {
            return 0;
        }
        if (simulate) {
            return this.getEnergyStored(container) >= maxExtract ? maxExtract : this.getEnergyStored(container);
        }
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.extractAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxExtract), Actionable.MODULATE));
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(@Nullable ItemStack container) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(container));
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(@Nullable ItemStack container) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(container));
    }

    @NotNull
    public final NBTTagCompound ensureTagCompound(@NotNull ItemStack itemStack) {
        Intrinsics.checkParameterIsNotNull((Object)itemStack, (String)"itemStack");
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null) {
            Intrinsics.throwNpe();
        }
        return nBTTagCompound;
    }
}

