/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import cofh.redstoneflux.api.IEnergyContainerItem;
import com.the9grounds.aeadditions.inventory.ECCellInventory;
import com.the9grounds.aeadditions.item.storage.ItemStorageCell;
import com.the9grounds.aeadditions.models.ModelManager;
import com.the9grounds.aeadditions.registries.CellDefinition;
import com.the9grounds.aeadditions.registries.ItemEnum;
import com.the9grounds.aeadditions.util.AEAConfigHandler;
import com.the9grounds.aeadditions.util.StorageChannels;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

@Optional.Interface(iface="cofh.redstoneflux.api.IEnergyContainerItem", modid="redstoneflux")
public class ItemStorageCellPhysical
extends ItemStorageCell<IAEItemStack>
implements IAEItemPowerStorage,
IEnergyContainerItem {
    public static final String[] suffixes = new String[]{"256k", "1024k", "4096k", "16384k", "container"};
    public static final int[] bytes_cell = new int[]{262144, 0x100000, 0x400000, 0x1000000, 65536};
    public static final int[] types_cell = new int[]{63, 63, 63, 63, 1};
    private final int MAX_POWER = 32000;

    public ItemStorageCellPhysical() {
        super(CellDefinition.PHYSICAL, StorageChannels.ITEM);
    }

    @Override
    public int getBytesPerType(ItemStack cellItem) {
        int bytes = this.definition.cells.fromMeta(cellItem.func_77952_i()).getBytes();
        return AEAConfigHandler.dynamicTypes ? bytes / 128 : 8;
    }

    private NBTTagCompound ensureTagCompound(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public double extractAEPower(ItemStack itemStack, double amt, Actionable actionable) {
        if (itemStack == null || itemStack.func_77952_i() != 4) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toExtract = Math.min(amt, currentPower);
        if (actionable == Actionable.MODULATE) {
            tagCompound.func_74780_a("power", currentPower - toExtract);
        }
        return toExtract;
    }

    @Optional.Method(modid="redstoneflux")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container == null || container.func_77952_i() != 4) {
            return 0;
        }
        if (simulate) {
            return this.getEnergyStored(container) >= maxExtract ? maxExtract : this.getEnergyStored(container);
        }
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.extractAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxExtract), Actionable.MODULATE));
    }

    public double getAECurrentPower(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77952_i() != 4) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        return tagCompound.func_74769_h("power");
    }

    public double getAEMaxPower(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77952_i() != 4) {
            return 0.0;
        }
        return this.MAX_POWER;
    }

    @Override
    public int getBytes(ItemStack cellItem) {
        return this.definition.cells.fromMeta(cellItem.func_77952_i()).getBytes();
    }

    public IItemHandler getConfigInventory(ItemStack is) {
        return new InvWrapper((IInventory)new ECCellInventory(is, "config", 63, 1));
    }

    public double getDurabilityForDisplay(ItemStack itemStack) {
        if (itemStack == null || itemStack.func_77952_i() != 4) {
            return super.getDurabilityForDisplay(itemStack);
        }
        return 1.0 - this.getAECurrentPower(itemStack) / (double)this.MAX_POWER;
    }

    @Optional.Method(modid="redstoneflux")
    public int getEnergyStored(ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(arg0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        if (stack == null) {
            return super.func_77653_i(stack);
        }
        if (stack.func_77952_i() == 4) {
            try {
                IItemList list = AEApi.instance().registries().cell().getCellInventory(stack, null, (IStorageChannel)StorageChannels.ITEM).getAvailableItems(StorageChannels.ITEM.createList());
                if (list.isEmpty()) {
                    return super.func_77653_i(stack) + " - " + I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.empty1");
                }
                IAEItemStack s = (IAEItemStack)list.getFirstItem();
                return super.func_77653_i(stack) + " - " + s.createItemStack().func_82833_r();
            }
            catch (Throwable throwable) {
                return super.func_77653_i(stack) + " - " + I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.empty1");
            }
        }
        return super.func_77653_i(stack);
    }

    @Optional.Method(modid="redstoneflux")
    public int getMaxEnergyStored(ItemStack arg0) {
        return (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(arg0));
    }

    public AccessRestriction getPowerFlow(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return itemStack.func_77952_i() == 4 ? AccessRestriction.READ_WRITE : AccessRestriction.NO_ACCESS;
    }

    @Override
    public EnumRarity func_77613_e(ItemStack itemStack) {
        return EnumRarity.EPIC;
    }

    @Override
    public void func_150895_a(CreativeTabs creativeTab, NonNullList itemList) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (int i = 0; i < suffixes.length; ++i) {
            itemList.add((Object)new ItemStack((Item)this, 1, i));
            if (i != 4) continue;
            ItemStack s = new ItemStack((Item)this, 1, i);
            s.func_77982_d(new NBTTagCompound());
            s.func_77978_p().func_74780_a("power", (double)this.MAX_POWER);
            itemList.add((Object)s);
        }
    }

    @Override
    public int getTotalTypes(ItemStack cellItem) {
        return this.definition.cells.fromMeta(cellItem.func_77952_i()).getNumberOfTypes();
    }

    @Override
    public String func_77667_c(ItemStack itemStack) {
        return "com.the9grounds.aeadditions.item.storage.physical." + suffixes[itemStack.func_77952_i()];
    }

    public IItemHandler getUpgradesInventory(ItemStack is) {
        return new InvWrapper((IInventory)new ECCellInventory(is, "upgrades", 2, 1));
    }

    public double injectAEPower(ItemStack itemStack, double amt, Actionable actionable) {
        if (itemStack == null || itemStack.func_77952_i() != 4) {
            return 0.0;
        }
        NBTTagCompound tagCompound = this.ensureTagCompound(itemStack);
        double currentPower = tagCompound.func_74769_h("power");
        double toInject = Math.min(amt, (double)this.MAX_POWER - currentPower);
        if (actionable == Actionable.MODULATE) {
            tagCompound.func_74780_a("power", currentPower + toInject);
        }
        return toInject;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (itemStack == null) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        if (itemStack.func_77952_i() == 4 && player.func_70093_af()) {
            if (world.field_72995_K) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
            }
            switch (itemStack.func_77978_p().func_74762_e("mode")) {
                case 0: {
                    itemStack.func_77978_p().func_74768_a("mode", 1);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("com.the9grounds.aeadditions.tooltip.storage.container.1", new Object[0]));
                    break;
                }
                case 1: {
                    itemStack.func_77978_p().func_74768_a("mode", 2);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("com.the9grounds.aeadditions.tooltip.storage.container.2", new Object[0]));
                    break;
                }
                case 2: {
                    itemStack.func_77978_p().func_74768_a("mode", 0);
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("com.the9grounds.aeadditions.tooltip.storage.container.0", new Object[0]));
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        if (!player.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        ICellInventoryHandler invHandler = AEApi.instance().registries().cell().getCellInventory(itemStack, null, (IStorageChannel)StorageChannels.ITEM);
        ICellInventoryHandler inventoryHandler = invHandler;
        ICellInventory cellInv = inventoryHandler.getCellInv();
        if (cellInv.getUsedBytes() == 0L && player.field_71071_by.func_70441_a(ItemEnum.STORAGECASING.getDamagedStack(0))) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)ItemEnum.STORAGECOMPONET.getDamagedStack(itemStack.func_77952_i()));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack == null || player == null) {
            return EnumActionResult.PASS;
        }
        if (stack.func_77952_i() == 4 && !player.func_70093_af()) {
            player.func_145747_a((ITextComponent)new TextComponentString("Disabled pending rewrite"));
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    @Optional.Method(modid="redstoneflux")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container == null || container.func_77952_i() != 4) {
            return 0;
        }
        if (simulate) {
            double current = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAECurrentPower(container));
            double max = PowerUnits.AE.convertTo(PowerUnits.RF, this.getAEMaxPower(container));
            if (max - current >= (double)maxReceive) {
                return maxReceive;
            }
            return (int)(max - current);
        }
        int notStored = (int)PowerUnits.AE.convertTo(PowerUnits.RF, this.injectAEPower(container, PowerUnits.RF.convertTo(PowerUnits.AE, (double)maxReceive), Actionable.MODULATE));
        return maxReceive - notStored;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, ModelManager manager) {
        for (int i = 0; i < suffixes.length; ++i) {
            manager.registerItemModel(item, i, "storage/physical/cells/" + suffixes[i]);
        }
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.func_77952_i() == 4;
    }
}

