/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.item.storage;

import appeng.api.implementations.items.IStorageComponent;
import com.the9grounds.aeadditions.config.AEAConfiguration;
import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.item.ItemECBase;
import com.the9grounds.aeadditions.item.storage.StorageType;
import com.the9grounds.aeadditions.models.ModelManager;
import com.the9grounds.aeadditions.registries.CellDefinition;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemStorageComponent
extends ItemECBase
implements IStorageComponent {
    public ItemStorageComponent() {
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public int getBytes(ItemStack itemStack) {
        StorageType type = AEAConfiguration.components.fromMeta(itemStack.func_77952_i());
        return type.getBytes();
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        StorageType type = AEAConfiguration.components.fromMeta(itemStack.func_77952_i());
        CellDefinition definition = type.getDefinition();
        return definition.getRarity();
    }

    public void func_150895_a(CreativeTabs creativeTab, NonNullList itemList) {
        if (!this.func_194125_a(creativeTab)) {
            return;
        }
        for (StorageType type : AEAConfiguration.components) {
            if (type.getDefinition() == CellDefinition.GAS && !Integration.Mods.MEKANISMGAS.isEnabled() || !type.getEnabled().booleanValue()) continue;
            itemList.add((Object)new ItemStack((Item)this, 1, type.getMeta()));
        }
    }

    public String func_77667_c(ItemStack itemStack) {
        StorageType type = AEAConfiguration.components.fromMeta(itemStack.func_77952_i());
        return "com.the9grounds.aeadditions.item.storage.component." + type.getIdentifier();
    }

    public String func_77653_i(ItemStack stack) {
        StorageType type = AEAConfiguration.components.fromMeta(stack.func_77952_i());
        return String.format(super.func_77653_i(stack), type.getSize());
    }

    public boolean isStorageComponent(ItemStack itemStack) {
        return itemStack.func_77973_b() == this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, ModelManager manager) {
        for (StorageType type : AEAConfiguration.components) {
            if (type.getDefinition() == CellDefinition.GAS && !Integration.Mods.MEKANISMGAS.isEnabled() || !type.getEnabled().booleanValue()) continue;
            manager.registerItemModel(item, type.getMeta(), type.getModelName());
        }
    }
}

