/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.models.blocks;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.the9grounds.aeadditions.block.BlockCertusTank;
import com.the9grounds.aeadditions.models.BlankModel;
import com.the9grounds.aeadditions.models.ModelFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.util.vector.Vector3f;

public class ModelTankFluid
extends BlankModel {
    public static final Cache<Key, List<BakedQuad>> blockModels = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    public static final Cache<Key, List<BakedQuad>> itemModels = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        Key key;
        ImmutableList<BakedQuad> fluidQuads;
        if (side != null || !(state instanceof IExtendedBlockState)) {
            return ImmutableList.of();
        }
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)state;
        FluidStack stack = (FluidStack)extendedBlockState.getValue((IUnlistedProperty)BlockCertusTank.FLUID);
        int amount = stack.amount / 500;
        if (stack.amount > 0 && amount == 0) {
            amount = 1;
        }
        boolean renderTop = true;
        if (((Boolean)extendedBlockState.func_177229_b((IProperty)BlockCertusTank.TANK_ABOVE)).booleanValue()) {
            FluidStack topFluid = (FluidStack)extendedBlockState.getValue((IUnlistedProperty)BlockCertusTank.FLUID_ABOVE);
            renderTop = topFluid == null || topFluid.getFluid() != stack.getFluid() || topFluid.amount == 0;
        }
        boolean renderBelow = true;
        if (((Boolean)extendedBlockState.func_177229_b((IProperty)BlockCertusTank.TANK_BELOW)).booleanValue()) {
            FluidStack bottomFluid = (FluidStack)extendedBlockState.getValue((IUnlistedProperty)BlockCertusTank.FLUID_BELOW);
            boolean bl = renderBelow = bottomFluid == null || bottomFluid.getFluid() != stack.getFluid() || bottomFluid.amount != 32000;
        }
        if ((fluidQuads = (ImmutableList<BakedQuad>)blockModels.getIfPresent((Object)(key = new Key(stack.getFluid(), amount, (Boolean)state.func_177229_b((IProperty)BlockCertusTank.TANK_ABOVE), (Boolean)state.func_177229_b((IProperty)BlockCertusTank.TANK_BELOW), renderTop, renderBelow)))) == null) {
            fluidQuads = ModelTankFluid.createQuads(key);
            blockModels.put((Object)key, fluidQuads);
        }
        return fluidQuads;
    }

    public List<BakedQuad> getQuads(FluidStack stack) {
        Key key;
        ImmutableList<BakedQuad> fluidQuads;
        int amount = stack.amount / 500;
        if (stack.amount > 0 && amount == 0) {
            amount = 1;
        }
        if ((fluidQuads = (ImmutableList<BakedQuad>)itemModels.getIfPresent((Object)(key = new Key(stack.getFluid(), amount, false, false)))) == null) {
            fluidQuads = ModelTankFluid.createQuads(key);
            itemModels.put((Object)key, fluidQuads);
        }
        return fluidQuads;
    }

    private static ImmutableList<BakedQuad> createQuads(Key key) {
        float maxY = (float)key.amount / 4.0f;
        ResourceLocation resourceLocation = key.fluid.getStill();
        TextureMap textureMap = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite sprite = textureMap.func_110572_b(resourceLocation.toString());
        if (sprite == null) {
            return ImmutableList.of();
        }
        if (maxY == 16.0f && !key.above) {
            maxY = 15.9f;
        }
        float minY = 0.0f;
        if (!key.below) {
            minY = 0.1f;
        }
        ArrayList<EnumFacing> openSides = new ArrayList<EnumFacing>();
        if (!key.renderTop) {
            openSides.add(EnumFacing.UP);
        }
        if (!key.renderBelow) {
            openSides.add(EnumFacing.DOWN);
        }
        return ModelFactory.createCubeOpen(new Vector3f(1.1f, minY, 1.1f), new Vector3f(14.9f, maxY, 14.9f), sprite, openSides);
    }

    public class Key {
        public Fluid fluid;
        public int amount;
        public boolean above;
        public boolean below;
        public boolean renderTop;
        public boolean renderBelow;

        public Key(Fluid fluid, int amount, boolean above, boolean below) {
            this(fluid, amount, above, below, true, true);
        }

        public Key(Fluid fluid, int amount, boolean above, boolean below, boolean renderTop, boolean renderBelow) {
            this.fluid = fluid;
            this.amount = amount;
            this.above = above;
            this.below = below;
            this.renderTop = renderTop;
            this.renderBelow = renderBelow;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return key.fluid == this.fluid && key.amount == this.amount && key.above == this.above && key.below == this.below && key.renderBelow == this.renderBelow && key.renderTop == this.renderTop;
        }

        public int hashCode() {
            return this.fluid.hashCode() + Integer.hashCode(this.amount) + Boolean.hashCode(this.above) + Boolean.hashCode(this.below);
        }
    }
}

