/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.models.drive;

import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

final class MatrixVertexTransformer
extends QuadGatheringTransformer {
    private final Matrix4f transform;

    public MatrixVertexTransformer(Matrix4f transform) {
        this.transform = transform;
    }

    protected void processQuad() {
        VertexFormat format = this.parent.getVertexFormat();
        int count = format.func_177345_h();
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < count; ++e) {
                VertexFormatElement element = format.func_177348_c(e);
                if (element.func_177375_c() == VertexFormatElement.EnumUsage.POSITION) {
                    this.parent.put(e, this.transform(this.quadData[e][v], element.func_177370_d()));
                    continue;
                }
                if (element.func_177375_c() == VertexFormatElement.EnumUsage.NORMAL) {
                    this.parent.put(e, this.transformNormal(this.quadData[e][v]));
                    continue;
                }
                this.parent.put(e, this.quadData[e][v]);
            }
        }
    }

    public void setQuadTint(int tint) {
        this.parent.setQuadTint(tint);
    }

    public void setQuadOrientation(EnumFacing orientation) {
        this.parent.setQuadOrientation(orientation);
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        this.parent.setApplyDiffuseLighting(diffuse);
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.parent.setTexture(texture);
    }

    private float[] transform(float[] fs, int elemCount) {
        switch (fs.length) {
            case 3: {
                Vector3f vec = new Vector3f(fs[0], fs[1], fs[2]);
                vec.x -= 0.5f;
                vec.y -= 0.5f;
                vec.z -= 0.5f;
                this.transform.transform(vec);
                vec.x += 0.5f;
                vec.y += 0.5f;
                vec.z += 0.5f;
                return new float[]{vec.x, vec.y, vec.z};
            }
            case 4: {
                Vector4f vecc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                if (elemCount == 3) {
                    vecc.w = 1.0f;
                }
                vecc.x -= 0.5f;
                vecc.y -= 0.5f;
                vecc.z -= 0.5f;
                this.transform.transform((Tuple4f)vecc);
                vecc.x += 0.5f;
                vecc.y += 0.5f;
                vecc.z += 0.5f;
                return new float[]{vecc.x, vecc.y, vecc.z, vecc.w};
            }
        }
        return fs;
    }

    private float[] transformNormal(float[] fs) {
        switch (fs.length) {
            case 3: {
                Vector4f normal = new Vector4f(fs[0], fs[1], fs[2], 0.0f);
                this.transform.transform((Tuple4f)normal);
                normal.normalize();
                return new float[]{normal.x, normal.y, normal.z};
            }
            case 4: {
                Vector4f normal = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                this.transform.transform((Tuple4f)normal);
                normal.normalize();
                return new float[]{normal.x, normal.y, normal.z, normal.w};
            }
        }
        return fs;
    }
}

