/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.IStorageChannel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.container.ContainerDrive;
import com.the9grounds.aeadditions.gui.GuiDrive;
import com.the9grounds.aeadditions.inventory.IInventoryListener;
import com.the9grounds.aeadditions.inventory.InventoryPartDrive;
import com.the9grounds.aeadditions.inventory.InventoryPlain;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.models.drive.DriveSlotsState;
import com.the9grounds.aeadditions.models.drive.IECDrive;
import com.the9grounds.aeadditions.part.PartECBase;
import com.the9grounds.aeadditions.util.AEUtils;
import com.the9grounds.aeadditions.util.PermissionUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;

public class PartDrive
extends PartECBase
implements ICellContainer,
IInventoryListener,
IECDrive {
    public static Queue<DriveSlotsState> tempDriveStates = new LinkedList<DriveSlotsState>();
    public static DimensionalCoord oldPos = null;
    private final byte[] cellStatuses = new byte[6];
    private final InventoryPartDrive inventory = new InventoryPartDrive(this){

        @Override
        protected void onContentsChanged() {
            PartDrive.this.saveData();
        }
    };
    private int priority = 0;
    private short[] blinkTimers;
    private HashMap<IStorageChannel, List<IMEInventoryHandler>> handlers = new HashMap();

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.onInventoryChanged();
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        if (!wrenched) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack cell = this.inventory.func_70301_a(i);
                if (cell == null) continue;
                drops.add(cell);
            }
        }
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiDrive(this, player);
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerDrive(this, player);
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, hand, pos);
        }
        return false;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.inventory.readFromNBT(data.func_150295_c("inventory", 10));
        this.onInventoryChanged();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        for (int i = 0; i < this.cellStatuses.length; ++i) {
            this.cellStatuses[i] = data.readByte();
        }
        return true;
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        for (byte aCellStati : this.cellStatuses) {
            data.writeByte((int)aCellStati);
        }
    }

    @Override
    public void setPartHostInfo(AEPartLocation location, IPartHost iPartHost, TileEntity tileEntity) {
        super.setPartHostInfo(location, iPartHost, tileEntity);
        this.onInventoryChanged();
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 2.0f;
    }

    public IPartModel getStaticModels() {
        DimensionalCoord currentPos = this.getLocation();
        if (currentPos == null || oldPos == null || !currentPos.isEqual(oldPos)) {
            tempDriveStates = new LinkedList<DriveSlotsState>();
            oldPos = currentPos;
        }
        tempDriveStates.add(DriveSlotsState.createState(this));
        if (this.isActive() && this.isPowered()) {
            return PartModels.DRIVE_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.DRIVE_ON;
        }
        return PartModels.DRIVE_OFF;
    }

    public int getPriority() {
        return this.priority;
    }

    public InventoryPlain getInventory() {
        return this.inventory;
    }

    @Override
    public void onInventoryChanged() {
        IMEInventoryHandler[] handlerSlots = new IMEInventoryHandler[this.cellStatuses.length];
        this.handlers = this.updateHandlers(handlerSlots);
        for (int i = 0; i < this.cellStatuses.length; ++i) {
            ItemStack stackInSlot = this.inventory.func_70301_a(i);
            IMEInventoryHandler inventoryHandler = handlerSlots[i];
            ICellHandler cellHandler = AEUtils.cell().getHandler(stackInSlot);
            this.cellStatuses[i] = cellHandler == null || inventoryHandler == null ? (byte)0 : (byte)cellHandler.getStatusForCell(stackInSlot, (ICellInventoryHandler)inventoryHandler);
        }
        IGridNode node = this.getGridNode();
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            this.getHost().markForUpdate();
        }
        this.saveData();
    }

    public void saveChanges(ICellInventory<?> cellInventory) {
        this.getHost().markForSave();
    }

    private HashMap<IStorageChannel, List<IMEInventoryHandler>> updateHandlers(IMEInventoryHandler[] handlerSlot) {
        HashMap<IStorageChannel, List<IMEInventoryHandler>> handlers = new HashMap<IStorageChannel, List<IMEInventoryHandler>>();
        for (IStorageChannel channel : AEApi.instance().storage().storageChannels()) {
            ArrayList<ICellInventoryHandler> handlerChannel = new ArrayList<ICellInventoryHandler>();
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ICellInventoryHandler cellInventory;
                ItemStack cell = this.inventory.func_70301_a(i);
                if (!AEUtils.cell().isCellHandled(cell) || (cellInventory = AEUtils.cell().getCellInventory(cell, null, channel)) == null) continue;
                handlerChannel.add(cellInventory);
                handlerSlot[i] = cellInventory;
            }
            handlers.put(channel, handlerChannel);
        }
        return handlers;
    }

    @Override
    public int getCellCount() {
        return 6;
    }

    @Override
    public int getCellStatus(int index) {
        return this.cellStatuses[index];
    }

    public void blinkCell(int slot) {
        if (slot > 0 && slot < this.blinkTimers.length) {
            this.blinkTimers[slot] = 15;
        }
    }

    public List<IMEInventoryHandler> getCellArray(IStorageChannel channel) {
        if (!this.isActive()) {
            return new ArrayList<IMEInventoryHandler>();
        }
        return this.handlers.containsKey(channel) ? this.handlers.get(channel) : new ArrayList<IMEInventoryHandler>();
    }

    @MENetworkEventSubscribe
    public void powerChange(MENetworkPowerStatusChange event) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
        node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged channel) {
        boolean isNowActive;
        IGridNode node = this.getGridNode();
        if (node != null && (isNowActive = node.isActive()) != this.isActive()) {
            this.setActive(isNowActive);
            this.onNeighborChanged();
            this.getHost().markForUpdate();
        }
        node.getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
    }
}

