/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.BusSupport;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.gridblock.ECBaseGridBlock;
import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.integration.mekanism.gas.Capabilities;
import com.the9grounds.aeadditions.network.GuiHandler;
import com.the9grounds.aeadditions.registries.ItemEnum;
import com.the9grounds.aeadditions.registries.PartEnum;
import com.the9grounds.aeadditions.util.MachineSource;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import mekanism.api.gas.IGasHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;

public abstract class PartECBase
implements IPart,
IGridHost,
IActionHost,
IPowerChannelState {
    @Nullable
    private IGridNode node;
    @Nullable
    private AEPartLocation side;
    @Nullable
    private IPartHost host;
    @Nullable
    private ECBaseGridBlock gridBlock;
    private double powerUsage;
    @Nullable
    private TileEntity hostTile;
    @Nullable
    private IFluidHandler facingTank;
    @Nullable
    private Object facingGasTank;
    private boolean redstonePowered;
    private boolean isActive;
    private boolean isPowerd = false;
    @Nullable
    private EntityPlayer owner;

    public void addToWorld() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        this.gridBlock = new ECBaseGridBlock(this);
        this.node = AEApi.instance().grid().createGridNode((IGridBlock)this.gridBlock);
        if (this.node != null) {
            if (this.owner != null) {
                this.node.setPlayerID(AEApi.instance().registries().players().getID(this.owner));
            }
            this.node.updateState();
        }
        this.setPower(null);
        this.onNeighborChanged();
    }

    public boolean canBePlacedOn(BusSupport what) {
        return what != BusSupport.DENSE_CABLE;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    protected final IAEGasStack extractGas(IAEGasStack toExtract, Actionable action) {
        if (this.gridBlock == null || this.facingGasTank == null) {
            return null;
        }
        IMEMonitor<IAEGasStack> monitor = this.gridBlock.getGasMonitor();
        if (monitor == null) {
            return null;
        }
        return (IAEGasStack)monitor.extractItems((IAEStack)toExtract, action, (IActionSource)new MachineSource(this));
    }

    protected final IAEGasStack injectGas(IAEGasStack toInject, Actionable action) {
        if (this.gridBlock == null || this.facingGasTank == null) {
            return toInject;
        }
        IMEMonitor<IAEGasStack> monitor = this.gridBlock.getGasMonitor();
        if (monitor == null) {
            return toInject;
        }
        return (IAEGasStack)monitor.injectItems((IAEStack)toInject, action, (IActionSource)new MachineSource(this));
    }

    public final IGridNode getActionableNode() {
        return this.node;
    }

    public abstract void getBoxes(IPartCollisionHelper var1);

    public AECableType getCableConnectionType(AEPartLocation aePartLocation) {
        return AECableType.GLASS;
    }

    public Object getClientGuiElement(EntityPlayer player) {
        return null;
    }

    public void getDrops(List<ItemStack> drops, boolean wrenched) {
    }

    public final IGridNode getExternalFacingNode() {
        return null;
    }

    public IFluidHandler getFacingTank() {
        return this.facingTank;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    public IGasHandler getFacingGasTank() {
        if (this.facingGasTank == null) {
            return null;
        }
        if (((TileEntity)this.facingGasTank).hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d())) {
            return (IGasHandler)((TileEntity)this.facingGasTank).getCapability(Capabilities.GAS_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d());
        }
        return null;
    }

    public ECBaseGridBlock getGridBlock() {
        return this.gridBlock;
    }

    public IGridNode getGridNode() {
        return this.node;
    }

    public IGridNode getGridNode(AEPartLocation aePartLocation) {
        return this.node;
    }

    public IPartHost getHost() {
        return this.host;
    }

    public TileEntity getHostTile() {
        return this.hostTile;
    }

    public ItemStack getItemStack(PartItemStack type) {
        ItemStack is = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID(this));
        if (type != PartItemStack.BREAK) {
            NBTTagCompound itemNbt = new NBTTagCompound();
            this.writeToNBT(itemNbt);
            if (itemNbt.func_74764_b("node")) {
                itemNbt.func_82580_o("node");
            }
            is.func_77982_d(itemNbt);
        }
        return is;
    }

    public int getLightLevel() {
        return this.isActive() ? 15 : 0;
    }

    @Nullable
    public final DimensionalCoord getLocation() {
        if (this.hostTile == null || this.hostTile.func_145831_w() == null || this.hostTile.func_145831_w().field_73011_w == null) {
            return null;
        }
        return new DimensionalCoord(this.hostTile.func_145831_w(), this.hostTile.func_174877_v());
    }

    public double getPowerUsage() {
        return this.powerUsage;
    }

    public Object getServerGuiElement(EntityPlayer player) {
        return null;
    }

    public EnumFacing getFacing() {
        return this.side != null ? this.side.getFacing() : null;
    }

    public AEPartLocation getSide() {
        return this.side;
    }

    public List<String> getWailaBodey(NBTTagCompound tag, List<String> oldList) {
        return oldList;
    }

    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        return tag;
    }

    public void initializePart(ItemStack partStack) {
        if (partStack.func_77942_o()) {
            this.readFromNBT(partStack.func_77978_p());
        }
    }

    public boolean isActive() {
        return this.node != null ? this.node.isActive() : this.isActive;
    }

    public boolean isLadder(EntityLivingBase entity) {
        return false;
    }

    public boolean isPowered() {
        return this.isPowerd;
    }

    public int isProvidingStrongPower() {
        return 0;
    }

    public int isProvidingWeakPower() {
        return 0;
    }

    protected boolean isRedstonePowered() {
        return this.redstonePowered;
    }

    public boolean isSolid() {
        return false;
    }

    public boolean onActivate(EntityPlayer player, EnumHand enumHand, Vec3d pos) {
        if (player != null && player instanceof EntityPlayerMP) {
            BlockPos hostPos = this.hostTile.func_174877_v();
            GuiHandler.launchGui(GuiHandler.getGuiId(this), player, this.hostTile.func_145831_w(), hostPos.func_177958_n(), hostPos.func_177956_o(), hostPos.func_177952_p());
        }
        return true;
    }

    public void onEntityCollision(Entity entity) {
    }

    public boolean isValid() {
        if (this.hostTile != null && this.hostTile.func_145830_o()) {
            DimensionalCoord loc = this.getLocation();
            TileEntity host = this.hostTile.func_145831_w().func_175625_s(loc.getPos());
            if (host instanceof IPartHost) {
                return ((IPartHost)host).getPart(this.side) == this;
            }
            return false;
        }
        return false;
    }

    protected void onNeighborChanged() {
        this.onNeighborChanged(null, null, null);
    }

    public void onNeighborChanged(IBlockAccess var1, BlockPos var2, BlockPos var3) {
        EnumFacing facing;
        if (this.hostTile == null) {
            return;
        }
        World world = this.hostTile.func_145831_w();
        if (world == null) {
            return;
        }
        BlockPos pos = this.hostTile.func_174877_v();
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing = this.side.getFacing()));
        if (tileEntity != null) {
            this.facingTank = tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) ? (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()) : null;
            if (Integration.Mods.MEKANISMGAS.isEnabled()) {
                this.updateCheckGasTank(tileEntity);
            }
        } else {
            this.facingTank = null;
            this.facingGasTank = null;
        }
        this.redstonePowered = world.func_175687_A(pos) > 0 || world.func_175687_A(pos.func_177984_a()) > 0;
    }

    @Optional.Method(modid="MekanismAPI|gas")
    private void updateCheckGasTank(TileEntity tile) {
        this.facingGasTank = tile.hasCapability(Capabilities.GAS_HANDLER_CAPABILITY, this.getSide().getFacing().func_176734_d()) ? tile : null;
    }

    public void onPlacement(EntityPlayer player, EnumHand enumHand, ItemStack itemStack, AEPartLocation aePartLocation) {
        this.owner = player;
    }

    public boolean onShiftActivate(EntityPlayer entityPlayer, EnumHand enumHand, Vec3d vec3d) {
        return false;
    }

    public void randomDisplayTick(World world, BlockPos blockPos, Random random) {
    }

    public void readFromNBT(NBTTagCompound data) {
        if (data.func_74764_b("node") && this.node != null) {
            this.node.loadFromNBT("node0", data.func_74775_l("node"));
            this.node.updateState();
        }
    }

    public boolean readFromStream(ByteBuf data) throws IOException {
        this.isActive = data.readBoolean();
        this.isPowerd = data.readBoolean();
        return true;
    }

    public void removeFromWorld() {
        if (this.node != null) {
            this.node.destroy();
        }
    }

    public boolean requireDynamicRender() {
        return false;
    }

    protected final void saveData() {
        if (this.host != null) {
            this.host.markForSave();
        }
    }

    public void securityBreak() {
        if (this.host != null) {
            this.host.removePart(this.side, false);
        }
    }

    protected void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public void setPartHostInfo(AEPartLocation location, IPartHost iPartHost, TileEntity tileEntity) {
        this.side = location;
        this.host = iPartHost;
        this.hostTile = tileEntity;
        this.setPower(null);
        if (this.host != null) {
            this.host.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void setPower(MENetworkPowerStatusChange notUsed) {
        if (this.node != null) {
            IEnergyGrid energy;
            this.isActive = this.node.isActive();
            IGrid grid = this.node.getGrid();
            if (grid != null && (energy = (IEnergyGrid)grid.getCache(IEnergyGrid.class)) != null) {
                this.isPowerd = energy.isNetworkPowered();
            }
        }
        if (this.host != null) {
            this.host.markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void setChannelChanged(MENetworkChannelsChanged channelChanged) {
        if (this.host != null) {
            this.host.markForUpdate();
        }
    }

    public void writeToNBT(NBTTagCompound data) {
        if (this.node != null) {
            NBTTagCompound nodeTag = new NBTTagCompound();
            this.node.saveToNBT("node0", nodeTag);
            data.func_74782_a("node", (NBTBase)nodeTag);
        }
    }

    public void writeToStream(ByteBuf data) throws IOException {
        data.writeBoolean(this.node != null && this.node.isActive());
        data.writeBoolean(this.isPowerd);
    }
}

