/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part.fluid;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageChannel;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.the9grounds.aeadditions.api.IFluidInterface;
import com.the9grounds.aeadditions.api.crafting.IFluidCraftingPatternDetails;
import com.the9grounds.aeadditions.container.IContainerListener;
import com.the9grounds.aeadditions.container.fluid.ContainerFluidInterface;
import com.the9grounds.aeadditions.crafting.CraftingPattern;
import com.the9grounds.aeadditions.crafting.CraftingPattern2;
import com.the9grounds.aeadditions.gui.gas.GuiFluidInterface;
import com.the9grounds.aeadditions.gui.widget.fluid.IFluidSlotListener;
import com.the9grounds.aeadditions.integration.Capabilities;
import com.the9grounds.aeadditions.inventory.FluidInterfaceInventory;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.part.PartECBase;
import com.the9grounds.aeadditions.registries.ItemEnum;
import com.the9grounds.aeadditions.registries.PartEnum;
import com.the9grounds.aeadditions.util.AEUtils;
import com.the9grounds.aeadditions.util.ItemHandlerUtil;
import com.the9grounds.aeadditions.util.ItemStackUtils;
import com.the9grounds.aeadditions.util.ItemUtils;
import com.the9grounds.aeadditions.util.MachineSource;
import com.the9grounds.aeadditions.util.PermissionUtil;
import com.the9grounds.aeadditions.util.StorageChannels;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PartFluidInterface
extends PartECBase
implements IFluidHandler,
IFluidInterface,
IFluidSlotListener,
IStorageMonitorable,
IGridTickable,
ICraftingProvider {
    private final List<IContainerListener> listeners = new ArrayList<IContainerListener>();
    private final List<ICraftingPatternDetails> patternHandlers = new ArrayList<ICraftingPatternDetails>();
    private final HashMap<ICraftingPatternDetails, IFluidCraftingPatternDetails> patternConvert = new HashMap();
    private final List<IAEStack> export = new ArrayList<IAEStack>();
    private final List<IAEStack> removeFromExport = new ArrayList<IAEStack>();
    private final List<IAEStack> addToExport = new ArrayList<IAEStack>();
    private final Item encodedPattern = AEApi.instance().definitions().items().encodedPattern().maybeItem().orElse(null);
    private final FluidTank tank = new FluidTank(10000){

        protected void onContentsChanged() {
            PartFluidInterface.this.saveData();
        }
    };
    public final FluidInterfaceInventory inventory = new FluidInterfaceInventory(this){

        @Override
        protected void onContentsChanged() {
            PartFluidInterface.this.saveData();
        }
    };
    private boolean update = false;
    private IAEItemStack toExport = null;
    private String fluidFilter = "";
    public boolean doNextUpdate = false;

    public void markForUpdate() {
        this.update = true;
    }

    public float getCableConnectionLength(AECableType aeCableType) {
        return 3.0f;
    }

    public boolean canDrain(Fluid fluid) {
        FluidStack tankFluid = this.tank.getFluid();
        return tankFluid != null && tankFluid.getFluid() == fluid;
    }

    public boolean canFill(Fluid fluid) {
        return this.tank.fill(new FluidStack(fluid, 1), false) > 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        FluidStack tankFluid = this.tank.getFluid();
        if (resource == null || tankFluid == null || tankFluid.getFluid() != resource.getFluid()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack drained = this.tank.drain(maxDrain, doDrain);
        if (drained != null) {
            this.getHost().markForUpdate();
        }
        this.doNextUpdate = true;
        return drained;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        if ((this.tank.getFluid() == null || this.tank.getFluid().getFluid() == resource.getFluid()) && resource.getFluid() == FluidRegistry.getFluid((String)this.fluidFilter)) {
            int added = this.tank.fill(resource.copy(), doFill);
            if (added == resource.amount) {
                this.doNextUpdate = true;
                return added;
            }
            added += this.fillToNetwork(new FluidStack(resource.getFluid(), resource.amount - added), doFill);
            this.doNextUpdate = true;
            return added;
        }
        int filled = 0;
        if ((filled += this.fillToNetwork(resource, doFill)) < resource.amount) {
            filled += this.tank.fill(new FluidStack(resource.getFluid(), resource.amount - filled), doFill);
        }
        if (filled > 0) {
            this.getHost().markForUpdate();
        }
        this.doNextUpdate = true;
        return filled;
    }

    public int fillToNetwork(FluidStack resource, boolean doFill) {
        IGridNode node = this.getGridNode(AEPartLocation.INTERNAL);
        if (node == null || resource == null) {
            return 0;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return 0;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return 0;
        }
        FluidStack copy = resource.copy();
        IAEFluidStack notRemoved = doFill ? (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).injectItems((IAEStack)AEUtils.createFluidStack(resource), Actionable.MODULATE, (IActionSource)new MachineSource(this)) : (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).injectItems((IAEStack)AEUtils.createFluidStack(resource), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
        if (notRemoved == null) {
            return resource.amount;
        }
        return (int)((long)resource.amount - notRemoved.getStackSize());
    }

    private void forceUpdate() {
        this.getHost().markForUpdate();
        for (IContainerListener listener : this.listeners) {
            if (listener == null) continue;
            listener.updateContainer();
        }
        this.doNextUpdate = false;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiFluidInterface(player, this, this.getSide());
    }

    @SideOnly(value=Side.CLIENT)
    private World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack pattern = this.inventory.func_70301_a(i);
            if (pattern == null) continue;
            drops.add(pattern);
        }
    }

    @Override
    public Fluid getFilter(AEPartLocation location) {
        return FluidRegistry.getFluid((String)this.fluidFilter);
    }

    public <T extends IAEStack<T>> IMEMonitor<T> getInventory(IStorageChannel<T> channel) {
        if (this.getGridNode(AEPartLocation.INTERNAL) == null) {
            return null;
        }
        IGrid grid = this.getGridNode(AEPartLocation.INTERNAL).getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getInventory(channel);
    }

    @Override
    public IFluidTank getFluidTank(AEPartLocation location) {
        return this.tank;
    }

    @Override
    public ItemStack getItemStack(PartItemStack type) {
        ItemStack is = new ItemStack(ItemEnum.PARTITEM.getItem(), 1, PartEnum.getPartID(this));
        if (type != PartItemStack.BREAK) {
            is.func_77982_d(this.writeFilter(new NBTTagCompound()));
        }
        return is;
    }

    @Override
    public IInventory getPatternInventory() {
        return this.inventory;
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerFluidInterface(player, this);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(1, 40, false, false);
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound tag, List<String> list) {
        Fluid fluid;
        FluidStack fluidStack = null;
        String name = "";
        int amount = 0;
        if (tag.func_74764_b("fluidName") && tag.func_74764_b("amount")) {
            name = tag.func_74779_i("fluidName");
            amount = tag.func_74762_e("amount");
        }
        if (!name.isEmpty() && (fluid = FluidRegistry.getFluid((String)name)) != null) {
            fluidStack = new FluidStack(FluidRegistry.getFluid((String)name), amount);
        }
        if (fluidStack == null) {
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.fluid") + ": " + I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.empty1"));
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.amount") + ": 0mB / 10000mB");
        } else {
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.fluid") + ": " + fluidStack.getLocalizedName());
            list.add(I18n.func_74838_a((String)"com.the9grounds.aeadditions.tooltip.amount") + ": " + fluidStack.amount + "mB / 10000mB");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        if (this.tank.getFluid() == null || this.tank.getFluid().getFluid() == null) {
            tag.func_74778_a("fluidName", "");
        } else {
            tag.func_74778_a("fluidName", this.tank.getFluid().getFluid().getName());
        }
        tag.func_74768_a("amount", this.tank.getFluidAmount());
        return tag;
    }

    @Override
    public void initializePart(ItemStack partStack) {
        if (partStack.func_77942_o()) {
            this.readFilter(partStack.func_77978_p());
        }
    }

    public boolean isBusy() {
        return !this.export.isEmpty();
    }

    private ItemStack makeCraftingPatternItem(ICraftingPatternDetails details) {
        if (details == null) {
            return null;
        }
        NBTTagList in = new NBTTagList();
        NBTTagList out = new NBTTagList();
        for (IAEItemStack s : details.getInputs()) {
            if (s == null) {
                in.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            in.func_74742_a((NBTBase)s.createItemStack().func_77955_b(new NBTTagCompound()));
        }
        for (IAEItemStack s : details.getOutputs()) {
            if (s == null) {
                out.func_74742_a((NBTBase)new NBTTagCompound());
                continue;
            }
            out.func_74742_a((NBTBase)s.createItemStack().func_77955_b(new NBTTagCompound()));
        }
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("in", (NBTBase)in);
        itemTag.func_74782_a("out", (NBTBase)out);
        itemTag.func_74757_a("crafting", details.isCraftable());
        ItemStack pattern = new ItemStack(this.encodedPattern);
        pattern.func_77982_d(itemTag);
        return pattern;
    }

    @Override
    public boolean onActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this)) {
            return super.onActivate(player, hand, pos);
        }
        return false;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        this.patternConvert.clear();
        for (ItemStack currentPatternStack : this.inventory.getInv()) {
            ICraftingPatternDetails p;
            ICraftingPatternItem currentPattern;
            if (ItemStackUtils.isEmpty(currentPatternStack) || currentPatternStack.func_77973_b() == null || !(currentPatternStack.func_77973_b() instanceof ICraftingPatternItem) || (currentPattern = (ICraftingPatternItem)currentPatternStack.func_77973_b()) == null || currentPattern.getPatternForItem(currentPatternStack, this.getGridNode().getWorld()) == null) continue;
            CraftingPattern2 pattern = new CraftingPattern2(currentPattern.getPatternForItem(currentPatternStack, this.getGridNode().getWorld()));
            this.patternHandlers.add(pattern);
            ItemStack is = this.makeCraftingPatternItem(pattern);
            if (ItemStackUtils.isEmpty(is) || (p = ((ICraftingPatternItem)is.func_77973_b()).getPatternForItem(is, this.getGridNode().getWorld())) == null) continue;
            this.patternConvert.put(p, pattern);
            craftingTracker.addCraftingOption((ICraftingMedium)this, p);
        }
    }

    private void pushItems() {
        for (IAEStack s : this.removeFromExport) {
            this.export.remove(s);
        }
        this.removeFromExport.clear();
        for (IAEStack s : this.addToExport) {
            this.export.add(s);
        }
        this.addToExport.clear();
        if (this.getGridNode().getWorld() == null || this.export.isEmpty()) {
            return;
        }
        EnumFacing facing = this.getFacing();
        BlockPos pos = this.getGridNode().getGridBlock().getLocation().getPos();
        TileEntity tile = this.getGridNode().getWorld().func_175625_s(pos.func_177972_a(facing));
        if (tile != null) {
            IAEStack exportStack = this.export.iterator().next();
            IAEStack stack = exportStack.copy();
            if (stack instanceof IAEItemStack) {
                if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                    ItemStack itemStack;
                    IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    if (ItemHandlerUtil.insertItemStack(itemHandler, itemStack = ((IAEItemStack)stack).createItemStack(), false).func_190926_b()) {
                        ItemHandlerUtil.insertItemStack(itemHandler, itemStack, true);
                        this.removeFromExport.add(exportStack);
                    }
                } else if (tile instanceof IInventory) {
                    if (tile instanceof ISidedInventory) {
                        ISidedInventory inv = (ISidedInventory)tile;
                        for (int i : inv.func_180463_a(facing.func_176734_d())) {
                            if (!inv.func_180462_a(i, ((IAEItemStack)stack).createItemStack(), facing.func_176734_d())) continue;
                            if (inv.func_70301_a(i).func_190926_b()) {
                                inv.func_70299_a(i, ((IAEItemStack)stack).createItemStack());
                                this.removeFromExport.add(exportStack);
                                return;
                            }
                            if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), ((IAEItemStack)stack).createItemStack())) continue;
                            int max = inv.func_70297_j_();
                            int current = inv.func_70301_a(i).func_190916_E();
                            int outStack = (int)stack.getStackSize();
                            if (max == current) continue;
                            if (current + outStack <= max) {
                                ItemStack s = inv.func_70301_a(i).func_77946_l();
                                s.func_190920_e(s.func_190916_E() + outStack);
                                inv.func_70299_a(i, s);
                                this.removeFromExport.add(exportStack);
                                return;
                            }
                            ItemStack s = inv.func_70301_a(i).func_77946_l();
                            s.func_190920_e(max);
                            inv.func_70299_a(i, s);
                            this.removeFromExport.add(exportStack);
                            stack.setStackSize((long)(outStack - max + current));
                            this.addToExport.add(stack);
                            return;
                        }
                    } else {
                        IInventory inv = (IInventory)tile;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            if (!inv.func_94041_b(i, ((IAEItemStack)stack).createItemStack())) continue;
                            if (inv.func_70301_a(i).func_190926_b()) {
                                inv.func_70299_a(i, ((IAEItemStack)stack).createItemStack());
                                this.removeFromExport.add(exportStack);
                                return;
                            }
                            if (!ItemUtils.areItemEqualsIgnoreStackSize(inv.func_70301_a(i), ((IAEItemStack)stack).createItemStack())) continue;
                            int max = inv.func_70297_j_();
                            int current = inv.func_70301_a(i).func_190916_E();
                            int outStack = (int)stack.getStackSize();
                            if (max == current) continue;
                            if (current + outStack <= max) {
                                ItemStack s = inv.func_70301_a(i).func_77946_l();
                                s.func_190920_e(s.func_190916_E() + outStack);
                                inv.func_70299_a(i, s);
                                this.removeFromExport.add(exportStack);
                                return;
                            }
                            ItemStack s = inv.func_70301_a(i).func_77946_l();
                            s.func_190920_e(max);
                            inv.func_70299_a(i, s);
                            this.removeFromExport.add(exportStack);
                            stack.setStackSize((long)(outStack - max + current));
                            this.addToExport.add(stack);
                            return;
                        }
                    }
                }
            } else if (stack instanceof IAEFluidStack && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d())) {
                IAEFluidStack fluid;
                IFluidHandler handler = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
                int amount = handler.fill((fluid = (IAEFluidStack)stack).getFluidStack().copy(), false);
                if (amount == 0) {
                    return;
                }
                if ((long)amount == fluid.getStackSize()) {
                    handler.fill(fluid.getFluidStack().copy(), true);
                    this.removeFromExport.add(exportStack);
                } else {
                    IAEFluidStack f = fluid.copy();
                    f.setStackSize(f.getStackSize() - (long)amount);
                    FluidStack fl = fluid.getFluidStack().copy();
                    fl.amount = amount;
                    handler.fill(fl, true);
                    this.removeFromExport.add(exportStack);
                    this.addToExport.add((IAEStack)f);
                    return;
                }
            }
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patDetails, InventoryCrafting table) {
        if (this.isBusy() || !this.patternConvert.containsKey(patDetails)) {
            return false;
        }
        ICraftingPatternDetails patternDetails = this.patternConvert.get(patDetails);
        if (patternDetails instanceof CraftingPattern) {
            IAEFluidStack extractFluid;
            Long amount;
            CraftingPattern patter = (CraftingPattern)patternDetails;
            HashMap<Fluid, Long> fluids = new HashMap<Fluid, Long>();
            for (IAEFluidStack stack : patter.getCondensedFluidInputs()) {
                if (fluids.containsKey(stack.getFluid())) {
                    amount = (Long)fluids.get(stack.getFluid()) + stack.getStackSize();
                    fluids.remove(stack.getFluid());
                    fluids.put(stack.getFluid(), amount);
                    continue;
                }
                fluids.put(stack.getFluid(), stack.getStackSize());
            }
            IGrid grid = this.getGridNode().getGrid();
            if (grid == null) {
                return false;
            }
            IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
            if (storage == null) {
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).extractItems((IAEStack)AEUtils.createFluidStack(fluid, (long)((int)(amount + 0L))), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
                if (extractFluid != null && extractFluid.getStackSize() == amount.longValue()) continue;
                return false;
            }
            for (Fluid fluid : fluids.keySet()) {
                amount = (Long)fluids.get(fluid);
                extractFluid = (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).extractItems((IAEStack)AEUtils.createFluidStack(fluid, (long)((int)(amount + 0L))), Actionable.MODULATE, (IActionSource)new MachineSource(this));
                this.export.add((IAEStack)extractFluid);
            }
            for (IAEItemStack fluidStack : patter.getCondensedInputs()) {
                if (fluidStack == null) continue;
                if (fluidStack.getItem() == ItemEnum.FLUIDPATTERN.getItem()) {
                    this.toExport = fluidStack.copy();
                    continue;
                }
                this.export.add((IAEStack)fluidStack);
            }
        }
        return true;
    }

    public void readFilter(NBTTagCompound tag) {
        if (tag.func_74764_b("filter")) {
            this.fluidFilter = tag.func_74779_i("filter");
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("tank")) {
            this.tank.readFromNBT(data.func_74775_l("tank"));
        }
        if (data.func_74764_b("filter")) {
            this.fluidFilter = data.func_74779_i("filter");
        }
        if (data.func_74764_b("inventory")) {
            this.inventory.readFromNBT(data.func_74775_l("inventory"));
        }
        if (data.func_74764_b("export")) {
            this.readOutputFromNBT(data.func_74775_l("export"));
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)data);
        if (tag.func_74764_b("tank")) {
            this.tank.readFromNBT(tag.func_74775_l("tank"));
        }
        if (tag.func_74764_b("filter")) {
            this.fluidFilter = tag.func_74779_i("filter");
        }
        if (tag.func_74764_b("inventory")) {
            this.inventory.readFromNBT(tag.func_74775_l("inventory"));
        }
        return true;
    }

    private void readOutputFromNBT(NBTTagCompound tag) {
        IAEFluidStack s;
        int j;
        this.addToExport.clear();
        this.removeFromExport.clear();
        this.export.clear();
        int i = tag.func_74762_e("remove");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("remove-" + j + "-isItem")) {
                s = AEUtils.createItemStack(new ItemStack(tag.func_74775_l("remove-" + j)));
                s.setStackSize(tag.func_74763_f("remove-" + j + "-amount"));
                this.removeFromExport.add((IAEStack)s);
                continue;
            }
            s = AEUtils.createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("remove-" + j)));
            s.setStackSize(tag.func_74763_f("remove-" + j + "-amount"));
            this.removeFromExport.add((IAEStack)s);
        }
        i = tag.func_74762_e("add");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("add-" + j + "-isItem")) {
                s = AEUtils.createItemStack(new ItemStack(tag.func_74775_l("add-" + j)));
                s.setStackSize(tag.func_74763_f("add-" + j + "-amount"));
                this.addToExport.add((IAEStack)s);
                continue;
            }
            s = AEUtils.createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("add-" + j)));
            s.setStackSize(tag.func_74763_f("add-" + j + "-amount"));
            this.addToExport.add((IAEStack)s);
        }
        i = tag.func_74762_e("export");
        for (j = 0; j < i; ++j) {
            if (tag.func_74767_n("export-" + j + "-isItem")) {
                s = AEUtils.createItemStack(new ItemStack(tag.func_74775_l("export-" + j)));
                s.setStackSize(tag.func_74763_f("export-" + j + "-amount"));
                this.export.add((IAEStack)s);
                continue;
            }
            s = AEUtils.createFluidStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag.func_74775_l("export-" + j)));
            s.setStackSize(tag.func_74763_f("export-" + j + "-amount"));
            this.export.add((IAEStack)s);
        }
    }

    public void registerListener(IContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IContainerListener listener) {
        this.listeners.remove(listener);
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return PartModels.STORAGE_INTERFACE_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return PartModels.STORAGE_INTERFACE_ON;
        }
        return PartModels.STORAGE_INTERFACE_OFF;
    }

    @Override
    public void setFilter(AEPartLocation side, Fluid fluid) {
        if (fluid == null) {
            this.fluidFilter = "";
            this.doNextUpdate = true;
            return;
        }
        this.fluidFilter = fluid.getName();
        this.doNextUpdate = true;
    }

    @Override
    public void setFluid(int index, Fluid fluid, EntityPlayer player) {
        this.setFilter(AEPartLocation.fromOrdinal((int)index), fluid);
    }

    @Override
    public void setFluidTank(AEPartLocation side, FluidStack fluid) {
        this.tank.setFluid(fluid);
        this.doNextUpdate = true;
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        FluidStack drainedFluid;
        IGrid grid;
        if (this.doNextUpdate) {
            this.forceUpdate();
        }
        if ((grid = node.getGrid()) == null) {
            return TickRateModulation.URGENT;
        }
        IStorageGrid storage = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storage == null) {
            return TickRateModulation.URGENT;
        }
        this.pushItems();
        if (this.toExport != null) {
            storage.getInventory((IStorageChannel)StorageChannels.ITEM).injectItems((IAEStack)this.toExport, Actionable.MODULATE, (IActionSource)new MachineSource(this));
            this.toExport = null;
        }
        if (this.update) {
            this.update = false;
            IGridNode ownGridNode = this.getGridNode();
            if (ownGridNode != null && ownGridNode.getGrid() != null) {
                ownGridNode.getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, ownGridNode));
            }
        }
        if (this.tank.getFluid() != null && FluidRegistry.getFluid((String)this.fluidFilter) != this.tank.getFluid().getFluid() && (drainedFluid = this.tank.drain(125, false)) != null) {
            IAEFluidStack notAdded = (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).injectItems(StorageChannels.FLUID.createStack((Object)drainedFluid.copy()), Actionable.MODULATE, (IActionSource)new MachineSource(this));
            int leftOver = 0;
            if (notAdded != null) {
                leftOver = (int)notAdded.getStackSize();
            }
            this.tank.drain(drainedFluid.amount - leftOver, true);
            this.doNextUpdate = true;
        }
        if ((this.tank.getFluid() == null || this.tank.getFluid().getFluid() == FluidRegistry.getFluid((String)this.fluidFilter)) && FluidRegistry.getFluid((String)this.fluidFilter) != null) {
            IAEFluidStack extracted = (IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).extractItems((IAEStack)AEUtils.createFluidStack(new FluidStack(FluidRegistry.getFluid((String)this.fluidFilter), 125)), Actionable.SIMULATE, (IActionSource)new MachineSource(this));
            if (extracted == null) {
                return TickRateModulation.URGENT;
            }
            int accepted = this.tank.fill(extracted.getFluidStack(), false);
            if (accepted == 0) {
                return TickRateModulation.URGENT;
            }
            this.tank.fill(((IAEFluidStack)storage.getInventory((IStorageChannel)StorageChannels.FLUID).extractItems((IAEStack)AEUtils.createFluidStack(FluidRegistry.getFluid((String)this.fluidFilter), (long)accepted), Actionable.MODULATE, (IActionSource)new MachineSource(this))).getFluidStack(), true);
            this.doNextUpdate = true;
        }
        return TickRateModulation.URGENT;
    }

    public NBTTagCompound writeFilter(NBTTagCompound tag) {
        if (FluidRegistry.getFluid((String)this.fluidFilter) == null) {
            return null;
        }
        tag.func_74778_a("filter", this.fluidFilter);
        return tag;
    }

    private NBTTagCompound writeOutputToNBT(NBTTagCompound tag) {
        NBTTagCompound data;
        int i = 0;
        for (IAEStack s : this.removeFromExport) {
            if (s != null) {
                tag.func_74757_a("remove-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).createItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("remove-" + i, (NBTBase)data);
                tag.func_74772_a("remove-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("remove", this.removeFromExport.size());
        i = 0;
        for (IAEStack s : this.addToExport) {
            if (s != null) {
                tag.func_74757_a("add-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).createItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("add-" + i, (NBTBase)data);
                tag.func_74772_a("add-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("add", this.addToExport.size());
        i = 0;
        for (IAEStack s : this.export) {
            if (s != null) {
                tag.func_74757_a("export-" + i + "-isItem", s.isItem());
                data = new NBTTagCompound();
                if (s.isItem()) {
                    ((IAEItemStack)s).createItemStack().func_77955_b(data);
                } else {
                    ((IAEFluidStack)s).getFluidStack().writeToNBT(data);
                }
                tag.func_74782_a("export-" + i, (NBTBase)data);
                tag.func_74772_a("export-" + i + "-amount", s.getStackSize());
            }
            ++i;
        }
        tag.func_74768_a("export", this.export.size());
        return tag;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        this.writeToNBTWithoutExport(data);
        NBTTagCompound tag = new NBTTagCompound();
        this.writeOutputToNBT(tag);
        data.func_74782_a("export", (NBTBase)tag);
    }

    public void writeToNBTWithoutExport(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        data.func_74778_a("filter", this.fluidFilter);
        NBTTagCompound inventory2 = new NBTTagCompound();
        this.inventory.writeToNBT(inventory2);
        data.func_74782_a("inventory", (NBTBase)inventory2);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tank", (NBTBase)this.tank.writeToNBT(new NBTTagCompound()));
        tag.func_74778_a("filter", this.fluidFilter);
        NBTTagCompound inventory2 = new NBTTagCompound();
        this.inventory.writeToNBT(inventory2);
        tag.func_74782_a("inventory", (NBTBase)inventory2);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)tag);
    }

    public <T> T getCapability(Capability<T> capability) {
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR) {
            return (T)Capabilities.STORAGE_MONITORABLE_ACCESSOR.cast(m -> this);
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability);
    }

    public boolean hasCapability(Capability<?> capability) {
        return capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public World getWorld() {
        IGridNode node = this.getGridNode();
        if (node == null) {
            return this.getClientWorld();
        }
        return node.getWorld();
    }
}

