/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.part.gas;

import appeng.api.config.Actionable;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartModel;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.util.AECableType;
import com.the9grounds.aeadditions.api.gas.IAEGasStack;
import com.the9grounds.aeadditions.api.gas.IGasStorageChannel;
import com.the9grounds.aeadditions.container.ContainerTerminal;
import com.the9grounds.aeadditions.container.StorageType;
import com.the9grounds.aeadditions.gridblock.ECBaseGridBlock;
import com.the9grounds.aeadditions.gui.GuiTerminal;
import com.the9grounds.aeadditions.integration.Integration;
import com.the9grounds.aeadditions.inventory.IInventoryListener;
import com.the9grounds.aeadditions.inventory.InventoryPlain;
import com.the9grounds.aeadditions.models.PartModels;
import com.the9grounds.aeadditions.network.packet.part.PacketTerminalSelectFluidClient;
import com.the9grounds.aeadditions.part.PartECBase;
import com.the9grounds.aeadditions.util.GasUtil;
import com.the9grounds.aeadditions.util.MachineSource;
import com.the9grounds.aeadditions.util.NetworkUtil;
import com.the9grounds.aeadditions.util.PermissionUtil;
import com.the9grounds.aeadditions.util.StorageChannels;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.MutablePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010$\u001a\u00020!J\u0006\u0010%\u001a\u00020!J\b\u0010&\u001a\u00020!H\u0007J\u0010\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010)J\u0010\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,H\u0016J\u0012\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0014\u00101\u001a\u0004\u0018\u00010\u00072\b\u00102\u001a\u0004\u0018\u000103H\u0016J \u00104\u001a\u00020!2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0\u00062\u0006\u00106\u001a\u00020\u0010H\u0016J\u0012\u00107\u001a\u0004\u0018\u00010)2\u0006\u00108\u001a\u000209H\u0016J\b\u0010:\u001a\u00020;H\u0016J\u0014\u0010<\u001a\u0004\u0018\u00010\u00072\b\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u0010=\u001a\u00020>H\u0017J\u0010\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BH\u0016J\u0018\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020E2\b\u0010(\u001a\u0004\u0018\u00010)J&\u0010F\u001a\u00020\u00102\b\u00102\u001a\u0004\u0018\u0001032\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J\b\u0010K\u001a\u00020!H\u0016J\u0010\u0010L\u001a\u00020!2\u0006\u0010M\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010P\u001a\u00020!J\u0010\u0010P\u001a\u00020!2\b\u0010Q\u001a\u0004\u0018\u00010\u0007J\u0018\u0010R\u001a\u00020S2\u0006\u0010A\u001a\u00020B2\u0006\u0010T\u001a\u00020EH\u0016J\u0010\u0010U\u001a\u00020!2\u0006\u0010M\u001a\u00020NH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006V"}, d2={"Lcom/the9grounds/aeadditions/part/gas/PartGasTerminal;", "Lcom/the9grounds/aeadditions/part/PartECBase;", "Lappeng/api/networking/ticking/IGridTickable;", "Lcom/the9grounds/aeadditions/inventory/IInventoryListener;", "()V", "containers", "", "", "value", "Lnet/minecraftforge/fluids/Fluid;", "currentFluid", "getCurrentFluid", "()Lnet/minecraftforge/fluids/Fluid;", "setCurrentFluid", "(Lnet/minecraftforge/fluids/Fluid;)V", "doNextFill", "", "getDoNextFill", "()Z", "setDoNextFill", "(Z)V", "inventory", "Lcom/the9grounds/aeadditions/inventory/InventoryPlain;", "getInventory", "()Lcom/the9grounds/aeadditions/inventory/InventoryPlain;", "isMekanismLoaded", "machineSource", "Lcom/the9grounds/aeadditions/util/MachineSource;", "getMachineSource", "()Lcom/the9grounds/aeadditions/util/MachineSource;", "setMachineSource", "(Lcom/the9grounds/aeadditions/util/MachineSource;)V", "addContainer", "", "containerTerminalFluid", "Lcom/the9grounds/aeadditions/container/ContainerTerminal;", "decreaseFirstSlot", "doWork", "doWorkGas", "fillSecondSlot", "itemStack", "Lnet/minecraft/item/ItemStack;", "getBoxes", "bch", "Lappeng/api/parts/IPartCollisionHelper;", "getCableConnectionLength", "", "aeCableType", "Lappeng/api/util/AECableType;", "getClientGuiElement", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "getDrops", "drops", "wrenched", "getItemStack", "type", "Lappeng/api/parts/PartItemStack;", "getPowerUsage", "", "getServerGuiElement", "getStaticModels", "Lappeng/api/parts/IPartModel;", "getTickingRequest", "Lappeng/api/networking/ticking/TickingRequest;", "node", "Lappeng/api/networking/IGridNode;", "isItemValidForInputSlot", "i", "", "onActivate", "hand", "Lnet/minecraft/util/EnumHand;", "pos", "Lnet/minecraft/util/math/Vec3d;", "onInventoryChanged", "readFromNBT", "data", "Lnet/minecraft/nbt/NBTTagCompound;", "removeContainer", "sendCurrentFluid", "container", "tickingRequest", "Lappeng/api/networking/ticking/TickRateModulation;", "ticksSinceLastCall", "writeToNBT", "AEAdditions-1.12.2"})
public final class PartGasTerminal
extends PartECBase
implements IGridTickable,
IInventoryListener {
    private final List<Object> containers;
    @NotNull
    private final InventoryPlain inventory;
    @Nullable
    private Fluid currentFluid;
    @NotNull
    private MachineSource machineSource;
    private final boolean isMekanismLoaded;
    private boolean doNextFill;

    @NotNull
    public final InventoryPlain getInventory() {
        return this.inventory;
    }

    @Nullable
    public final Fluid getCurrentFluid() {
        return this.currentFluid;
    }

    public final void setCurrentFluid(@Nullable Fluid value) {
        this.currentFluid = value;
        this.sendCurrentFluid();
    }

    @NotNull
    protected final MachineSource getMachineSource() {
        return this.machineSource;
    }

    protected final void setMachineSource(@NotNull MachineSource machineSource) {
        Intrinsics.checkParameterIsNotNull((Object)machineSource, (String)"<set-?>");
        this.machineSource = machineSource;
    }

    @Override
    public void getDrops(@NotNull List<ItemStack> drops, boolean wrenched) {
        Intrinsics.checkParameterIsNotNull(drops, (String)"drops");
        for (ItemStack stack : this.inventory.slots) {
            if (stack == null) continue;
            drops.add(stack);
        }
    }

    public final boolean fillSecondSlot(@Nullable ItemStack itemStack) {
        boolean bl;
        if (itemStack == null) {
            return false;
        }
        ItemStack itemStack2 = this.inventory.func_70301_a(1);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack2, (String)"inventory.getStackInSlot(1)");
        ItemStack secondSlot = itemStack2;
        if (secondSlot == null || secondSlot.func_190926_b()) {
            this.inventory.func_70299_a(1, itemStack);
            bl = true;
        } else {
            if (!secondSlot.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)secondSlot)) {
                return false;
            }
            this.inventory.incrStackSize(1, itemStack.func_190916_E());
            bl = true;
        }
        return bl;
    }

    @Override
    public void getBoxes(@NotNull IPartCollisionHelper bch) {
        Intrinsics.checkParameterIsNotNull((Object)bch, (String)"bch");
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    @Override
    public double getPowerUsage() {
        return 0.5;
    }

    @NotNull
    public TickingRequest getTickingRequest(@NotNull IGridNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return new TickingRequest(1, 20, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean onActivate(@Nullable EntityPlayer player, @Nullable EnumHand hand, @Nullable Vec3d pos) {
        if (!this.isActive()) return false;
        PartGasTerminal partGasTerminal = this;
        if (partGasTerminal == null) {
            throw new TypeCastException("null cannot be cast to non-null type appeng.api.parts.IPart");
        }
        if (!PermissionUtil.hasPermission(player, SecurityPermissions.INJECT, partGasTerminal)) {
            if (!PermissionUtil.hasPermission(player, SecurityPermissions.EXTRACT, this)) return false;
        }
        boolean bl = super.onActivate(player, hand, pos);
        return bl;
    }

    @Override
    public void onInventoryChanged() {
        this.saveData();
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.readFromNBT(data);
        this.inventory.readFromNBT(data.func_150295_c("inventory", 10));
    }

    public final void removeContainer(@Nullable ContainerTerminal containerTerminalFluid) {
        if (containerTerminalFluid != null) {
            this.containers.remove(containerTerminalFluid);
        }
    }

    public final void addContainer(@Nullable ContainerTerminal containerTerminalFluid) {
        if (containerTerminalFluid != null) {
            this.containers.add(containerTerminalFluid);
            this.sendCurrentFluid();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public IPartModel getStaticModels() {
        return this.isActive() ? (IPartModel)PartModels.TERMINAL_HAS_CHANNEL : (IPartModel)(this.isPowered() ? PartModels.TERMINAL_ON : PartModels.TERMINAL_OFF);
    }

    public final void sendCurrentFluid() {
        for (Object containerFluidTerminal : this.containers) {
            this.sendCurrentFluid(containerFluidTerminal);
        }
    }

    public final void sendCurrentFluid(@Nullable Object container) {
        if (container instanceof ContainerTerminal) {
            NetworkUtil.sendToPlayer(new PacketTerminalSelectFluidClient(this.currentFluid), ((ContainerTerminal)container).getPlayer());
        }
    }

    @NotNull
    public TickRateModulation tickingRequest(@NotNull IGridNode node, int ticksSinceLastCall) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.doWork();
        return TickRateModulation.FASTER;
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        super.writeToNBT(data);
        data.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
    }

    public float getCableConnectionLength(@Nullable AECableType aeCableType) {
        return 1.0f;
    }

    public final void decreaseFirstSlot() {
        ItemStack itemStack = this.inventory.func_70301_a(0);
        Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"inventory.getStackInSlot(0)");
        ItemStack slot = itemStack;
        slot.func_190920_e(slot.func_190916_E() - 1);
        if (slot.func_190916_E() <= 0) {
            this.inventory.func_70299_a(0, ItemStack.field_190927_a);
        }
    }

    @Override
    @Nullable
    public ItemStack getItemStack(@NotNull PartItemStack type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        ItemStack stack = super.getItemStack(type);
        if (type == PartItemStack.WRENCH) {
            ItemStack itemStack = stack;
            Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"stack");
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            if (nBTTagCompound == null) {
                Intrinsics.throwNpe();
            }
            nBTTagCompound.func_82580_o("inventory");
        }
        return stack;
    }

    public final boolean isMekanismLoaded() {
        return this.isMekanismLoaded;
    }

    public final boolean getDoNextFill() {
        return this.doNextFill;
    }

    public final void setDoNextFill(boolean bl) {
        this.doNextFill = bl;
    }

    public final boolean isItemValidForInputSlot(int i, @Nullable ItemStack itemStack) {
        return GasUtil.isGasContainer(itemStack);
    }

    public final void doWork() {
        if (this.isMekanismLoaded) {
            this.doWorkGas();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Optional.Method(modid="MekanismAPI|gas")
    public final void doWorkGas() {
        IAEGasStack notInjected;
        IMEMonitor<IAEGasStack> monitor;
        ItemStack container;
        block20: {
            int n;
            int n2;
            GasStack gasStack;
            block19: {
                ItemStack secondSlot = this.inventory.func_70301_a(1);
                if (secondSlot != null && !secondSlot.func_190926_b() && secondSlot.func_190916_E() >= secondSlot.func_77976_d()) {
                    return;
                }
                container = this.inventory.func_70301_a(0);
                if (container == null || container.func_190926_b()) {
                    this.doNextFill = false;
                }
                if (!GasUtil.isGasContainer(container)) return;
                if (container == null) {
                    return;
                }
                ItemStack itemStack = container = container.func_77946_l();
                Intrinsics.checkExpressionValueIsNotNull((Object)itemStack, (String)"container");
                itemStack.func_190920_e(1);
                ECBaseGridBlock eCBaseGridBlock = this.getGridBlock();
                if (eCBaseGridBlock == null) return;
                ECBaseGridBlock gridBlock = eCBaseGridBlock;
                IMEMonitor<IAEGasStack> iMEMonitor = gridBlock.getGasMonitor();
                if (iMEMonitor == null) return;
                monitor = iMEMonitor;
                gasStack = GasUtil.getGasFromContainer(container);
                if (GasUtil.isEmpty(container)) break block19;
                if (gasStack.amount >= GasUtil.getCapacity(container)) break block20;
                FluidStack fluidStack = GasUtil.getFluidStack(gasStack);
                Intrinsics.checkExpressionValueIsNotNull((Object)fluidStack, (String)"GasUtil.getFluidStack(gasStack)");
                if (!Intrinsics.areEqual((Object)fluidStack.getFluid(), (Object)this.currentFluid) || !this.doNextFill) break block20;
            }
            if (this.currentFluid == null) {
                return;
            }
            int capacity = GasUtil.getCapacity(container);
            IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
            if (iGasStorageChannel == null) {
                Intrinsics.throwNpe();
            }
            IAEGasStack result2 = (IAEGasStack)monitor.extractItems(iGasStorageChannel.createStack(new GasStack(GasUtil.getGas(this.currentFluid), capacity)), Actionable.SIMULATE, (IActionSource)this.machineSource);
            int proposedAmount = 0;
            if (result2 == null) {
                proposedAmount = 0;
            } else if (gasStack == null) {
                n2 = (int)result2.getStackSize();
                n = 0;
                proposedAmount = Math.min(capacity, n2);
            } else {
                n2 = capacity - gasStack.amount;
                n = (int)result2.getStackSize();
                boolean bl = false;
                proposedAmount = Math.min(n2, n);
            }
            MutablePair<Integer, ItemStack> mutablePair = GasUtil.fillStack(container, GasUtil.getGasStack(new FluidStack(this.currentFluid, proposedAmount)));
            Intrinsics.checkExpressionValueIsNotNull(mutablePair, (String)"GasUtil.fillStack(contai\u2026tFluid, proposedAmount)))");
            MutablePair<Integer, ItemStack> filledContainer = mutablePair;
            ItemStack filledContainerItemStack = (ItemStack)filledContainer.right;
            GasStack gasStack2 = GasUtil.getGasFromContainer(filledContainerItemStack);
            if (gasStack2 == null) {
                this.doNextFill = false;
                return;
            }
            if (container.func_190916_E() == 1 && gasStack2.amount < GasUtil.getCapacity(filledContainerItemStack)) {
                this.inventory.func_70299_a(0, filledContainerItemStack);
                Gas gas = GasUtil.getGas(this.currentFluid);
                Object object = filledContainer.left;
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"filledContainer.left");
                monitor.extractItems(StorageChannels.GAS.createStack(new GasStack(gas, ((Number)object).intValue())), Actionable.MODULATE, (IActionSource)this.machineSource);
                this.doNextFill = true;
                return;
            }
            if (!this.fillSecondSlot(filledContainerItemStack)) return;
            Gas gas = GasUtil.getGas(this.currentFluid);
            Object object = filledContainer.left;
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"filledContainer.left");
            monitor.extractItems(StorageChannels.GAS.createStack(new GasStack(gas, ((Number)object).intValue())), Actionable.MODULATE, (IActionSource)this.machineSource);
            this.decreaseFirstSlot();
            this.doNextFill = false;
            return;
        }
        GasStack containerGas = GasUtil.getGasFromContainer(container);
        MutablePair<Integer, ItemStack> mutablePair = GasUtil.drainStack(container.func_77946_l(), containerGas);
        Intrinsics.checkExpressionValueIsNotNull(mutablePair, (String)"GasUtil.drainStack(container.copy(), containerGas)");
        MutablePair<Integer, ItemStack> drainedContainer = mutablePair;
        GasStack gasStack = containerGas.copy();
        Object object = drainedContainer.left;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"drainedContainer.left");
        gasStack.amount = ((Number)object).intValue();
        IGasStorageChannel iGasStorageChannel = StorageChannels.GAS;
        if (iGasStorageChannel == null) {
            Intrinsics.throwNpe();
        }
        if ((notInjected = (IAEGasStack)monitor.injectItems(iGasStorageChannel.createStack(gasStack), Actionable.SIMULATE, (IActionSource)this.machineSource)) != null) {
            return;
        }
        ItemStack emptyContainer = (ItemStack)drainedContainer.right;
        if (emptyContainer != null && !emptyContainer.func_190926_b() && GasUtil.getGasFromContainer(emptyContainer) != null && emptyContainer.func_190916_E() == 1) {
            monitor.injectItems(StorageChannels.GAS.createStack(gasStack), Actionable.MODULATE, (IActionSource)this.machineSource);
            this.inventory.func_70299_a(0, emptyContainer);
            return;
        }
        if (emptyContainer != null && !emptyContainer.func_190926_b()) {
            if (!this.fillSecondSlot(emptyContainer)) return;
        }
        IGasStorageChannel iGasStorageChannel2 = StorageChannels.GAS;
        if (iGasStorageChannel2 == null) {
            Intrinsics.throwNpe();
        }
        monitor.injectItems(iGasStorageChannel2.createStack(containerGas), Actionable.MODULATE, (IActionSource)this.machineSource);
        this.decreaseFirstSlot();
    }

    @Override
    @Nullable
    public Object getServerGuiElement(@Nullable EntityPlayer player) {
        if (this.isMekanismLoaded) {
            return new ContainerTerminal(this, player, StorageType.GAS);
        }
        return null;
    }

    @Override
    @Nullable
    public Object getClientGuiElement(@Nullable EntityPlayer player) {
        if (this.isMekanismLoaded) {
            return new GuiTerminal(this, player, StorageType.GAS);
        }
        return null;
    }

    public PartGasTerminal() {
        List list;
        PartGasTerminal partGasTerminal = this;
        boolean bl = false;
        partGasTerminal.containers = list = (List)new ArrayList();
        this.inventory = new InventoryPlain(this, "com.the9grounds.aeadditions.part.gas.terminal", 2, 64, this){
            final /* synthetic */ PartGasTerminal this$0;

            public boolean func_94041_b(int i, @NotNull ItemStack itemstack) {
                Intrinsics.checkParameterIsNotNull((Object)itemstack, (String)"itemstack");
                return this.this$0.isItemValidForInputSlot(i, itemstack);
            }

            protected void onContentsChanged() {
                PartGasTerminal.access$saveData(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        };
        this.machineSource = new MachineSource(this);
        this.isMekanismLoaded = Integration.Mods.MEKANISMGAS.isEnabled();
    }

    public static final /* synthetic */ void access$saveData(PartGasTerminal $this) {
        $this.saveData();
    }
}

