/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.tileentity;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import com.the9grounds.aeadditions.api.IECTileEntity;
import com.the9grounds.aeadditions.container.ContainerVibrationChamberFluid;
import com.the9grounds.aeadditions.gridblock.ECGridBlockVibrantChamber;
import com.the9grounds.aeadditions.gui.GuiVibrationChamberFluid;
import com.the9grounds.aeadditions.network.IGuiProvider;
import com.the9grounds.aeadditions.tileentity.IPowerStorage;
import com.the9grounds.aeadditions.tileentity.TileBase;
import com.the9grounds.aeadditions.util.FuelBurnTime;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001OB\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010)\u001a\u00020\u001cH\u0016J\u000e\u0010*\u001a\u00020\t2\u0006\u0010+\u001a\u00020\tJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/H\u0016J-\u00100\u001a\u0004\u0018\u0001H1\"\u0004\b\u0000\u001012\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\b\u00104\u001a\u0004\u0018\u000105H\u0016\u00a2\u0006\u0002\u00106J/\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\u0016\u0010;\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010=0<\"\u0004\u0018\u00010=H\u0017\u00a2\u0006\u0002\u0010>J\u0012\u0010?\u001a\u0004\u0018\u00010\u001c2\u0006\u0010.\u001a\u00020/H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\fH\u0016J/\u0010C\u001a\u00020D2\b\u00109\u001a\u0004\u0018\u00010:2\u0016\u0010;\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010=0<\"\u0004\u0018\u00010=H\u0016\u00a2\u0006\u0002\u0010EJ\b\u0010F\u001a\u00020GH\u0016J\u001e\u0010H\u001a\u00020\u00162\n\u00102\u001a\u0006\u0012\u0002\b\u0003032\b\u00104\u001a\u0004\u0018\u000105H\u0016J\u0010\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020GH\u0016J\b\u0010L\u001a\u00020JH\u0016J\b\u0010M\u001a\u00020JH\u0016J\u0010\u0010N\u001a\u00020G2\u0006\u0010K\u001a\u00020GH\u0016R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00060\u000eR\u00020\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u000e\u0010'\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/the9grounds/aeadditions/tileentity/TileEntityVibrationChamberFluid;", "Lcom/the9grounds/aeadditions/tileentity/TileBase;", "Lcom/the9grounds/aeadditions/api/IECTileEntity;", "Lappeng/api/networking/security/IActionHost;", "Lcom/the9grounds/aeadditions/tileentity/IPowerStorage;", "Lnet/minecraft/util/ITickable;", "Lcom/the9grounds/aeadditions/network/IGuiProvider;", "()V", "burnTime", "", "burnTimeTotal", "energyLeft", "", "fluidHandler", "Lcom/the9grounds/aeadditions/tileentity/TileEntityVibrationChamberFluid$FluidHandler;", "getFluidHandler", "()Lcom/the9grounds/aeadditions/tileentity/TileEntityVibrationChamberFluid$FluidHandler;", "setFluidHandler", "(Lcom/the9grounds/aeadditions/tileentity/TileEntityVibrationChamberFluid$FluidHandler;)V", "gridBlock", "Lcom/the9grounds/aeadditions/gridblock/ECGridBlockVibrantChamber;", "isFirstGridNode", "", "isFirstGridNode$AEAdditions_1_12_2", "()Z", "setFirstGridNode$AEAdditions_1_12_2", "(Z)V", "node", "Lappeng/api/networking/IGridNode;", "getNode$AEAdditions_1_12_2", "()Lappeng/api/networking/IGridNode;", "setNode$AEAdditions_1_12_2", "(Lappeng/api/networking/IGridNode;)V", "tank", "Lnet/minecraftforge/fluids/FluidTank;", "getTank", "()Lnet/minecraftforge/fluids/FluidTank;", "setTank", "(Lnet/minecraftforge/fluids/FluidTank;)V", "timer", "timerEnergy", "getActionableNode", "getBurntTimeScaled", "scale", "getCableConnectionType", "Lappeng/api/util/AECableType;", "p0", "Lappeng/api/util/AEPartLocation;", "getCapability", "T", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "facing", "Lnet/minecraft/util/EnumFacing;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/minecraft/util/EnumFacing;)Ljava/lang/Object;", "getClientGuiElement", "Lnet/minecraft/client/gui/inventory/GuiContainer;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "args", "", "", "(Lnet/minecraft/entity/player/EntityPlayer;[Ljava/lang/Object;)Lnet/minecraft/client/gui/inventory/GuiContainer;", "getGridNode", "getLocation", "Lappeng/api/util/DimensionalCoord;", "getPowerUsage", "getServerGuiElement", "Lnet/minecraft/inventory/Container;", "(Lnet/minecraft/entity/player/EntityPlayer;[Ljava/lang/Object;)Lnet/minecraft/inventory/Container;", "getUpdateTag", "Lnet/minecraft/nbt/NBTTagCompound;", "hasCapability", "readFromNBT", "", "compound", "securityBreak", "update", "writeToNBT", "FluidHandler", "AEAdditions-1.12.2"})
public final class TileEntityVibrationChamberFluid
extends TileBase
implements IECTileEntity,
IActionHost,
IPowerStorage,
ITickable,
IGuiProvider {
    private boolean isFirstGridNode = true;
    private final ECGridBlockVibrantChamber gridBlock = new ECGridBlockVibrantChamber(this);
    @Nullable
    private IGridNode node;
    @JvmField
    public int burnTime;
    private int burnTimeTotal;
    private int timer;
    private int timerEnergy;
    private double energyLeft;
    @NotNull
    private FluidTank tank = new FluidTank(16000){

        @NotNull
        public FluidTank readFromNBT(@Nullable NBTTagCompound nbt) {
            if (nbt == null) {
                return this;
            }
            if (!nbt.func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
                this.setFluid(fluid);
            } else {
                this.setFluid(null);
            }
            return this;
        }
    };
    @NotNull
    private FluidHandler fluidHandler = new FluidHandler();

    public final boolean isFirstGridNode$AEAdditions_1_12_2() {
        return this.isFirstGridNode;
    }

    public final void setFirstGridNode$AEAdditions_1_12_2(boolean bl) {
        this.isFirstGridNode = bl;
    }

    @Nullable
    public final IGridNode getNode$AEAdditions_1_12_2() {
        return this.node;
    }

    public final void setNode$AEAdditions_1_12_2(@Nullable IGridNode iGridNode) {
        this.node = iGridNode;
    }

    @NotNull
    public final FluidTank getTank() {
        return this.tank;
    }

    public final void setTank(@NotNull FluidTank fluidTank) {
        Intrinsics.checkParameterIsNotNull((Object)fluidTank, (String)"<set-?>");
        this.tank = fluidTank;
    }

    @NotNull
    public final FluidHandler getFluidHandler() {
        return this.fluidHandler;
    }

    public final void setFluidHandler(@NotNull FluidHandler fluidHandler) {
        Intrinsics.checkParameterIsNotNull((Object)fluidHandler, (String)"<set-?>");
        this.fluidHandler = fluidHandler;
    }

    @Nullable
    public IGridNode getGridNode(@NotNull AEPartLocation p0) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
        if (this.isFirstGridNode && this.func_145830_o() && !this.field_145850_b.field_72995_K) {
            this.isFirstGridNode = false;
            try {
                IGridNode iGridNode = this.node = AEApi.instance().grid().createGridNode((IGridBlock)this.gridBlock);
                if (iGridNode == null) {
                    Intrinsics.throwNpe();
                }
                iGridNode.updateState();
            }
            catch (Exception e) {
                this.isFirstGridNode = true;
            }
        }
        return this.node;
    }

    @NotNull
    public AECableType getCableConnectionType(@NotNull AEPartLocation p0) {
        Intrinsics.checkParameterIsNotNull((Object)p0, (String)"p0");
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    @Override
    @NotNull
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Override
    public double getPowerUsage() {
        return 0.0;
    }

    @NotNull
    public IGridNode getActionableNode() {
        IGridNode iGridNode = this.getGridNode(AEPartLocation.INTERNAL);
        if (iGridNode == null) {
            Intrinsics.throwNpe();
        }
        return iGridNode;
    }

    public void func_73660_a() {
        if (this.func_145830_o()) {
            return;
        }
        FluidStack fluidStack1 = this.tank.getFluid();
        if (fluidStack1 != null) {
            fluidStack1 = fluidStack1.copy();
        }
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.burnTime == this.burnTimeTotal) {
            if (this.timer >= 40) {
                this.updateBlock();
                FluidStack fluidStack = this.tank.getFluid();
                int localBurnTime = 0;
                if (fluidStack != null) {
                    Fluid fluid = fluidStack.getFluid();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"fluidStack.fluid");
                    localBurnTime = FuelBurnTime.getBurnTime(fluid);
                } else {
                    localBurnTime = 0;
                }
                if (fluidStack != null && localBurnTime > 0 && fluidStack.amount >= 250 && this.energyLeft <= 0.0) {
                    this.burnTime = 0;
                    this.burnTimeTotal = localBurnTime / 4;
                    this.tank.drain(250, true);
                }
                this.timer = 0;
            } else {
                ++this.timer;
            }
        } else {
            ++this.burnTime;
            if (this.timerEnergy == 4) {
                if (this.energyLeft == 0.0) {
                    IGridNode iGridNode = this.getGridNode(AEPartLocation.INTERNAL);
                    if (iGridNode == null) {
                        Intrinsics.throwNpe();
                    }
                    IGridCache iGridCache = iGridNode.getGrid().getCache(IEnergyGrid.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iGridCache, (String)"getGridNode(AEPartLocati\u2026(IEnergyGrid::class.java)");
                    IEnergyGrid energy = (IEnergyGrid)iGridCache;
                    this.energyLeft = energy.injectPower(24.0, Actionable.MODULATE);
                } else {
                    IGridNode iGridNode = this.getGridNode(AEPartLocation.INTERNAL);
                    if (iGridNode == null) {
                        Intrinsics.throwNpe();
                    }
                    IGridCache iGridCache = iGridNode.getGrid().getCache(IEnergyGrid.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)iGridCache, (String)"getGridNode(AEPartLocati\u2026(IEnergyGrid::class.java)");
                    IEnergyGrid energy = (IEnergyGrid)iGridCache;
                    this.energyLeft = energy.injectPower(this.energyLeft, Actionable.MODULATE);
                }
                this.timerEnergy = 0;
            } else {
                ++this.timerEnergy;
            }
        }
        if (fluidStack1 == null && this.tank.getFluid() == null) {
            return;
        }
        if (fluidStack1 == null || this.tank.getFluid() == null) {
            this.updateBlock();
            return;
        }
        if (!Intrinsics.areEqual((Object)fluidStack1, (Object)this.tank.getFluid())) {
            this.updateBlock();
            return;
        }
        int n = fluidStack1.amount;
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack == null) {
            Intrinsics.throwNpe();
        }
        if (n == fluidStack.amount) {
            this.updateBlock();
            return;
        }
    }

    @NotNull
    public NBTTagCompound func_189515_b(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_189515_b(compound);
        this.writePowerToNBT(compound);
        compound.func_74768_a("burnTime", this.burnTime);
        compound.func_74768_a("burnTimeTotal", this.burnTimeTotal);
        compound.func_74768_a("timer", this.timer);
        compound.func_74768_a("timerEnergy", this.timerEnergy);
        compound.func_74780_a("energyLeft", this.energyLeft);
        this.tank.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(@NotNull NBTTagCompound compound) {
        Intrinsics.checkParameterIsNotNull((Object)compound, (String)"compound");
        super.func_145839_a(compound);
        this.readPowerFromNBT(compound);
        if (compound.func_74764_b("burnTime")) {
            this.burnTime = compound.func_74762_e("burnTime");
        }
        if (compound.func_74764_b("burnTimeTotal")) {
            this.burnTimeTotal = compound.func_74762_e("burnTimeTotal");
        }
        if (compound.func_74764_b("timer")) {
            this.timer = compound.func_74762_e("timer");
        }
        if (compound.func_74764_b("timerEnergy")) {
            this.timerEnergy = compound.func_74762_e("timerEnergy");
        }
        if (compound.func_74764_b("energyLeft")) {
            this.energyLeft = compound.func_74769_h("energyLeft");
        }
        this.tank.readFromNBT(compound);
    }

    public final int getBurntTimeScaled(int scale) {
        return this.burnTime != 0 ? this.burnTime * scale / this.burnTimeTotal : 0;
    }

    @NotNull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public GuiContainer getClientGuiElement(@Nullable EntityPlayer player, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        return new GuiVibrationChamberFluid(player, this);
    }

    @Override
    @NotNull
    public Container getServerGuiElement(@Nullable EntityPlayer player, Object ... args) {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        EntityPlayer entityPlayer = player;
        if (entityPlayer == null) {
            Intrinsics.throwNpe();
        }
        return new ContainerVibrationChamberFluid(entityPlayer.field_71071_by, this);
    }

    @Nullable
    public <T> T getCapability(@NotNull Capability<T> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.fluidHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@NotNull Capability<?> capability, @Nullable EnumFacing facing) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        if (Intrinsics.areEqual(capability, (Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public double getAECurrentPower() {
        return IPowerStorage.DefaultImpls.getAECurrentPower(this);
    }

    @Override
    @NotNull
    public AccessRestriction getPowerFlow() {
        return IPowerStorage.DefaultImpls.getPowerFlow(this);
    }

    @Override
    public double getAEMaxPower() {
        return IPowerStorage.DefaultImpls.getAEMaxPower(this);
    }

    @Override
    public void setMaxPower(double power) {
        IPowerStorage.DefaultImpls.setMaxPower(this, power);
    }

    @Override
    public double injectAEPower(double amt, @NotNull Actionable mode) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        return IPowerStorage.DefaultImpls.injectAEPower(this, amt, mode);
    }

    @Override
    public boolean isAEPublicPowerStorage() {
        return IPowerStorage.DefaultImpls.isAEPublicPowerStorage(this);
    }

    @Override
    public double extractAEPower(double amount, @NotNull Actionable mode, @NotNull PowerMultiplier usePowerMultiplier) {
        Intrinsics.checkParameterIsNotNull((Object)mode, (String)"mode");
        Intrinsics.checkParameterIsNotNull((Object)usePowerMultiplier, (String)"usePowerMultiplier");
        return IPowerStorage.DefaultImpls.extractAEPower(this, amount, mode, usePowerMultiplier);
    }

    @Override
    public void readPowerFromNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        IPowerStorage.DefaultImpls.readPowerFromNBT(this, tag);
    }

    @Override
    public void writePowerToNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        IPowerStorage.DefaultImpls.writePowerToNBT(this, tag);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\n\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/the9grounds/aeadditions/tileentity/TileEntityVibrationChamberFluid$FluidHandler;", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "(Lcom/the9grounds/aeadditions/tileentity/TileEntityVibrationChamberFluid;)V", "drain", "Lnet/minecraftforge/fluids/FluidStack;", "maxDrain", "", "doDrain", "", "resource", "fill", "doFill", "getTankProperties", "", "Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "()[Lnet/minecraftforge/fluids/capability/IFluidTankProperties;", "AEAdditions-1.12.2"})
    public final class FluidHandler
    implements IFluidHandler {
        @NotNull
        public IFluidTankProperties[] getTankProperties() {
            IFluidTankProperties[] iFluidTankPropertiesArray = TileEntityVibrationChamberFluid.this.getTank().getTankProperties();
            Intrinsics.checkExpressionValueIsNotNull((Object)iFluidTankPropertiesArray, (String)"tank.tankProperties");
            return iFluidTankPropertiesArray;
        }

        public int fill(@Nullable FluidStack resource, boolean doFill) {
            block5: {
                block4: {
                    if (resource == null || resource.getFluid() == null) break block4;
                    Fluid fluid = resource.getFluid();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fluid, (String)"resource.fluid");
                    if (FuelBurnTime.getBurnTime(fluid) != 0) break block5;
                }
                return 0;
            }
            int filled = TileEntityVibrationChamberFluid.this.getTank().fill(resource, doFill);
            if (filled != 0 && TileEntityVibrationChamberFluid.this.func_145830_o()) {
                TileEntityVibrationChamberFluid.this.updateBlock();
            }
            return filled;
        }

        @Nullable
        public FluidStack drain(@Nullable FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }
    }
}

