/*
 * Decompiled with CFR 0.152.
 */
package com.the9grounds.aeadditions.util;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class FluidHelper {
    public static Pair<Integer, ItemStack> drainStack(ItemStack itemStack, FluidStack fluid) {
        if (itemStack == null) {
            return null;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return null;
        }
        FluidStack drained = fluidHandler.drain(fluid, true);
        if (fluidHandler instanceof FluidBucketWrapper) {
            itemStack = ((FluidBucketWrapper)fluidHandler).getContainer();
        }
        return new MutablePair((Object)(drained != null && drained.getFluid() == fluid.getFluid() ? drained.amount : 0), (Object)itemStack);
    }

    public static Pair<Integer, ItemStack> fillStack(ItemStack itemStack, FluidStack fluid) {
        if (itemStack == null) {
            return null;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return null;
        }
        int filled = fluidHandler.fill(fluid, true);
        if (fluidHandler instanceof FluidBucketWrapper) {
            itemStack = ((FluidBucketWrapper)fluidHandler).getContainer();
        }
        return new MutablePair((Object)filled, (Object)itemStack);
    }

    public static int getCapacity(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        int amount = 0;
        if (handler != null) {
            for (IFluidTankProperties tank2 : handler.getTankProperties()) {
                amount += tank2.getCapacity();
            }
        }
        return amount;
    }

    public static int getCapacity(ItemStack itemStack, Fluid fluidToFill) {
        if (itemStack == null) {
            return 0;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        return fluidHandler.fill(new FluidStack(fluidToFill, Integer.MAX_VALUE), false);
    }

    public static FluidStack getFluidFromContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return FluidUtil.getFluidContained((ItemStack)itemStack);
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return FluidHelper.isFillableContainerAndEmpty(itemStack);
    }

    public static boolean isFilled(ItemStack itemStack) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            FluidStack contents;
            if (properties.getCapacity() <= 0 || (contents = properties.getContents()) == null || contents.amount <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isFluidContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        return fluidHandler != null;
    }

    public static ItemStack getEmptyContainer(ItemStack container) {
        ItemStack empty = container.func_77946_l();
        empty.func_190920_e(1);
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return null;
        }
        if (fluidHandler.drain(Integer.MAX_VALUE, true) != null) {
            return empty;
        }
        return null;
    }

    public static boolean isFillableContainerAndEmpty(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            FluidStack contents;
            if (!properties.canFill() || properties.getCapacity() <= 0 || (contents = properties.getContents()) == null || contents.amount <= 0) continue;
            return false;
        }
        return tankProperties.length > 0;
    }

    public static boolean isFillableContainerWithRoom(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill() || properties.getCapacity() <= 0) continue;
            FluidStack contents = properties.getContents();
            if (contents == null) {
                return true;
            }
            if (contents.amount >= properties.getCapacity()) continue;
            return true;
        }
        return false;
    }

    public static boolean isDrainableFilledContainer(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents != null && contents.amount > 0) continue;
            return false;
        }
        return fluidHandler.drain(Integer.MAX_VALUE, false) != null;
    }
}

