/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.AccessRestriction;
import appeng.api.config.ActionItems;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.container.implementations.ContainerOreDictStorageBus;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.parts.misc.PartOreDicStorageBus;
import appeng.util.item.OreDictFilterMatcher;
import java.io.IOException;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Mouse;

public class GuiOreDictStorageBus
extends AEBaseGui {
    private final ContainerOreDictStorageBus container;
    PartOreDicStorageBus part;
    private GuiTabButton priority;
    private GuiImgButton partition;
    private GuiImgButton storageFilter;
    private GuiImgButton rwMode;
    private static final Pattern ORE_DICTIONARY_FILTER = Pattern.compile("[(!]* *[0-9a-zA-Z*]* *\\)*( *[&|^]? *[(!]* *[0-9a-zA-Z*]* *\\)*)*");
    private MEGuiTextField searchFieldInputs;

    public GuiOreDictStorageBus(InventoryPlayer inventoryPlayer, PartOreDicStorageBus te) {
        super(new ContainerOreDictStorageBus(inventoryPlayer, te));
        this.container = (ContainerOreDictStorageBus)this.field_147002_h;
        this.part = te;
        this.field_147000_g = 84;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchFieldInputs = new MEGuiTextField(this.field_146289_q, this.field_147003_i + 3, this.field_147009_r + 22, 170, 12);
        this.searchFieldInputs.func_146185_a(false);
        this.searchFieldInputs.func_146203_f(512);
        this.searchFieldInputs.func_146193_g(0xFFFFFF);
        this.searchFieldInputs.func_146189_e(true);
        this.searchFieldInputs.func_146195_b(false);
        this.searchFieldInputs.func_175205_a(str -> ORE_DICTIONARY_FILTER.matcher((CharSequence)str).matches());
        this.priority = new GuiTabButton(this.field_147003_i + 154, this.field_147009_r, 66, GuiText.Priority.getLocal(), this.field_146296_j);
        this.field_146292_n.add(this.priority);
        this.partition = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, Settings.ACTIONS, ActionItems.WRENCH);
        this.field_146292_n.add(this.partition);
        this.rwMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 48, Settings.ACCESS, AccessRestriction.READ_WRITE);
        this.field_146292_n.add(this.rwMode);
        this.storageFilter = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 68, Settings.STORAGE_FILTER, StorageFilter.EXTRACTABLE_ONLY);
        this.field_146292_n.add(this.storageFilter);
        try {
            NetworkHandler.instance().sendToServer(new PacketValueConfig("OreDictStorageBus.getRegex", "1"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void fillRegex(String regex) {
        this.searchFieldInputs.func_146180_a(regex);
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        try {
            if (btn == this.priority) {
                NetworkHandler.instance().sendToServer(new PacketSwitchGuis(GuiBridge.GUI_PRIORITY));
            } else if (btn == this.partition) {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("StorageBus.Action", "Partition"));
            } else if (btn == this.rwMode) {
                NetworkHandler.instance().sendToServer(new PacketConfigButton(this.rwMode.getSetting(), backwards));
            } else if (btn == this.storageFilter) {
                NetworkHandler.instance().sendToServer(new PacketConfigButton(this.storageFilter.getSetting(), backwards));
            }
        }
        catch (IOException e) {
            AELog.debug(e);
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        boolean wasFocused = this.searchFieldInputs.func_146206_l();
        this.searchFieldInputs.func_146192_a(xCoord, yCoord, btn);
        if (btn == 1 && this.searchFieldInputs.isMouseIn(xCoord, yCoord)) {
            this.searchFieldInputs.func_146180_a("");
        }
        if (!this.searchFieldInputs.func_146206_l() && wasFocused) {
            this.searchFieldInputs.func_146180_a(OreDictFilterMatcher.validateExp(this.searchFieldInputs.func_146179_b()));
            NetworkHandler.instance().sendToServer(new PacketValueConfig("OreDictStorageBus.save", this.searchFieldInputs.func_146179_b()));
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key) && !this.searchFieldInputs.func_146201_a(character, key)) {
            super.func_73869_a(character, key);
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.OreDictStorageBus.getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.searchFieldInputs.func_146179_b().length() + " / " + this.searchFieldInputs.func_146208_g(), 120, 36, 0x404040);
        this.field_146289_q.func_78276_b("& = AND    | = OR", 8, 36, 0x404040);
        this.field_146289_q.func_78276_b("^ = XOR    ! = NOT", 8, 48, 0x404040);
        this.field_146289_q.func_78276_b("() for priority    * for wildcard", 8, 60, 0x404040);
        this.field_146289_q.func_78276_b("Ex.: *Redstone*&!dustRedstone", 8, 72, 0x404040);
        if (this.storageFilter != null) {
            this.storageFilter.set(this.container.getStorageFilter());
        }
        if (this.rwMode != null) {
            this.rwMode.set(this.container.getReadWriteMode());
        }
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/oredictstoragebus.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, 175, 85);
        if (this.searchFieldInputs != null) {
            this.searchFieldInputs.func_146194_f();
        }
    }
}

