/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.definitions.IDefinitions;
import appeng.api.storage.ITerminalHost;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternOutputs;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.IContainerCraftingPacket;
import appeng.parts.reporting.PartExpandedProcessingPatternTerminal;
import appeng.util.Platform;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public class ContainerExpandedProcessingPatternTerm
extends ContainerMEMonitorable
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket {
    private final IItemHandler crafting;
    private final SlotFakeCraftingMatrix[] gridSlots = new SlotFakeCraftingMatrix[16];
    private final OptionalSlotFake[] outputSlots = new OptionalSlotFake[6];
    private final SlotRestrictedInput patternSlotIN;
    private final SlotRestrictedInput patternSlotOUT;
    private final PartExpandedProcessingPatternTerminal expandedProcessingPatternTerminal;

    public ContainerExpandedProcessingPatternTerm(InventoryPlayer ip, ITerminalHost monitorable) {
        super(ip, monitorable, false);
        int x;
        int y;
        this.expandedProcessingPatternTerminal = (PartExpandedProcessingPatternTerminal)monitorable;
        IItemHandler patternInv = this.getExpandedPatternTerminal().getInventoryByName("pattern");
        IItemHandler output = this.getExpandedPatternTerminal().getInventoryByName("output");
        this.crafting = this.getExpandedPatternTerminal().getInventoryByName("crafting");
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                SlotFakeCraftingMatrix slotFakeCraftingMatrix = new SlotFakeCraftingMatrix(this.crafting, x + y * 4, 4 + x * 18, -85 + y * 18);
                this.gridSlots[x + y * 4] = slotFakeCraftingMatrix;
                this.func_75146_a(slotFakeCraftingMatrix);
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 2; ++x) {
                SlotPatternOutputs slotPatternOutputs = new SlotPatternOutputs(output, this, x + y * 2, 96 + x * 18, -76 + y * 18, 0, 0, 1);
                this.outputSlots[x + y * 2] = slotPatternOutputs;
                this.func_75146_a(slotPatternOutputs);
                this.outputSlots[x + y * 2].setRenderDisabled(false);
                this.outputSlots[x + y * 2].setIIcon(-1);
            }
        }
        this.patternSlotIN = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.BLANK_PATTERN, patternInv, 0, 147, -81, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotIN);
        this.patternSlotOUT = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, patternInv, 1, 147, -38, this.getInventoryPlayer());
        this.func_75146_a(this.patternSlotOUT);
        this.patternSlotOUT.setStackLimit(1);
        this.bindPlayerInventory(ip, 0, 0);
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return ItemStack.field_190927_a;
        }
        if (this.field_75151_b.get(idx) instanceof SlotPlayerInv || this.field_75151_b.get(idx) instanceof SlotPlayerHotBar) {
            AppEngSlot clickSlot = (AppEngSlot)((Object)this.field_75151_b.get(idx));
            ItemStack itemStack = clickSlot.func_75211_c();
            if (AEApi.instance().definitions().materials().blankPattern().isSameAs(itemStack)) {
                IItemHandler patternInv = this.getExpandedPatternTerminal().getInventoryByName("pattern");
                ItemStack remainder = patternInv.insertItem(0, itemStack, false);
                clickSlot.func_75215_d(remainder);
            }
        }
        return super.func_82846_b(p, idx);
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    public void encodeAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (!output.func_190926_b()) {
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.getPlayerInv().field_70458_d.func_71019_a(output, false);
            }
            this.patternSlotOUT.func_75215_d(ItemStack.field_190927_a);
        }
    }

    public void encode() {
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (!output.func_190926_b() && !this.isPattern(output)) {
            return;
        }
        if (output.func_190926_b()) {
            Optional<ItemStack> maybePattern;
            output = this.patternSlotIN.func_75211_c();
            if (output.func_190926_b() || !this.isPattern(output)) {
                return;
            }
            output.func_190920_e(output.func_190916_E() - 1);
            if (output.func_190916_E() == 0) {
                this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
            }
            if ((maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1)).isPresent()) {
                output = maybePattern.get();
                this.patternSlotOUT.func_75215_d(output);
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", false);
        encodedValue.func_74757_a("substitute", false);
        output.func_77982_d(encodedValue);
    }

    boolean isPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return isPattern |= definitions.materials().blankPattern().isSameAs(output);
    }

    NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (!i.func_190926_b()) {
            i.func_77955_b(c);
        }
        return c;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        return true;
    }

    protected ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[16];
        boolean hasValue = false;
        for (int x = 0; x < this.gridSlots.length; ++x) {
            input[x] = this.gridSlots[x].func_75211_c();
            if (input[x].func_190926_b()) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    protected ItemStack[] getOutputs() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(3);
        boolean hasValue = false;
        for (OptionalSlotFake outputSlot : this.outputSlots) {
            ItemStack out = outputSlot.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() <= 0) continue;
            list.add(out);
            hasValue = true;
        }
        if (hasValue) {
            return list.toArray(new ItemStack[0]);
        }
        return null;
    }

    public void clear() {
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.gridSlots) {
            slotFakeCraftingMatrix.func_75215_d(ItemStack.field_190927_a);
        }
        for (SlotFake slotFake : this.outputSlots) {
            slotFake.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
    }

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("player")) {
            return new PlayerInvWrapper(this.getInventoryPlayer());
        }
        return this.getExpandedPatternTerminal().getInventoryByName(name);
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    public PartExpandedProcessingPatternTerminal getExpandedPatternTerminal() {
        return this.expandedProcessingPatternTerminal;
    }

    public void multiply(int multiple) {
        ItemStack[] input = new ItemStack[this.gridSlots.length];
        boolean canMultiplyInputs = true;
        boolean canMultiplyOutputs = true;
        for (int x = 0; x < this.gridSlots.length; ++x) {
            input[x] = this.gridSlots[x].func_75211_c();
            if (input[x].func_190926_b() || input[x].func_190916_E() * multiple <= input[x].func_77976_d()) continue;
            canMultiplyInputs = false;
        }
        for (OptionalSlotFake optionalSlotFake : this.outputSlots) {
            ItemStack out = optionalSlotFake.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() * multiple <= out.func_77976_d()) continue;
            canMultiplyOutputs = false;
        }
        if (canMultiplyInputs && canMultiplyOutputs) {
            ItemStack stack;
            for (SlotFake slotFake : this.gridSlots) {
                stack = slotFake.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFake.func_75211_c().func_190920_e(stack.func_190916_E() * multiple);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() * multiple);
            }
        }
    }

    public void divide(int divide) {
        ItemStack[] input = new ItemStack[this.gridSlots.length];
        boolean canDivideInputs = true;
        boolean canDivideOutputs = true;
        for (int x = 0; x < this.gridSlots.length; ++x) {
            input[x] = this.gridSlots[x].func_75211_c();
            if (input[x].func_190926_b() || input[x].func_190916_E() % divide == 0) continue;
            canDivideInputs = false;
        }
        for (OptionalSlotFake optionalSlotFake : this.outputSlots) {
            ItemStack out = optionalSlotFake.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() % divide == 0) continue;
            canDivideOutputs = false;
        }
        if (canDivideInputs && canDivideOutputs) {
            ItemStack stack;
            for (SlotFake slotFake : this.gridSlots) {
                stack = slotFake.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFake.func_75211_c().func_190920_e(stack.func_190916_E() / divide);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() / divide);
            }
        }
    }

    public void increase(int increase) {
        ItemStack[] input = new ItemStack[this.gridSlots.length];
        boolean canIncreaseInputs = true;
        boolean canIncreaseOutputs = true;
        for (int x = 0; x < this.gridSlots.length; ++x) {
            input[x] = this.gridSlots[x].func_75211_c();
            if (input[x].func_190926_b() || input[x].func_190916_E() + increase <= input[x].func_77976_d()) continue;
            canIncreaseInputs = false;
        }
        for (OptionalSlotFake optionalSlotFake : this.outputSlots) {
            ItemStack out = optionalSlotFake.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() + increase <= out.func_77976_d()) continue;
            canIncreaseOutputs = false;
        }
        if (canIncreaseInputs && canIncreaseOutputs) {
            ItemStack stack;
            for (SlotFake slotFake : this.gridSlots) {
                stack = slotFake.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFake.func_75211_c().func_190920_e(stack.func_190916_E() + increase);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() + increase);
            }
        }
    }

    public void decrease(int decrease) {
        ItemStack[] input = new ItemStack[this.gridSlots.length];
        boolean canDecreaseInputs = true;
        boolean canDecreaseOutputs = true;
        for (int x = 0; x < this.gridSlots.length; ++x) {
            input[x] = this.gridSlots[x].func_75211_c();
            if (input[x].func_190926_b() || input[x].func_190916_E() - decrease >= 1) continue;
            canDecreaseInputs = false;
        }
        for (OptionalSlotFake optionalSlotFake : this.outputSlots) {
            ItemStack out = optionalSlotFake.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() - decrease >= 1) continue;
            canDecreaseOutputs = false;
        }
        if (canDecreaseInputs && canDecreaseOutputs) {
            ItemStack stack;
            for (SlotFake slotFake : this.gridSlots) {
                stack = slotFake.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFake.func_75211_c().func_190920_e(stack.func_190916_E() - decrease);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() - decrease);
            }
        }
    }

    public void maximizeCount() {
        ItemStack[] input = new ItemStack[this.gridSlots.length];
        boolean canGrowInputs = true;
        boolean canGrowOutputs = true;
        int maxInputStackGrowth = 0;
        int maxOutputStackGrowth = 0;
        for (int x = 0; x < this.gridSlots.length; ++x) {
            input[x] = this.gridSlots[x].func_75211_c();
            if (!input[x].func_190926_b() && input[x].func_77976_d() - input[x].func_190916_E() > maxInputStackGrowth) {
                maxInputStackGrowth = input[x].func_77976_d() - input[x].func_190916_E();
            }
            if (input[x].func_190926_b() || input[x].func_190916_E() + maxInputStackGrowth <= input[x].func_77976_d()) continue;
            canGrowInputs = false;
        }
        for (OptionalSlotFake outputSlot : this.outputSlots) {
            ItemStack itemStack = outputSlot.func_75211_c();
            maxOutputStackGrowth = itemStack.func_77976_d() - itemStack.func_190916_E();
            if (itemStack.func_190926_b() || itemStack.func_190916_E() + maxOutputStackGrowth <= itemStack.func_77976_d()) continue;
            canGrowOutputs = false;
        }
        if (canGrowInputs && canGrowOutputs) {
            ItemStack stack;
            int maxStackGrowth = Math.min(maxInputStackGrowth, maxOutputStackGrowth);
            for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.gridSlots) {
                stack = slotFakeCraftingMatrix.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFakeCraftingMatrix.func_75211_c().func_190920_e(stack.func_190916_E() + maxStackGrowth);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() + maxStackGrowth);
            }
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                for (Slot slot : this.field_75151_b) {
                    if (!(slot instanceof OptionalSlotFake) && !(slot instanceof SlotFakeCraftingMatrix)) continue;
                    listener.func_71111_a((Container)this, slot.field_75222_d, slot.func_75211_c());
                }
                if (!(listener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)listener).field_71137_h = false;
            }
            this.func_75142_b();
        }
    }
}

