/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.util.IConfigManager;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotRestrictedInput;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotNormal;
import appeng.container.slot.SlotRestrictedInput;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;

public class ContainerInterface
extends ContainerUpgradeable
implements IOptionalSlotHost {
    private final DualityInterface myDuality;
    @GuiSync(value=3)
    public YesNo bMode = YesNo.NO;
    @GuiSync(value=4)
    public YesNo iTermMode = YesNo.YES;
    @GuiSync(value=7)
    public int patternExpansions = 0;

    public ContainerInterface(InventoryPlayer ip, IInterfaceHost te) {
        super(ip, te.getInterfaceDuality().getHost());
        int x;
        this.myDuality = te.getInterfaceDuality();
        for (int row = 0; row < 4; ++row) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new OptionalSlotRestrictedInput(SlotRestrictedInput.PlacableItemType.ENCODED_PATTERN, this.myDuality.getPatterns(), this, x2 + row * 9, 8 + 18 * x2, 97 + 18 * row, row, this.getInventoryPlayer()).setStackLimit(1));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new SlotFake(this.myDuality.getConfig(), x, 8 + 18 * x, 35));
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new SlotNormal(this.myDuality.getStorage(), x, 8 + 18 * x, 53));
        }
    }

    @Override
    protected int getHeight() {
        return 256;
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    public int availableUpgrades() {
        return 4;
    }

    @Override
    public boolean isSlotEnabled(int idx) {
        return this.myDuality.getInstalledUpgrades(Upgrades.PATTERN_EXPANSION) >= idx;
    }

    @Override
    public void func_75142_b() {
        this.verifyPermissions(SecurityPermissions.BUILD, false);
        if (this.patternExpansions != this.getPatternUpgrades()) {
            this.patternExpansions = this.getPatternUpgrades();
            this.myDuality.dropExcessPatterns();
        }
        super.func_75142_b();
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (Platform.isClient() && field.equals("patternExpansions")) {
            this.myDuality.dropExcessPatterns();
        }
    }

    @Override
    protected void loadSettingsFromHost(IConfigManager cm) {
        this.setBlockingMode((YesNo)cm.getSetting(Settings.BLOCK));
        this.setInterfaceTerminalMode((YesNo)cm.getSetting(Settings.INTERFACE_TERMINAL));
    }

    public YesNo getBlockingMode() {
        return this.bMode;
    }

    private void setBlockingMode(YesNo bMode) {
        this.bMode = bMode;
    }

    public YesNo getInterfaceTerminalMode() {
        return this.iTermMode;
    }

    private void setInterfaceTerminalMode(YesNo iTermMode) {
        this.iTermMode = iTermMode;
    }

    public int getPatternUpgrades() {
        return this.myDuality.getInstalledUpgrades(Upgrades.PATTERN_EXPANSION);
    }
}

