/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.AEApi;
import appeng.api.config.TunnelType;
import appeng.api.definitions.IBlocks;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IParts;
import appeng.api.features.IP2PTunnelRegistry;
import appeng.api.util.AEColor;
import appeng.capabilities.Capabilities;
import appeng.util.item.OreHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public final class P2PTunnelRegistry
implements IP2PTunnelRegistry {
    private static final int INITIAL_CAPACITY = 40;
    private final Map<ItemStack, TunnelType> tunnels = new HashMap<ItemStack, TunnelType>(40);
    private final Map<String, TunnelType> modIdTunnels = new HashMap<String, TunnelType>(40);
    private final Map<Capability<?>, TunnelType> capTunnels = new HashMap(40);

    public void configure() {
        IDefinitions definitions = AEApi.instance().definitions();
        IBlocks blocks = definitions.blocks();
        IParts parts = definitions.parts();
        this.addNewAttunement(new ItemStack(Blocks.field_150478_aa), TunnelType.LIGHT);
        this.addNewAttunement(new ItemStack(Blocks.field_150426_aN), TunnelType.LIGHT);
        ArrayList<String> gtceOreDict = new ArrayList<String>();
        gtceOreDict.add("wireGtHex");
        gtceOreDict.add("wireGtOctal");
        gtceOreDict.add("wireGtQuadruple");
        gtceOreDict.add("wireGtDouble");
        gtceOreDict.add("wireGtSingle");
        gtceOreDict.add("cableGtHex");
        gtceOreDict.add("cableGtOctal");
        gtceOreDict.add("cableGtQuadruple");
        gtceOreDict.add("cableGtDouble");
        gtceOreDict.add("cableGtSingle");
        for (String oreDict : gtceOreDict) {
            Arrays.stream(OreDictionary.getOreNames()).filter(oreName -> oreName.startsWith(oreDict)).forEach(oreName -> OreHelper.INSTANCE.getCachedOres((String)oreName).forEach(stack -> this.addNewAttunement((ItemStack)stack, TunnelType.GTEU_POWER)));
        }
        this.addNewAttunement(blocks.energyCellDense(), TunnelType.FE_POWER);
        this.addNewAttunement(blocks.energyAcceptor(), TunnelType.FE_POWER);
        this.addNewAttunement(blocks.energyCell(), TunnelType.FE_POWER);
        this.addNewAttunement(blocks.energyCellCreative(), TunnelType.FE_POWER);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_0", 0), TunnelType.FE_POWER);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_0", 1), TunnelType.FE_POWER);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_0", 2), TunnelType.FE_POWER);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_0", 3), TunnelType.FE_POWER);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_0", 4), TunnelType.FE_POWER);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_0", 5), TunnelType.FE_POWER);
        this.addNewAttunement(this.getModItem("ic2", "cable", 0), TunnelType.IC2_POWER);
        this.addNewAttunement(this.getModItem("ic2", "cable", 1), TunnelType.IC2_POWER);
        this.addNewAttunement(this.getModItem("ic2", "cable", 2), TunnelType.IC2_POWER);
        this.addNewAttunement(this.getModItem("ic2", "cable", 3), TunnelType.IC2_POWER);
        this.addNewAttunement(this.getModItem("ic2", "cable", 4), TunnelType.IC2_POWER);
        this.addNewAttunement(new ItemStack(Items.field_151137_ax), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack(Items.field_151107_aW), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack(Blocks.field_150379_bu), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.field_150441_bU), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.field_150455_bV), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.field_150416_aS), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.field_150413_aR), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.field_150453_bW), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack((Block)Blocks.field_150488_af), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack(Blocks.field_150451_bX), TunnelType.REDSTONE);
        this.addNewAttunement(new ItemStack(Blocks.field_150442_at), TunnelType.REDSTONE);
        this.addNewAttunement(this.getModItem("enderio", "itemredstoneconduit", Short.MAX_VALUE), TunnelType.REDSTONE);
        this.addNewAttunement(blocks.iface(), TunnelType.ITEM);
        this.addNewAttunement(parts.iface(), TunnelType.ITEM);
        this.addNewAttunement(parts.storageBus(), TunnelType.ITEM);
        this.addNewAttunement(parts.importBus(), TunnelType.ITEM);
        this.addNewAttunement(parts.exportBus(), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack((Block)Blocks.field_150438_bZ), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack((Block)Blocks.field_150486_ae), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack(Blocks.field_150447_bR), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("extrautilities", "extractor_base", 0), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("mekanism", "parttransmitter", 9), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("enderio", "itemitemconduit", Short.MAX_VALUE), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_32", 0), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_32", 1), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_32", 2), TunnelType.ITEM);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_32", 3), TunnelType.ITEM);
        this.addNewAttunement(new ItemStack(Items.field_151133_ar), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack(Items.field_151129_at), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack(Items.field_151117_aB), TunnelType.FLUID);
        this.addNewAttunement(new ItemStack(Items.field_151131_as), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("mekanism", "machineblock2", 11), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("mekanism", "parttransmitter", 4), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("extrautilities", "extractor_base", 6), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("extrautilities", "drum", Short.MAX_VALUE), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("enderio", "itemliquidconduit", Short.MAX_VALUE), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_16", 0), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_16", 1), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_16", 2), TunnelType.FLUID);
        this.addNewAttunement(this.getModItem("thermaldynamics", "duct_16", 3), TunnelType.FLUID);
        for (AEColor c : AEColor.values()) {
            this.addNewAttunement(parts.cableGlass().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableCovered().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableSmart().stack(c, 1), TunnelType.ME);
            this.addNewAttunement(parts.cableDenseSmart().stack(c, 1), TunnelType.ME);
        }
        this.addNewAttunement(Capabilities.FORGE_ENERGY, TunnelType.FE_POWER);
        this.addNewAttunement(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, TunnelType.FLUID);
        this.addNewAttunement("thermaldynamics", TunnelType.FE_POWER);
        this.addNewAttunement("thermalexpansion", TunnelType.FE_POWER);
        this.addNewAttunement("thermalfoundation", TunnelType.FE_POWER);
        this.addNewAttunement("enderio", TunnelType.FE_POWER);
        this.addNewAttunement("mekanism", TunnelType.FE_POWER);
        this.addNewAttunement("rftools", TunnelType.FE_POWER);
        this.addNewAttunement("ic2", TunnelType.IC2_POWER);
    }

    @Override
    public void addNewAttunement(@Nonnull String modId, @Nullable TunnelType type) {
        if (type == null || modId == null) {
            return;
        }
        this.modIdTunnels.put(modId, type);
    }

    @Override
    public void addNewAttunement(@Nonnull Capability<?> cap, @Nullable TunnelType type) {
        if (type == null || cap == null) {
            return;
        }
        this.capTunnels.put(cap, type);
    }

    @Override
    public void addNewAttunement(@Nonnull ItemStack trigger, @Nullable TunnelType type) {
        if (type == null || trigger.func_190926_b()) {
            return;
        }
        this.tunnels.put(trigger, type);
    }

    @Override
    @Nullable
    public TunnelType getTunnelTypeByItem(ItemStack trigger) {
        if (!trigger.func_190926_b()) {
            for (Map.Entry<ItemStack, TunnelType> entry : this.tunnels.entrySet()) {
                ItemStack is = entry.getKey();
                if (is.func_77973_b() == trigger.func_77973_b() && is.func_77952_i() == Short.MAX_VALUE) {
                    return entry.getValue();
                }
                if (!ItemStack.func_179545_c((ItemStack)is, (ItemStack)trigger)) continue;
                return entry.getValue();
            }
            for (EnumFacing face : EnumFacing.field_82609_l) {
                for (Map.Entry<Capability<?>, TunnelType> entry : this.capTunnels.entrySet()) {
                    if (!trigger.hasCapability(entry.getKey(), face)) continue;
                    return entry.getValue();
                }
            }
            for (Map.Entry entry : this.modIdTunnels.entrySet()) {
                if (trigger.func_77973_b().getRegistryName() == null || !trigger.func_77973_b().getRegistryName().func_110624_b().equals(entry.getKey())) continue;
                return (TunnelType)((Object)entry.getValue());
            }
        }
        return null;
    }

    @Nonnull
    private ItemStack getModItem(String modID, String name, int meta) {
        Item item = Item.func_111206_d((String)(modID + ":" + name));
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack myItemStack = new ItemStack(item, 1, meta);
        return myItemStack;
    }

    private void addNewAttunement(IItemDefinition definition, TunnelType type) {
        definition.maybeStack(1).ifPresent(definitionStack -> this.addNewAttunement((ItemStack)definitionStack, type));
    }
}

