/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.fluids.container.ContainerFluidInterface;
import appeng.fluids.container.ContainerFluidTerminal;
import appeng.fluids.util.AEFluidStack;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;

public class PacketTargetFluidStack
extends AppEngPacket {
    private AEFluidStack stack;

    public PacketTargetFluidStack(ByteBuf stream) {
        try {
            this.stack = stream.readableBytes() > 0 ? (AEFluidStack)AEFluidStack.fromPacket(stream) : null;
        }
        catch (Exception ex) {
            AELog.debug(ex);
            this.stack = null;
        }
    }

    public PacketTargetFluidStack(AEFluidStack stack) {
        this.stack = stack;
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        if (stack != null) {
            try {
                stack.writeToPacket(data);
            }
            catch (Exception ex) {
                AELog.debug(ex);
            }
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        if (player.field_71070_bA instanceof ContainerFluidTerminal) {
            ((ContainerFluidTerminal)player.field_71070_bA).setTargetStack(this.stack);
        } else if (player.field_71070_bA instanceof ContainerFluidInterface) {
            ((ContainerFluidInterface)player.field_71070_bA).setTargetStack(this.stack);
        }
    }
}

