/*
 * Decompiled with CFR 0.152.
 */
package appeng.helpers;

import appeng.api.AEApi;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.container.ContainerNull;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;

public class PatternHelper
implements ICraftingPatternDetails,
Comparable<PatternHelper> {
    private static final int CRAFTING_GRID_DIMENSION = 3;
    private static final int CRAFTING_INPUT_LIMIT = 9;
    public static final int PROCESSING_INPUT_HEIGHT = 4;
    public static final int PROCESSING_INPUT_WIDTH = 4;
    public static final int PROCESSING_INPUT_LIMIT = 16;
    private static final int CRAFTING_OUTPUT_LIMIT = 1;
    public static final int PROCESSING_OUTPUT_LIMIT = 6;
    private final ItemStack patternItem;
    private final InventoryCrafting crafting;
    private final InventoryCrafting testFrame;
    private final ItemStack correctOutput;
    private final IRecipe standardRecipe;
    private final IAEItemStack[] condensedInputs;
    private final IAEItemStack[] condensedOutputs;
    private final IAEItemStack[] inputs;
    private final IAEItemStack[] outputs;
    private final Map<Integer, List<IAEItemStack>> substituteInputs;
    private final boolean isCrafting;
    private final boolean canSubstitute;
    private final Set<TestLookup> failCache = new HashSet<TestLookup>();
    private final Set<TestLookup> passCache = new HashSet<TestLookup>();
    private final IAEItemStack pattern;
    private int priority = 0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PatternHelper(ItemStack is, World w) {
        IAEItemStack[] gs;
        int x;
        NBTTagCompound encodedValue = is.func_77978_p();
        if (encodedValue == null) {
            throw new IllegalArgumentException("No pattern here!");
        }
        NBTTagList inTag = encodedValue.func_150295_c("in", 10);
        NBTTagList outTag = encodedValue.func_150295_c("out", 10);
        this.isCrafting = encodedValue.func_74767_n("crafting");
        this.crafting = new InventoryCrafting((Container)new ContainerNull(), this.isCrafting ? 3 : 4, this.isCrafting ? 3 : 4);
        this.testFrame = new InventoryCrafting((Container)new ContainerNull(), this.isCrafting ? 3 : 4, this.isCrafting ? 3 : 4);
        this.canSubstitute = this.isCrafting && encodedValue.func_74767_n("substitute");
        this.patternItem = is;
        this.pattern = AEItemStack.fromItemStack(is);
        ArrayList in = new ArrayList();
        ArrayList out = new ArrayList();
        for (x = 0; x < inTag.func_74745_c(); ++x) {
            NBTTagCompound ingredient = inTag.func_150305_b(x);
            gs = new ItemStack(ingredient);
            if (!ingredient.func_82582_d() && gs.func_190926_b()) {
                throw new IllegalArgumentException("No pattern here!");
            }
            this.crafting.func_70299_a(x, (ItemStack)gs);
            if (!(gs.func_190926_b() || this.isCrafting && gs.func_77942_o())) {
                this.markItemAs(x, (ItemStack)gs, TestStatus.ACCEPT);
            }
            in.add(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(gs));
            this.testFrame.func_70299_a(x, (ItemStack)gs);
        }
        if (this.isCrafting) {
            this.standardRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.crafting, (World)w);
            if (this.standardRecipe == null) throw new IllegalStateException("No pattern here!");
            this.correctOutput = this.standardRecipe.func_77572_b(this.crafting);
            out.add(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(this.correctOutput));
        } else {
            this.standardRecipe = null;
            this.correctOutput = ItemStack.field_190927_a;
            for (x = 0; x < outTag.func_74745_c(); ++x) {
                NBTTagCompound resultItemTag = outTag.func_150305_b(x);
                gs = new ItemStack(resultItemTag);
                if (!resultItemTag.func_82582_d() && gs.func_190926_b()) {
                    throw new IllegalArgumentException("No pattern here!");
                }
                if (gs.func_190926_b()) continue;
                out.add(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class).createStack(gs));
            }
        }
        int outputLength = out.size();
        this.inputs = in.toArray(new IAEItemStack[this.isCrafting ? 9 : 16]);
        this.outputs = out.toArray(new IAEItemStack[outputLength]);
        this.substituteInputs = new HashMap<Integer, List<IAEItemStack>>(9);
        HashMap<IAEItemStack, IAEItemStack> tmpOutputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : this.outputs) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)tmpOutputs.get(io);
            if (g == null) {
                tmpOutputs.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        HashMap<IAEItemStack, IAEItemStack> tmpInputs = new HashMap<IAEItemStack, IAEItemStack>();
        for (IAEItemStack io : this.inputs) {
            if (io == null) continue;
            IAEItemStack g = (IAEItemStack)tmpInputs.get(io);
            if (g == null) {
                tmpInputs.put(io, io.copy());
                continue;
            }
            g.add(io);
        }
        if (tmpOutputs.isEmpty() || tmpInputs.isEmpty()) {
            throw new IllegalStateException("No pattern here!");
        }
        this.condensedInputs = new IAEItemStack[tmpInputs.size()];
        int offset = 0;
        Iterator iterator = tmpInputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack io;
            this.condensedInputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
        offset = 0;
        this.condensedOutputs = new IAEItemStack[tmpOutputs.size()];
        iterator = tmpOutputs.values().iterator();
        while (iterator.hasNext()) {
            IAEItemStack io;
            this.condensedOutputs[offset] = io = (IAEItemStack)iterator.next();
            ++offset;
        }
    }

    private void markItemAs(int slotIndex, ItemStack i, TestStatus b) {
        if (b == TestStatus.TEST || i.func_77942_o()) {
            return;
        }
        (b == TestStatus.ACCEPT ? this.passCache : this.failCache).add(new TestLookup(slotIndex, i));
    }

    @Override
    public ItemStack getPattern() {
        return this.patternItem;
    }

    @Override
    public synchronized boolean isValidItemForSlot(int slotIndex, ItemStack i, World w) {
        if (!this.isCrafting) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        TestStatus result = this.getStatus(slotIndex, i);
        switch (result) {
            case ACCEPT: {
                return true;
            }
            case DECLINE: {
                return false;
            }
        }
        for (int x = 0; x < this.crafting.func_70302_i_(); ++x) {
            this.testFrame.func_70299_a(x, this.crafting.func_70301_a(x));
        }
        this.testFrame.func_70299_a(slotIndex, i);
        if (!(i.func_77973_b().func_77645_m() || Platform.isGTDamageableItem(i.func_77973_b()) || this.canSubstitute || slotIndex >= this.inputs.length || this.inputs[slotIndex].isSameType(i))) {
            this.markItemAs(slotIndex, i, TestStatus.DECLINE);
            return false;
        }
        if (this.standardRecipe.func_77569_a(this.testFrame, w)) {
            ItemStack testOutput = this.standardRecipe.func_77572_b(this.testFrame);
            if (Platform.itemComparisons().isSameItem(this.correctOutput, testOutput)) {
                this.testFrame.func_70299_a(slotIndex, this.crafting.func_70301_a(slotIndex));
                this.markItemAs(slotIndex, i, TestStatus.ACCEPT);
                return true;
            }
        }
        this.markItemAs(slotIndex, i, TestStatus.DECLINE);
        return false;
    }

    @Override
    public boolean isCraftable() {
        return this.isCrafting;
    }

    @Override
    public IAEItemStack[] getInputs() {
        return this.inputs;
    }

    @Override
    public IAEItemStack[] getCondensedInputs() {
        return this.condensedInputs;
    }

    @Override
    public IAEItemStack[] getCondensedOutputs() {
        return this.condensedOutputs;
    }

    @Override
    public IAEItemStack[] getOutputs() {
        return this.outputs;
    }

    @Override
    public boolean canSubstitute() {
        return this.canSubstitute;
    }

    @Override
    public List<IAEItemStack> getSubstituteInputs(int slot) {
        if (this.inputs[slot] == null) {
            return Collections.emptyList();
        }
        return this.substituteInputs.computeIfAbsent(slot, value -> {
            ItemStack[] matchingStacks = this.getRecipeIngredient(slot).func_193365_a();
            ArrayList<IAEItemStack> itemList = new ArrayList<IAEItemStack>(matchingStacks.length + 1);
            for (ItemStack matchingStack : matchingStacks) {
                itemList.add(AEItemStack.fromItemStack(matchingStack));
            }
            itemList.add(0, this.inputs[slot]);
            return itemList;
        });
    }

    private Ingredient getRecipeIngredient(int slot) {
        if (this.standardRecipe instanceof IShapedRecipe) {
            IShapedRecipe shapedRecipe = (IShapedRecipe)this.standardRecipe;
            return this.getShapedRecipeIngredient(slot, shapedRecipe.getRecipeWidth());
        }
        return this.getShapelessRecipeIngredient(slot);
    }

    private Ingredient getShapedRecipeIngredient(int slot, int recipeWidth) {
        int topOffset = 0;
        if (this.inputs[0] == null && this.inputs[1] == null && this.inputs[2] == null) {
            ++topOffset;
            if (this.inputs[3] == null && this.inputs[4] == null && this.inputs[5] == null) {
                ++topOffset;
            }
        }
        int leftOffset = 0;
        if (this.inputs[0] == null && this.inputs[3] == null && this.inputs[6] == null) {
            ++leftOffset;
            if (this.inputs[1] == null && this.inputs[4] == null && this.inputs[7] == null) {
                ++leftOffset;
            }
        }
        int slotX = slot % 3 - leftOffset;
        int slotY = slot / 3 - topOffset;
        int ingredientIndex = slotY * recipeWidth + slotX;
        NonNullList ingredients = this.standardRecipe.func_192400_c();
        if (ingredientIndex < 0 || ingredientIndex > ingredients.size()) {
            return Ingredient.field_193370_a;
        }
        return (Ingredient)ingredients.get(ingredientIndex);
    }

    private Ingredient getShapelessRecipeIngredient(int slot) {
        int ingredientIndex = 0;
        for (int i = 0; i < slot; ++i) {
            if (this.inputs[i] == null) continue;
            ++ingredientIndex;
        }
        NonNullList ingredients = this.standardRecipe.func_192400_c();
        if (ingredientIndex < ingredients.size()) {
            return (Ingredient)ingredients.get(ingredientIndex);
        }
        return Ingredient.field_193370_a;
    }

    @Override
    public ItemStack getOutput(InventoryCrafting craftingInv, World w) {
        if (!this.isCrafting) {
            throw new IllegalStateException("Only crafting recipes supported.");
        }
        for (int x = 0; x < craftingInv.func_70302_i_(); ++x) {
            if (this.isValidItemForSlot(x, craftingInv.func_70301_a(x), w)) continue;
            return ItemStack.field_190927_a;
        }
        if (this.outputs != null && this.outputs.length > 0) {
            return this.outputs[0].createItemStack();
        }
        return ItemStack.field_190927_a;
    }

    private TestStatus getStatus(int slotIndex, ItemStack i) {
        if (this.crafting.func_70301_a(slotIndex).func_190926_b()) {
            return i.func_190926_b() ? TestStatus.ACCEPT : TestStatus.DECLINE;
        }
        if (i.func_190926_b()) {
            return TestStatus.DECLINE;
        }
        if (i.func_77942_o()) {
            return TestStatus.TEST;
        }
        if (this.passCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.ACCEPT;
        }
        if (this.failCache.contains(new TestLookup(slotIndex, i))) {
            return TestStatus.DECLINE;
        }
        return TestStatus.TEST;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(PatternHelper o) {
        return Integer.compare(o.priority, this.priority);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternHelper other = (PatternHelper)obj;
        if (this.pattern != null && other.pattern != null) {
            return this.pattern.equals(other.pattern);
        }
        return false;
    }

    private static final class TestLookup {
        private final int slot;
        private final int ref;
        private final int hash;

        public TestLookup(int slot, ItemStack i) {
            this(slot, i.func_77973_b(), i.func_77952_i());
        }

        public TestLookup(int slot, Item item, int dmg) {
            this.slot = slot;
            this.ref = dmg << 16 | Item.func_150891_b((Item)item) & 0xFFFF;
            int offset = 3 * slot;
            this.hash = this.ref << offset | this.ref >> offset + 32;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            boolean equality;
            if (obj instanceof TestLookup) {
                TestLookup b = (TestLookup)obj;
                equality = b.slot == this.slot && b.ref == this.ref;
            } else {
                equality = false;
            }
            return equality;
        }
    }

    private static enum TestStatus {
        ACCEPT,
        DECLINE,
        TEST;

    }
}

