/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.IMachineSet;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.me.GridCacheWrapper;
import appeng.me.GridNode;
import appeng.me.GridNodeCollection;
import appeng.me.GridStorage;
import appeng.me.MachineSet;
import appeng.me.NetworkEventBus;
import appeng.util.ReadOnlyCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Grid
implements IGrid {
    private final NetworkEventBus eventBus = new NetworkEventBus();
    private final Map<Class<? extends IGridHost>, MachineSet> machines = new HashMap<Class<? extends IGridHost>, MachineSet>();
    private final Map<Class<? extends IGridCache>, GridCacheWrapper> caches = new HashMap<Class<? extends IGridCache>, GridCacheWrapper>();
    private GridNode pivot;
    private int priority;
    private GridStorage myStorage;

    public Grid(GridNode center) {
        this.pivot = center;
        Map<Class<? extends IGridCache>, IGridCache> myCaches = AEApi.instance().registries().gridCache().createCacheInstance(this);
        for (Map.Entry<Class<? extends IGridCache>, IGridCache> c : myCaches.entrySet()) {
            Class<? extends IGridCache> key = c.getKey();
            IGridCache value = c.getValue();
            Class<?> valueClass = value.getClass();
            this.eventBus.readClass(key, valueClass);
            this.caches.put(key, new GridCacheWrapper(value));
        }
        this.postEvent(new MENetworkPostCacheConstruction());
        TickHandler.INSTANCE.addNetwork(this);
        center.setGrid(this);
    }

    int getPriority() {
        return this.priority;
    }

    IGridStorage getMyStorage() {
        return this.myStorage;
    }

    Map<Class<? extends IGridCache>, GridCacheWrapper> getCaches() {
        return this.caches;
    }

    public Iterable<Class<? extends IGridHost>> getMachineClasses() {
        return this.machines.keySet();
    }

    int size() {
        int out = 0;
        for (Collection collection : this.machines.values()) {
            out += collection.size();
        }
        return out;
    }

    void remove(GridNode gridNode) {
        for (IGridCache iGridCache : this.caches.values()) {
            IGridHost machine = gridNode.getMachine();
            iGridCache.removeNode(gridNode, machine);
        }
        Class<? extends IGridHost> machineClass = gridNode.getMachineClass();
        Set set = this.machines.get(machineClass);
        if (set != null) {
            set.remove(gridNode);
        }
        gridNode.setGridStorage(null);
        if (this.pivot == gridNode) {
            Iterator n = this.getNodes().iterator();
            if (n.hasNext()) {
                this.pivot = (GridNode)n.next();
            } else {
                this.pivot = null;
                TickHandler.INSTANCE.removeNetwork(this);
                this.myStorage.remove();
            }
        }
    }

    void add(GridNode gridNode) {
        Class<? extends IGridHost> mClass = gridNode.getMachineClass();
        MachineSet nodes = this.machines.get(mClass);
        if (nodes == null) {
            nodes = new MachineSet(mClass);
            this.machines.put(mClass, nodes);
            this.eventBus.readClass(mClass, mClass);
        }
        if (gridNode.getGridStorage() != null) {
            GridStorage gs = gridNode.getGridStorage();
            IGrid iGrid = gs.getGrid();
            if (iGrid == null) {
                this.myStorage = gs;
                this.myStorage.setGrid(this);
                for (IGridCache iGridCache : this.caches.values()) {
                    iGridCache.onJoin(this.myStorage);
                }
            } else if (iGrid != this) {
                if (this.myStorage == null) {
                    this.myStorage = WorldData.instance().storageData().getNewGridStorage();
                    this.myStorage.setGrid(this);
                }
                GridStorage tmp = new GridStorage();
                if (!gs.hasDivided(this.myStorage)) {
                    gs.addDivided(this.myStorage);
                    for (IGridCache iGridCache : ((Grid)iGrid).caches.values()) {
                        iGridCache.onSplit(tmp);
                    }
                    for (IGridCache iGridCache : this.caches.values()) {
                        iGridCache.onJoin(tmp);
                    }
                }
            }
        } else if (this.myStorage == null) {
            this.myStorage = WorldData.instance().storageData().getNewGridStorage();
            this.myStorage.setGrid(this);
        }
        gridNode.setGridStorage(this.myStorage);
        nodes.add(gridNode);
        for (IGridCache iGridCache : this.caches.values()) {
            IGridHost machine = gridNode.getMachine();
            iGridCache.addNode(gridNode, machine);
        }
        gridNode.getGridProxy().gridChanged();
    }

    @Override
    public <C extends IGridCache> C getCache(Class<? extends IGridCache> iface) {
        return (C)this.caches.get(iface).getCache();
    }

    @Override
    public MENetworkEvent postEvent(MENetworkEvent ev) {
        MENetworkEvent ret = this.eventBus.postEvent(this, ev);
        return ret;
    }

    @Override
    public MENetworkEvent postEventTo(IGridNode node, MENetworkEvent ev) {
        return this.eventBus.postEventTo(this, (GridNode)node, ev);
    }

    @Override
    public IReadOnlyCollection<Class<? extends IGridHost>> getMachinesClasses() {
        Set<Class<? extends IGridHost>> machineKeys = this.machines.keySet();
        return new ReadOnlyCollection<Class<? extends IGridHost>>(machineKeys);
    }

    @Override
    public IMachineSet getMachines(Class<? extends IGridHost> c) {
        MachineSet s = this.machines.get(c);
        if (s == null) {
            return new MachineSet(c);
        }
        return s;
    }

    @Override
    public IReadOnlyCollection<IGridNode> getNodes() {
        return new GridNodeCollection(this.machines);
    }

    @Override
    public boolean isEmpty() {
        return this.pivot == null;
    }

    @Override
    public IGridNode getPivot() {
        return this.pivot;
    }

    void setPivot(GridNode pivot) {
        this.pivot = pivot;
    }

    public void update() {
        for (IGridCache iGridCache : this.caches.values()) {
            if (this.pivot == null) continue;
            iGridCache.onUpdateTick();
        }
    }

    void saveState() {
        for (IGridCache iGridCache : this.caches.values()) {
            iGridCache.populateGridStorage(this.myStorage);
        }
    }

    public void setImportantFlag(int i, boolean publicHasPower) {
        int flag = 1 << i;
        this.priority = this.priority & ~flag | (publicHasPower ? flag : 0);
    }
}

