/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.FailedConnectionException;
import appeng.api.exceptions.SecurityConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridCache;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridConnectionVisitor;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridVisitor;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.AEColor;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.AELog;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.me.Grid;
import appeng.me.GridConnection;
import appeng.me.GridPropagator;
import appeng.me.GridSplitDetector;
import appeng.me.GridStorage;
import appeng.me.pathfinding.IPathItem;
import appeng.util.IWorldCallable;
import appeng.util.ReadOnlyCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GridNode
implements IGridNode,
IPathItem {
    private static final MENetworkChannelsChanged EVENT = new MENetworkChannelsChanged();
    private static final int[] CHANNEL_COUNT = new int[]{0, 8, 32};
    private final List<IGridConnection> connections = new ArrayList<IGridConnection>();
    private final IGridBlock gridProxy;
    private double previousDraw = 0.0;
    private long lastSecurityKey = -1L;
    private int playerID = -1;
    private GridStorage myStorage = null;
    private Grid myGrid;
    private Object visitorIterationNumber = null;
    private int compressedData = 0;
    private int usedChannels = 0;
    private int lastUsedChannels = 0;

    public GridNode(IGridBlock what) {
        this.gridProxy = what;
    }

    IGridBlock getGridProxy() {
        return this.gridProxy;
    }

    Grid getMyGrid() {
        return this.myGrid;
    }

    public int usedChannels() {
        return this.lastUsedChannels;
    }

    Class<? extends IGridHost> getMachineClass() {
        return this.getMachine().getClass();
    }

    void addConnection(IGridConnection gridConnection) {
        this.connections.add(gridConnection);
        if (gridConnection.hasDirection()) {
            this.gridProxy.onGridNotification(GridNotification.CONNECTIONS_CHANGED);
        }
        GridNode gn = this;
        Collections.sort(this.connections, new ConnectionComparator(gn));
    }

    void removeConnection(IGridConnection gridConnection) {
        this.connections.remove(gridConnection);
        if (gridConnection.hasDirection()) {
            this.gridProxy.onGridNotification(GridNotification.CONNECTIONS_CHANGED);
        }
    }

    boolean hasConnection(IGridNode otherSide) {
        for (IGridConnection gc : this.connections) {
            if (gc.a() != otherSide && gc.b() != otherSide) continue;
            return true;
        }
        return false;
    }

    void validateGrid() {
        GridSplitDetector gsd = new GridSplitDetector(this.getInternalGrid().getPivot());
        this.beginVisit(gsd);
        if (!gsd.isPivotFound()) {
            GridPropagator gp = new GridPropagator(new Grid(this));
            this.beginVisit(gp);
        }
    }

    public Grid getInternalGrid() {
        if (this.myGrid == null) {
            this.myGrid = new Grid(this);
        }
        return this.myGrid;
    }

    @Override
    public void beginVisit(IGridVisitor g) {
        Object tracker = new Object();
        ArrayDeque<GridNode> nextRun = new ArrayDeque<GridNode>();
        nextRun.add(this);
        this.visitorIterationNumber = tracker;
        if (g instanceof IGridConnectionVisitor) {
            ArrayDeque<IGridConnection> nextConn = new ArrayDeque<IGridConnection>();
            IGridConnectionVisitor gcv = (IGridConnectionVisitor)g;
            while (!nextRun.isEmpty()) {
                while (!nextConn.isEmpty()) {
                    gcv.visitConnection((IGridConnection)nextConn.poll());
                }
                ArrayDeque<GridNode> thisRun = nextRun;
                nextRun = new ArrayDeque();
                for (GridNode n : thisRun) {
                    n.visitorConnection(tracker, g, nextRun, nextConn);
                }
            }
        } else {
            while (!nextRun.isEmpty()) {
                ArrayDeque<GridNode> thisRun = nextRun;
                nextRun = new ArrayDeque();
                for (GridNode n : thisRun) {
                    n.visitorNode(tracker, g, nextRun);
                }
            }
        }
    }

    @Override
    public void updateState() {
        EnumSet<GridFlags> set = this.gridProxy.getFlags();
        this.compressedData = set.contains((Object)GridFlags.CANNOT_CARRY) ? 0 : (set.contains((Object)GridFlags.DENSE_CAPACITY) ? 2 : 1);
        this.compressedData |= this.gridProxy.getGridColor().ordinal() << 3;
        for (EnumFacing dir : this.gridProxy.getConnectableSides()) {
            this.compressedData |= 1 << dir.ordinal() + 8;
        }
        this.findConnections();
        this.getInternalGrid();
    }

    @Override
    public IGridHost getMachine() {
        return this.gridProxy.getMachine();
    }

    @Override
    public IGrid getGrid() {
        return this.myGrid;
    }

    void setGrid(Grid grid) {
        if (this.myGrid == grid) {
            return;
        }
        if (this.myGrid != null) {
            this.myGrid.remove(this);
            if (this.myGrid.isEmpty()) {
                this.myGrid.saveState();
                for (IGridCache iGridCache : grid.getCaches().values()) {
                    iGridCache.onJoin(this.myGrid.getMyStorage());
                }
            }
        }
        this.myGrid = grid;
        this.myGrid.add(this);
    }

    @Override
    public void destroy() {
        while (!this.connections.isEmpty()) {
            if (this.connections.size() == 1) {
                this.setGridStorage(null);
            }
            IGridConnection c = this.connections.listIterator().next();
            GridNode otherSide = (GridNode)c.getOtherSide(this);
            otherSide.getInternalGrid().setPivot(otherSide);
            c.destroy();
        }
        if (this.myGrid != null) {
            this.myGrid.remove(this);
        }
    }

    @Override
    public World getWorld() {
        return this.gridProxy.getLocation().getWorld();
    }

    @Override
    public EnumSet<AEPartLocation> getConnectedSides() {
        EnumSet<AEPartLocation> set = EnumSet.noneOf(AEPartLocation.class);
        for (IGridConnection gc : this.connections) {
            set.add(gc.getDirection(this));
        }
        return set;
    }

    @Override
    public IReadOnlyCollection<IGridConnection> getConnections() {
        return new ReadOnlyCollection<IGridConnection>(this.connections);
    }

    @Override
    public IGridBlock getGridBlock() {
        return this.gridProxy;
    }

    @Override
    public boolean isActive() {
        IGrid g = this.getGrid();
        if (g != null) {
            IPathingGrid pg = (IPathingGrid)g.getCache(IPathingGrid.class);
            IEnergyGrid eg = (IEnergyGrid)g.getCache(IEnergyGrid.class);
            return eg.isNetworkPowered() && !pg.isNetworkBooting() && this.meetsChannelRequirements();
        }
        return false;
    }

    @Override
    public void loadFromNBT(String name, NBTTagCompound nodeData) {
        if (this.myGrid != null) {
            throw new IllegalStateException("Loading data after part of a grid, this is invalid.");
        }
        if (nodeData.func_150297_b(name, 10)) {
            NBTTagCompound node = nodeData.func_74775_l(name);
            this.playerID = node.func_74762_e("p");
            this.setLastSecurityKey(node.func_74763_f("k"));
            long storageID = node.func_74763_f("g");
            GridStorage gridStorage = WorldData.instance().storageData().getGridStorage(storageID);
            this.setGridStorage(gridStorage);
        } else {
            this.playerID = -1;
            this.setLastSecurityKey(-1L);
            this.setGridStorage(null);
        }
    }

    @Override
    public void saveToNBT(String name, NBTTagCompound nodeData) {
        if (this.myStorage != null) {
            NBTTagCompound node = new NBTTagCompound();
            node.func_74768_a("p", this.playerID);
            node.func_74772_a("k", this.getLastSecurityKey());
            node.func_74772_a("g", this.myStorage.getID());
            nodeData.func_74782_a(name, (NBTBase)node);
        } else {
            nodeData.func_82580_o(name);
        }
    }

    @Override
    public boolean meetsChannelRequirements() {
        return !this.gridProxy.getFlags().contains((Object)GridFlags.REQUIRE_CHANNEL) || this.getUsedChannels() > 0;
    }

    @Override
    public boolean hasFlag(GridFlags flag) {
        return this.gridProxy.getFlags().contains((Object)flag);
    }

    @Override
    public int getPlayerID() {
        return this.playerID;
    }

    @Override
    public void setPlayerID(int playerID) {
        if (playerID >= 0) {
            this.playerID = playerID;
        }
    }

    private int getUsedChannels() {
        return this.usedChannels;
    }

    private void findConnections() {
        if (!this.gridProxy.isWorldAccessible()) {
            return;
        }
        EnumSet<AEPartLocation> newSecurityConnections = EnumSet.noneOf(AEPartLocation.class);
        DimensionalCoord dc = this.gridProxy.getLocation();
        for (AEPartLocation f : AEPartLocation.SIDE_LOCATIONS) {
            GridNode node;
            IGridHost te = this.findGridHost(dc.getWorld(), dc.x + f.xOffset, dc.y + f.yOffset, dc.z + f.zOffset);
            if (te == null || (node = (GridNode)te.getGridNode(f.getOpposite())) == null) continue;
            boolean isValidConnection = this.canConnect(node, f) && node.canConnect(this, f.getOpposite());
            IGridConnection con = null;
            for (IGridConnection c : this.getConnections()) {
                if (c.getDirection(this) != f) continue;
                con = c;
                break;
            }
            if (con != null) {
                IGridNode os = con.getOtherSide(this);
                if (os == node) {
                    if (isValidConnection) continue;
                    con.destroy();
                    continue;
                }
                con.destroy();
                continue;
            }
            if (!isValidConnection) continue;
            if (node.getLastSecurityKey() != -1L) {
                newSecurityConnections.add(f);
                continue;
            }
            try {
                GridConnection.create(node, this, f.getOpposite());
            }
            catch (SecurityConnectionException e) {
                AELog.debug(e);
                TickHandler.INSTANCE.addCallable(node.getWorld(), new MachineSecurityBreak(this));
                return;
            }
            catch (FailedConnectionException e) {
                AELog.debug(e);
                return;
            }
        }
        for (AEPartLocation f : newSecurityConnections) {
            GridNode node;
            IGridHost te = this.findGridHost(dc.getWorld(), dc.x + f.xOffset, dc.y + f.yOffset, dc.z + f.zOffset);
            if (te == null || (node = (GridNode)te.getGridNode(f.getOpposite())) == null) continue;
            try {
                GridConnection.create(node, this, f.getOpposite());
            }
            catch (SecurityConnectionException e) {
                AELog.debug(e);
                TickHandler.INSTANCE.addCallable(node.getWorld(), new MachineSecurityBreak(this));
                return;
            }
            catch (FailedConnectionException e) {
                AELog.debug(e);
                return;
            }
        }
    }

    private IGridHost findGridHost(World world, int x, int y, int z) {
        TileEntity te;
        BlockPos pos = new BlockPos(x, y, z);
        if (world.func_175667_e(pos) && (te = world.func_175625_s(pos)) instanceof IGridHost) {
            return (IGridHost)te;
        }
        return null;
    }

    private boolean canConnect(GridNode from, AEPartLocation dir) {
        if (!this.isValidDirection(dir)) {
            return false;
        }
        return from.getColor().matches(this.getColor());
    }

    private boolean isValidDirection(AEPartLocation dir) {
        return (this.compressedData & 1 << 8 + dir.ordinal()) > 0;
    }

    private AEColor getColor() {
        return AEColor.values()[this.compressedData >> 3 & 0x1F];
    }

    private void visitorConnection(Object tracker, IGridVisitor g, Deque<GridNode> nextRun, Deque<IGridConnection> nextConnections) {
        if (g.visitNode(this)) {
            for (IGridConnection gc : this.getConnections()) {
                GridNode gn = (GridNode)gc.getOtherSide(this);
                GridConnection gcc = (GridConnection)gc;
                if (gcc.getVisitorIterationNumber() != tracker) {
                    gcc.setVisitorIterationNumber(tracker);
                    nextConnections.add(gc);
                }
                if (tracker == gn.visitorIterationNumber) continue;
                gn.visitorIterationNumber = tracker;
                nextRun.add(gn);
            }
        }
    }

    private void visitorNode(Object tracker, IGridVisitor g, Deque<GridNode> nextRun) {
        if (g.visitNode(this)) {
            for (IGridConnection gc : this.getConnections()) {
                GridNode gn = (GridNode)gc.getOtherSide(this);
                if (tracker == gn.visitorIterationNumber) continue;
                gn.visitorIterationNumber = tracker;
                nextRun.add(gn);
            }
        }
    }

    GridStorage getGridStorage() {
        return this.myStorage;
    }

    void setGridStorage(GridStorage s) {
        this.myStorage = s;
        this.usedChannels = 0;
        this.lastUsedChannels = 0;
    }

    @Override
    public IPathItem getControllerRoute() {
        if (this.connections.isEmpty() || this.getFlags().contains((Object)GridFlags.CANNOT_CARRY)) {
            return null;
        }
        return (IPathItem)((Object)this.connections.get(0));
    }

    @Override
    public void setControllerRoute(IPathItem fast, boolean zeroOut) {
        int idx;
        if (zeroOut) {
            this.usedChannels = 0;
        }
        if ((idx = this.connections.indexOf((IGridConnection)((Object)fast))) > 0) {
            this.connections.remove((IGridConnection)((Object)fast));
            this.connections.add(0, (IGridConnection)((Object)fast));
        }
    }

    @Override
    public boolean canSupportMoreChannels() {
        return this.getUsedChannels() < this.getMaxChannels();
    }

    private int getMaxChannels() {
        return CHANNEL_COUNT[this.compressedData & 3];
    }

    @Override
    public IReadOnlyCollection<IPathItem> getPossibleOptions() {
        return this.getConnections();
    }

    @Override
    public void incrementChannelCount(int usedChannels) {
        this.usedChannels += usedChannels;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return this.gridProxy.getFlags();
    }

    @Override
    public void finalizeChannels() {
        if (this.getFlags().contains((Object)GridFlags.CANNOT_CARRY)) {
            return;
        }
        if (this.getLastUsedChannels() != this.getUsedChannels()) {
            this.lastUsedChannels = this.usedChannels;
            if (this.getInternalGrid() != null) {
                this.getInternalGrid().postEventTo(this, EVENT);
            }
        }
    }

    private int getLastUsedChannels() {
        return this.lastUsedChannels;
    }

    public long getLastSecurityKey() {
        return this.lastSecurityKey;
    }

    public void setLastSecurityKey(long lastSecurityKey) {
        this.lastSecurityKey = lastSecurityKey;
    }

    public double getPreviousDraw() {
        return this.previousDraw;
    }

    public void setPreviousDraw(double previousDraw) {
        this.previousDraw = previousDraw;
    }

    private static class ConnectionComparator
    implements Comparator<IGridConnection> {
        private final IGridNode gn;

        public ConnectionComparator(IGridNode gn) {
            this.gn = gn;
        }

        @Override
        public int compare(IGridConnection o1, IGridConnection o2) {
            boolean preferredB;
            boolean preferredA = o1.getOtherSide(this.gn).hasFlag(GridFlags.PREFERRED);
            return preferredA == (preferredB = o2.getOtherSide(this.gn).hasFlag(GridFlags.PREFERRED)) ? 0 : (preferredA ? -1 : 1);
        }
    }

    private static class MachineSecurityBreak
    implements IWorldCallable<Void> {
        private final GridNode node;

        public MachineSecurityBreak(GridNode node) {
            this.node = node;
        }

        @Override
        public Void call(World world) throws Exception {
            this.node.getMachine().securityBreak();
            return null;
        }
    }
}

