/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.cache;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.energy.IAEPowerStorage;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.networking.energy.IEnergyWatcher;
import appeng.api.networking.energy.IEnergyWatcherHost;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPostCacheConstruction;
import appeng.api.networking.events.MENetworkPowerIdleChange;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.events.MENetworkPowerStorage;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.me.Grid;
import appeng.me.GridNode;
import appeng.me.cache.PathGridCache;
import appeng.me.energy.EnergyThreshold;
import appeng.me.energy.EnergyWatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Set;

public class EnergyGridCache
implements IEnergyGrid {
    private static final double MAX_BUFFER_STORAGE = 800.0;
    private static final Comparator<IEnergyGridProvider> COMPARATOR_HIGHEST_AMOUNT_STORED_FIRST = (o1, o2) -> Double.compare(o2.getProviderStoredEnergy(), o1.getProviderStoredEnergy());
    private static final Comparator<IEnergyGridProvider> COMPARATOR_LOWEST_PERCENTAGE_FIRST = (o1, o2) -> {
        double percent1 = (o1.getProviderStoredEnergy() + 1.0) / (o1.getProviderMaxEnergy() + 1.0);
        double percent2 = (o2.getProviderStoredEnergy() + 1.0) / (o2.getProviderMaxEnergy() + 1.0);
        return Double.compare(percent1, percent2);
    };
    private final NavigableSet<EnergyThreshold> interests = Sets.newTreeSet();
    private final double averageLength = 40.0;
    private final Set<IAEPowerStorage> providers = new LinkedHashSet<IAEPowerStorage>();
    private boolean ongoingExtractOperation = false;
    private final Set<IAEPowerStorage> requesters = new LinkedHashSet<IAEPowerStorage>();
    private boolean ongoingInjectOperation = false;
    private final Multiset<IEnergyGridProvider> energyGridProviders = HashMultiset.create();
    private final IGrid myGrid;
    private final HashMap<IGridNode, IEnergyWatcher> watchers = new HashMap();
    private int availableTicksSinceUpdate = 0;
    private double globalAvailablePower = 0.0;
    private double globalMaxPower = 800.0;
    private double drainPerTick = 0.0;
    private double avgDrainPerTick = 0.0;
    private double avgInjectionPerTick = 0.0;
    private double tickDrainPerTick = 0.0;
    private double tickInjectionPerTick = 0.0;
    private boolean publicHasPower = false;
    private boolean hasPower = true;
    private long ticksSinceHasPowerChange = 900L;
    private PathGridCache pgc;
    private double lastStoredPower = -1.0;
    private final GridPowerStorage localStorage = new GridPowerStorage();
    private Set<IAEPowerStorage> providerToRemove = new HashSet<IAEPowerStorage>();
    private Set<IAEPowerStorage> requesterToRemove = new HashSet<IAEPowerStorage>();
    private Set<IAEPowerStorage> providersToAdd = new HashSet<IAEPowerStorage>();
    private Set<IAEPowerStorage> requesterToAdd = new HashSet<IAEPowerStorage>();

    public EnergyGridCache(IGrid g) {
        this.myGrid = g;
        this.requesters.add(this.localStorage);
        this.providers.add(this.localStorage);
    }

    @MENetworkEventSubscribe
    public void postInit(MENetworkPostCacheConstruction pcc) {
        this.pgc = (PathGridCache)this.myGrid.getCache(IPathingGrid.class);
    }

    @MENetworkEventSubscribe
    public void nodeIdlePowerChangeHandler(MENetworkPowerIdleChange ev) {
        GridNode node = (GridNode)ev.node;
        IGridBlock gb = node.getGridBlock();
        double newDraw = gb.getIdlePowerUsage();
        double diffDraw = newDraw - node.getPreviousDraw();
        node.setPreviousDraw(newDraw);
        this.drainPerTick += diffDraw;
    }

    @MENetworkEventSubscribe
    public void storagePowerChangeHandler(MENetworkPowerStorage ev) {
        if (ev.storage.isAEPublicPowerStorage()) {
            if (ev.type == MENetworkPowerStorage.PowerEventType.PROVIDE_POWER) {
                if (ev.storage.getPowerFlow() != AccessRestriction.WRITE) {
                    if (!this.ongoingExtractOperation) {
                        this.addProvider(ev.storage);
                    } else {
                        this.providersToAdd.add(ev.storage);
                    }
                }
            } else if (ev.type == MENetworkPowerStorage.PowerEventType.REQUEST_POWER && ev.storage.getPowerFlow() != AccessRestriction.READ) {
                if (!this.ongoingInjectOperation) {
                    this.addRequester(ev.storage);
                } else {
                    this.requesterToAdd.add(ev.storage);
                }
            }
        } else {
            new RuntimeException("Attempt to ask the IEnergyGrid to charge a non public energy store.").printStackTrace();
        }
    }

    @Override
    public void onUpdateTick() {
        if (!this.interests.isEmpty()) {
            double oldPower = this.lastStoredPower;
            this.lastStoredPower = this.getStoredPower();
            EnergyThreshold low = new EnergyThreshold(Math.min(oldPower, this.lastStoredPower), Integer.MIN_VALUE);
            EnergyThreshold high = new EnergyThreshold(Math.max(oldPower, this.lastStoredPower), Integer.MAX_VALUE);
            for (EnergyThreshold th : this.interests.subSet(low, true, high, true)) {
                ((EnergyWatcher)th.getEnergyWatcher()).post(this);
            }
        }
        this.avgDrainPerTick *= (this.averageLength - 1.0) / this.averageLength;
        this.avgInjectionPerTick *= (this.averageLength - 1.0) / this.averageLength;
        this.avgDrainPerTick += this.tickDrainPerTick / this.averageLength;
        this.avgInjectionPerTick += this.tickInjectionPerTick / this.averageLength;
        this.tickDrainPerTick = 0.0;
        this.tickInjectionPerTick = 0.0;
        boolean currentlyHasPower = false;
        if (this.drainPerTick > 1.0E-4) {
            double drained = this.extractAEPower(this.getIdlePowerUsage(), Actionable.MODULATE, PowerMultiplier.CONFIG);
            currentlyHasPower = drained >= this.drainPerTick - 0.001;
        } else {
            boolean bl = currentlyHasPower = this.extractAEPower(0.1, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 0.0;
        }
        this.ticksSinceHasPowerChange = currentlyHasPower == this.hasPower ? ++this.ticksSinceHasPowerChange : 0L;
        this.hasPower = currentlyHasPower;
        if (this.hasPower && this.ticksSinceHasPowerChange > 30L) {
            this.publicPowerState(true, this.myGrid);
        } else if (!this.hasPower) {
            this.publicPowerState(false, this.myGrid);
        }
        ++this.availableTicksSinceUpdate;
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, PowerMultiplier pm) {
        double toExtract = pm.multiply(amt);
        PriorityQueue<IEnergyGridProvider> toVisit = new PriorityQueue<IEnergyGridProvider>(COMPARATOR_HIGHEST_AMOUNT_STORED_FIRST);
        HashSet<IEnergyGridProvider> visited = new HashSet<IEnergyGridProvider>();
        double extracted = 0.0;
        toVisit.add(this);
        while (!toVisit.isEmpty() && extracted < toExtract) {
            IEnergyGridProvider next = (IEnergyGridProvider)toVisit.poll();
            visited.add(next);
            extracted += next.extractProviderPower(toExtract - extracted, mode);
            for (IEnergyGridProvider iEnergyGridProvider : next.providers()) {
                if (visited.contains(iEnergyGridProvider)) continue;
                toVisit.add(iEnergyGridProvider);
            }
        }
        return pm.divide(extracted);
    }

    @Override
    public double getIdlePowerUsage() {
        return this.drainPerTick + this.pgc.getChannelPowerUsage();
    }

    private void publicPowerState(boolean newState, IGrid grid) {
        if (this.publicHasPower == newState) {
            return;
        }
        this.publicHasPower = newState;
        ((Grid)this.myGrid).setImportantFlag(0, this.publicHasPower);
        grid.postEvent(new MENetworkPowerStatusChange());
    }

    private void refreshPower() {
        this.availableTicksSinceUpdate = 0;
        this.globalAvailablePower = 0.0;
        for (IAEPowerStorage p : this.providers) {
            this.globalAvailablePower += p.getAECurrentPower();
        }
    }

    @Override
    public Collection<IEnergyGridProvider> providers() {
        return this.energyGridProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double extractProviderPower(double amt, Actionable mode) {
        double extractedPower = 0.0;
        this.providers.addAll(this.providersToAdd);
        this.providersToAdd.clear();
        this.providers.removeIf(this.providerToRemove::contains);
        this.providerToRemove.clear();
        Iterator<IAEPowerStorage> it = this.providers.iterator();
        this.ongoingExtractOperation = true;
        boolean ls = false;
        try {
            while (extractedPower < amt && it.hasNext()) {
                IAEPowerStorage node = it.next();
                if (node != null) {
                    if (node == this.localStorage && mode == Actionable.MODULATE) {
                        ls = true;
                        continue;
                    }
                    double req = amt - extractedPower;
                    double newPower = node.extractAEPower(req, mode, PowerMultiplier.ONE);
                    extractedPower += newPower;
                    if (!(newPower < req) || mode != Actionable.MODULATE) continue;
                    it.remove();
                    continue;
                }
                it.remove();
            }
        }
        finally {
            this.ongoingExtractOperation = false;
            if (ls && extractedPower < amt) {
                double req = amt - extractedPower;
                double newPower = this.localStorage.extractAEPower(req, mode, PowerMultiplier.ONE);
                extractedPower += newPower;
                if (newPower < req) {
                    this.providers.remove(this.localStorage);
                }
            }
        }
        double result = Math.min(extractedPower, amt);
        if (mode == Actionable.MODULATE) {
            if (extractedPower > amt) {
                this.localStorage.addCurrentAEPower(extractedPower - amt);
            }
            this.globalAvailablePower -= result;
            this.tickDrainPerTick += result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double injectProviderPower(double amt, Actionable mode) {
        double originalAmount = amt;
        this.requesters.addAll(this.requesterToAdd);
        this.requesterToAdd.clear();
        this.requesters.removeIf(this.requesterToRemove::contains);
        this.requesterToRemove.clear();
        Iterator<IAEPowerStorage> it = this.requesters.iterator();
        this.ongoingInjectOperation = true;
        try {
            while (amt > 0.0 && it.hasNext()) {
                IAEPowerStorage node = it.next();
                if (node != null) {
                    if (!((amt = node.injectAEPower(amt, mode)) > 0.0) || mode != Actionable.MODULATE) continue;
                    it.remove();
                    continue;
                }
                it.remove();
            }
        }
        finally {
            this.ongoingInjectOperation = false;
        }
        double overflow = Math.max(0.0, amt);
        if (mode == Actionable.MODULATE) {
            this.tickInjectionPerTick += originalAmount - overflow;
        }
        return overflow;
    }

    @Override
    public double getProviderEnergyDemand(double maxRequired) {
        double required = 0.0;
        Iterator<IAEPowerStorage> it = this.requesters.iterator();
        while (required < maxRequired && it.hasNext()) {
            IAEPowerStorage node = it.next();
            if (node.getPowerFlow() == AccessRestriction.READ) continue;
            required += Math.max(0.0, node.getAEMaxPower() - node.getAECurrentPower());
        }
        return required;
    }

    @Override
    public double getAvgPowerUsage() {
        return this.avgDrainPerTick;
    }

    @Override
    public double getAvgPowerInjection() {
        return this.avgInjectionPerTick;
    }

    @Override
    public boolean isNetworkPowered() {
        return this.publicHasPower;
    }

    @Override
    public double injectPower(double amt, Actionable mode) {
        PriorityQueue<IEnergyGridProvider> toVisit = new PriorityQueue<IEnergyGridProvider>(COMPARATOR_LOWEST_PERCENTAGE_FIRST);
        HashSet<IEnergyGridProvider> visited = new HashSet<IEnergyGridProvider>();
        toVisit.add(this);
        double leftover = amt;
        while (!toVisit.isEmpty() && leftover > 0.0) {
            IEnergyGridProvider next = (IEnergyGridProvider)toVisit.poll();
            visited.add(next);
            leftover = next.injectProviderPower(leftover, mode);
            for (IEnergyGridProvider iEnergyGridProvider : next.providers()) {
                if (visited.contains(iEnergyGridProvider)) continue;
                toVisit.add(iEnergyGridProvider);
            }
        }
        return leftover;
    }

    @Override
    public double getStoredPower() {
        this.refreshPower();
        return Math.max(0.0, this.globalAvailablePower);
    }

    @Override
    public double getMaxStoredPower() {
        return this.globalMaxPower;
    }

    @Override
    public double getEnergyDemand(double maxRequired) {
        PriorityQueue<IEnergyGridProvider> toVisit = new PriorityQueue<IEnergyGridProvider>(COMPARATOR_LOWEST_PERCENTAGE_FIRST);
        HashSet<IEnergyGridProvider> visited = new HashSet<IEnergyGridProvider>();
        toVisit.add(this);
        double required = 0.0;
        while (!toVisit.isEmpty() && required < maxRequired) {
            IEnergyGridProvider next = (IEnergyGridProvider)toVisit.poll();
            visited.add(next);
            required += next.getProviderEnergyDemand(maxRequired - required);
            for (IEnergyGridProvider iEnergyGridProvider : next.providers()) {
                if (visited.contains(iEnergyGridProvider)) continue;
                toVisit.add(iEnergyGridProvider);
            }
        }
        return required;
    }

    @Override
    public double getProviderStoredEnergy() {
        return this.getStoredPower();
    }

    @Override
    public double getProviderMaxEnergy() {
        return this.getMaxStoredPower();
    }

    @Override
    public void removeNode(IGridNode node, IGridHost machine) {
        IEnergyWatcher watcher;
        IAEPowerStorage ps;
        if (machine instanceof IEnergyGridProvider) {
            this.energyGridProviders.remove((Object)machine);
        }
        GridNode gridNode = (GridNode)node;
        this.drainPerTick -= gridNode.getPreviousDraw();
        if (machine instanceof IAEPowerStorage && (ps = (IAEPowerStorage)((Object)machine)).isAEPublicPowerStorage()) {
            if (ps.getPowerFlow() != AccessRestriction.WRITE) {
                this.globalMaxPower -= ps.getAEMaxPower();
                this.globalAvailablePower -= ps.getAECurrentPower();
            }
            if (!this.ongoingExtractOperation) {
                this.removeProvider(ps);
            } else {
                this.providerToRemove.add(ps);
            }
            if (!this.ongoingInjectOperation) {
                this.removeRequester(ps);
            } else {
                this.requesterToRemove.add(ps);
            }
        }
        if (machine instanceof IEnergyWatcherHost && (watcher = this.watchers.get(node)) != null) {
            watcher.reset();
            this.watchers.remove(node);
        }
    }

    private void addRequester(IAEPowerStorage requester) {
        Preconditions.checkState((!this.ongoingInjectOperation ? 1 : 0) != 0, (Object)"Cannot modify energy requesters while energy is being injected.");
        this.requesters.add(requester);
    }

    private void removeRequester(IAEPowerStorage requester) {
        Preconditions.checkState((!this.ongoingInjectOperation ? 1 : 0) != 0, (Object)"Cannot modify energy requesters while energy is being injected.");
        this.requesters.remove(requester);
    }

    private void addProvider(IAEPowerStorage provider) {
        Preconditions.checkState((!this.ongoingExtractOperation ? 1 : 0) != 0, (Object)"Cannot modify energy providers while energy is being extracted.");
        this.providers.add(provider);
    }

    private void removeProvider(IAEPowerStorage provider) {
        Preconditions.checkState((!this.ongoingExtractOperation ? 1 : 0) != 0, (Object)"Cannot modify energy providers while energy is being extracted.");
        this.providers.remove(provider);
    }

    @Override
    public void addNode(IGridNode node, IGridHost machine) {
        IAEPowerStorage ps;
        if (machine instanceof IEnergyGridProvider) {
            this.energyGridProviders.add((Object)((IEnergyGridProvider)((Object)machine)));
        }
        GridNode gridNode = (GridNode)node;
        IGridBlock gb = gridNode.getGridBlock();
        gridNode.setPreviousDraw(gb.getIdlePowerUsage());
        this.drainPerTick += gridNode.getPreviousDraw();
        if (machine instanceof IAEPowerStorage && (ps = (IAEPowerStorage)((Object)machine)).isAEPublicPowerStorage()) {
            double max = ps.getAEMaxPower();
            double current = ps.getAECurrentPower();
            if (ps.getPowerFlow() != AccessRestriction.WRITE) {
                this.globalMaxPower += ps.getAEMaxPower();
            }
            if (current > 0.0 && ps.getPowerFlow() != AccessRestriction.WRITE) {
                this.globalAvailablePower += current;
                if (!this.ongoingExtractOperation) {
                    this.addProvider(ps);
                } else {
                    this.providersToAdd.add(ps);
                }
            }
            if (current < max && ps.getPowerFlow() != AccessRestriction.READ) {
                if (!this.ongoingInjectOperation) {
                    this.addRequester(ps);
                } else {
                    this.requesterToAdd.add(ps);
                }
            }
        }
        if (machine instanceof IEnergyWatcherHost) {
            IEnergyWatcherHost swh = (IEnergyWatcherHost)((Object)machine);
            EnergyWatcher iw = new EnergyWatcher(this, swh);
            this.watchers.put(node, iw);
            swh.updateWatcher(iw);
        }
        this.myGrid.postEventTo(node, new MENetworkPowerStatusChange());
    }

    @Override
    public void onSplit(IGridStorage storageB) {
        double newBuffer = this.localStorage.getAECurrentPower() / 2.0;
        this.localStorage.removeCurrentAEPower(newBuffer);
        storageB.dataObject().func_74780_a("buffer", newBuffer);
    }

    @Override
    public void onJoin(IGridStorage storageB) {
        this.localStorage.addCurrentAEPower(storageB.dataObject().func_74769_h("buffer"));
    }

    @Override
    public void populateGridStorage(IGridStorage storage) {
        storage.dataObject().func_74780_a("buffer", this.localStorage.getAECurrentPower());
    }

    public boolean registerEnergyInterest(EnergyThreshold threshold) {
        return this.interests.add(threshold);
    }

    public boolean unregisterEnergyInterest(EnergyThreshold threshold) {
        return this.interests.remove(threshold);
    }

    private class GridPowerStorage
    implements IAEPowerStorage {
        private double stored = 0.0;

        private GridPowerStorage() {
        }

        @Override
        public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
            double extracted = Math.min(amt, this.stored);
            if (mode == Actionable.MODULATE) {
                this.removeCurrentAEPower(extracted);
            }
            return extracted;
        }

        @Override
        public boolean isAEPublicPowerStorage() {
            return true;
        }

        @Override
        public double injectAEPower(double amt, Actionable mode) {
            double toStore = Math.min(amt, 800.0 - this.stored);
            if (mode == Actionable.MODULATE) {
                this.addCurrentAEPower(toStore);
            }
            return amt - toStore;
        }

        @Override
        public AccessRestriction getPowerFlow() {
            return AccessRestriction.READ_WRITE;
        }

        @Override
        public double getAEMaxPower() {
            return 800.0;
        }

        @Override
        public double getAECurrentPower() {
            return this.stored;
        }

        private void addCurrentAEPower(double amount) {
            this.stored += amount;
            if (this.stored > 0.01) {
                EnergyGridCache.this.myGrid.postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.PROVIDE_POWER));
            }
        }

        private void removeCurrentAEPower(double amount) {
            this.stored -= amount;
            if (this.stored < 799.999) {
                EnergyGridCache.this.myGrid.postEvent(new MENetworkPowerStorage(this, MENetworkPowerStorage.PowerEventType.REQUEST_POWER));
            }
            if (this.stored < 0.01) {
                EnergyGridCache.this.ticksSinceHasPowerChange = 0L;
                EnergyGridCache.this.publicPowerState(false, EnergyGridCache.this.myGrid);
            }
        }
    }
}

